/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.NodeInterfaceMapping;
import software.amazon.awssdk.services.medialive.model.NodeRole;
import software.amazon.awssdk.services.medialive.model.___listOfNodeInterfaceMappingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNodeRegistrationScriptRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, CreateNodeRegistrationScriptRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(CreateNodeRegistrationScriptRequest.getter(CreateNodeRegistrationScriptRequest::clusterId)).setter(CreateNodeRegistrationScriptRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateNodeRegistrationScriptRequest.getter(CreateNodeRegistrationScriptRequest::id)).setter(CreateNodeRegistrationScriptRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateNodeRegistrationScriptRequest.getter(CreateNodeRegistrationScriptRequest::name)).setter(CreateNodeRegistrationScriptRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<NodeInterfaceMapping>> NODE_INTERFACE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeInterfaceMappings").getter(CreateNodeRegistrationScriptRequest.getter(CreateNodeRegistrationScriptRequest::nodeInterfaceMappings)).setter(CreateNodeRegistrationScriptRequest.setter(Builder::nodeInterfaceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInterfaceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeInterfaceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateNodeRegistrationScriptRequest.getter(CreateNodeRegistrationScriptRequest::requestId)).setter(CreateNodeRegistrationScriptRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateNodeRegistrationScriptRequest.getter(CreateNodeRegistrationScriptRequest::roleAsString)).setter(CreateNodeRegistrationScriptRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, ID_FIELD, NAME_FIELD, NODE_INTERFACE_MAPPINGS_FIELD, REQUEST_ID_FIELD, ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateNodeRegistrationScriptRequest.memberNameToFieldInitializer();
    private final String clusterId;
    private final String id;
    private final String name;
    private final List<NodeInterfaceMapping> nodeInterfaceMappings;
    private final String requestId;
    private final String role;

    private CreateNodeRegistrationScriptRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.id = builder.id;
        this.name = builder.name;
        this.nodeInterfaceMappings = builder.nodeInterfaceMappings;
        this.requestId = builder.requestId;
        this.role = builder.role;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNodeInterfaceMappings() {
        return this.nodeInterfaceMappings != null && !(this.nodeInterfaceMappings instanceof SdkAutoConstructList);
    }

    public final List<NodeInterfaceMapping> nodeInterfaceMappings() {
        return this.nodeInterfaceMappings;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final NodeRole role() {
        return NodeRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeInterfaceMappings() ? this.nodeInterfaceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodeRegistrationScriptRequest)) {
            return false;
        }
        CreateNodeRegistrationScriptRequest other = (CreateNodeRegistrationScriptRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && this.hasNodeInterfaceMappings() == other.hasNodeInterfaceMappings() && Objects.equals(this.nodeInterfaceMappings(), other.nodeInterfaceMappings()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.roleAsString(), other.roleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNodeRegistrationScriptRequest").add("ClusterId", (Object)this.clusterId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("NodeInterfaceMappings", this.hasNodeInterfaceMappings() ? this.nodeInterfaceMappings() : null).add("RequestId", (Object)this.requestId()).add("Role", (Object)this.roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NodeInterfaceMappings": {
                return Optional.ofNullable(clazz.cast(this.nodeInterfaceMappings()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("nodeInterfaceMappings", NODE_INTERFACE_MAPPINGS_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("role", ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNodeRegistrationScriptRequest, T> g) {
        return obj -> g.apply((CreateNodeRegistrationScriptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private String id;
        private String name;
        private List<NodeInterfaceMapping> nodeInterfaceMappings = DefaultSdkAutoConstructList.getInstance();
        private String requestId;
        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodeRegistrationScriptRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.id(model.id);
            this.name(model.name);
            this.nodeInterfaceMappings(model.nodeInterfaceMappings);
            this.requestId(model.requestId);
            this.role(model.role);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<NodeInterfaceMapping.Builder> getNodeInterfaceMappings() {
            List<NodeInterfaceMapping.Builder> result = ___listOfNodeInterfaceMappingCopier.copyToBuilder(this.nodeInterfaceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeInterfaceMappings(Collection<NodeInterfaceMapping.BuilderImpl> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCopier.copyFromBuilder(nodeInterfaceMappings);
        }

        @Override
        public final Builder nodeInterfaceMappings(Collection<NodeInterfaceMapping> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCopier.copy(nodeInterfaceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(NodeInterfaceMapping ... nodeInterfaceMappings) {
            this.nodeInterfaceMappings(Arrays.asList(nodeInterfaceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(Consumer<NodeInterfaceMapping.Builder> ... nodeInterfaceMappings) {
            this.nodeInterfaceMappings(Stream.of(nodeInterfaceMappings).map(c -> (NodeInterfaceMapping)((NodeInterfaceMapping.Builder)NodeInterfaceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(NodeRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNodeRegistrationScriptRequest build() {
            return new CreateNodeRegistrationScriptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNodeRegistrationScriptRequest> {
        public Builder clusterId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder nodeInterfaceMappings(Collection<NodeInterfaceMapping> var1);

        public Builder nodeInterfaceMappings(NodeInterfaceMapping ... var1);

        public Builder nodeInterfaceMappings(Consumer<NodeInterfaceMapping.Builder> ... var1);

        public Builder requestId(String var1);

        public Builder role(String var1);

        public Builder role(NodeRole var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

