/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InterfaceMappingCreateRequest;
import software.amazon.awssdk.services.medialive.model.___listOfInterfaceMappingCreateRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterNetworkSettingsCreateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterNetworkSettingsCreateRequest> {
    private static final SdkField<String> DEFAULT_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRoute").getter(ClusterNetworkSettingsCreateRequest.getter(ClusterNetworkSettingsCreateRequest::defaultRoute)).setter(ClusterNetworkSettingsCreateRequest.setter(Builder::defaultRoute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultRoute").build()}).build();
    private static final SdkField<List<InterfaceMappingCreateRequest>> INTERFACE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InterfaceMappings").getter(ClusterNetworkSettingsCreateRequest.getter(ClusterNetworkSettingsCreateRequest::interfaceMappings)).setter(ClusterNetworkSettingsCreateRequest.setter(Builder::interfaceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InterfaceMappingCreateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ROUTE_FIELD, INTERFACE_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterNetworkSettingsCreateRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultRoute;
    private final List<InterfaceMappingCreateRequest> interfaceMappings;

    private ClusterNetworkSettingsCreateRequest(BuilderImpl builder) {
        this.defaultRoute = builder.defaultRoute;
        this.interfaceMappings = builder.interfaceMappings;
    }

    public final String defaultRoute() {
        return this.defaultRoute;
    }

    public final boolean hasInterfaceMappings() {
        return this.interfaceMappings != null && !(this.interfaceMappings instanceof SdkAutoConstructList);
    }

    public final List<InterfaceMappingCreateRequest> interfaceMappings() {
        return this.interfaceMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInterfaceMappings() ? this.interfaceMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNetworkSettingsCreateRequest)) {
            return false;
        }
        ClusterNetworkSettingsCreateRequest other = (ClusterNetworkSettingsCreateRequest)obj;
        return Objects.equals(this.defaultRoute(), other.defaultRoute()) && this.hasInterfaceMappings() == other.hasInterfaceMappings() && Objects.equals(this.interfaceMappings(), other.interfaceMappings());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterNetworkSettingsCreateRequest").add("DefaultRoute", (Object)this.defaultRoute()).add("InterfaceMappings", this.hasInterfaceMappings() ? this.interfaceMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultRoute": {
                return Optional.ofNullable(clazz.cast(this.defaultRoute()));
            }
            case "InterfaceMappings": {
                return Optional.ofNullable(clazz.cast(this.interfaceMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultRoute", DEFAULT_ROUTE_FIELD);
        map.put("interfaceMappings", INTERFACE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterNetworkSettingsCreateRequest, T> g) {
        return obj -> g.apply((ClusterNetworkSettingsCreateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultRoute;
        private List<InterfaceMappingCreateRequest> interfaceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNetworkSettingsCreateRequest model) {
            this.defaultRoute(model.defaultRoute);
            this.interfaceMappings(model.interfaceMappings);
        }

        public final String getDefaultRoute() {
            return this.defaultRoute;
        }

        public final void setDefaultRoute(String defaultRoute) {
            this.defaultRoute = defaultRoute;
        }

        @Override
        public final Builder defaultRoute(String defaultRoute) {
            this.defaultRoute = defaultRoute;
            return this;
        }

        public final List<InterfaceMappingCreateRequest.Builder> getInterfaceMappings() {
            List<InterfaceMappingCreateRequest.Builder> result = ___listOfInterfaceMappingCreateRequestCopier.copyToBuilder(this.interfaceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterfaceMappings(Collection<InterfaceMappingCreateRequest.BuilderImpl> interfaceMappings) {
            this.interfaceMappings = ___listOfInterfaceMappingCreateRequestCopier.copyFromBuilder(interfaceMappings);
        }

        @Override
        public final Builder interfaceMappings(Collection<InterfaceMappingCreateRequest> interfaceMappings) {
            this.interfaceMappings = ___listOfInterfaceMappingCreateRequestCopier.copy(interfaceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceMappings(InterfaceMappingCreateRequest ... interfaceMappings) {
            this.interfaceMappings(Arrays.asList(interfaceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceMappings(Consumer<InterfaceMappingCreateRequest.Builder> ... interfaceMappings) {
            this.interfaceMappings(Stream.of(interfaceMappings).map(c -> (InterfaceMappingCreateRequest)((InterfaceMappingCreateRequest.Builder)InterfaceMappingCreateRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ClusterNetworkSettingsCreateRequest build() {
            return new ClusterNetworkSettingsCreateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterNetworkSettingsCreateRequest> {
        public Builder defaultRoute(String var1);

        public Builder interfaceMappings(Collection<InterfaceMappingCreateRequest> var1);

        public Builder interfaceMappings(InterfaceMappingCreateRequest ... var1);

        public Builder interfaceMappings(Consumer<InterfaceMappingCreateRequest.Builder> ... var1);
    }
}

