/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.MultiplexSettingsSummary;
import software.amazon.awssdk.services.medialive.model.MultiplexState;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiplexSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiplexSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(MultiplexSummary.getter(MultiplexSummary::arn)).setter(MultiplexSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(MultiplexSummary.getter(MultiplexSummary::availabilityZones)).setter(MultiplexSummary.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(MultiplexSummary.getter(MultiplexSummary::id)).setter(MultiplexSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<MultiplexSettingsSummary> MULTIPLEX_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiplexSettings").getter(MultiplexSummary.getter(MultiplexSummary::multiplexSettings)).setter(MultiplexSummary.setter(Builder::multiplexSettings)).constructor(MultiplexSettingsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexSettings").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MultiplexSummary.getter(MultiplexSummary::name)).setter(MultiplexSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PIPELINES_RUNNING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PipelinesRunningCount").getter(MultiplexSummary.getter(MultiplexSummary::pipelinesRunningCount)).setter(MultiplexSummary.setter(Builder::pipelinesRunningCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelinesRunningCount").build()}).build();
    private static final SdkField<Integer> PROGRAM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramCount").getter(MultiplexSummary.getter(MultiplexSummary::programCount)).setter(MultiplexSummary.setter(Builder::programCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programCount").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(MultiplexSummary.getter(MultiplexSummary::stateAsString)).setter(MultiplexSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(MultiplexSummary.getter(MultiplexSummary::tags)).setter(MultiplexSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AVAILABILITY_ZONES_FIELD, ID_FIELD, MULTIPLEX_SETTINGS_FIELD, NAME_FIELD, PIPELINES_RUNNING_COUNT_FIELD, PROGRAM_COUNT_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MultiplexSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<String> availabilityZones;
    private final String id;
    private final MultiplexSettingsSummary multiplexSettings;
    private final String name;
    private final Integer pipelinesRunningCount;
    private final Integer programCount;
    private final String state;
    private final Map<String, String> tags;

    private MultiplexSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.availabilityZones = builder.availabilityZones;
        this.id = builder.id;
        this.multiplexSettings = builder.multiplexSettings;
        this.name = builder.name;
        this.pipelinesRunningCount = builder.pipelinesRunningCount;
        this.programCount = builder.programCount;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final String id() {
        return this.id;
    }

    public final MultiplexSettingsSummary multiplexSettings() {
        return this.multiplexSettings;
    }

    public final String name() {
        return this.name;
    }

    public final Integer pipelinesRunningCount() {
        return this.pipelinesRunningCount;
    }

    public final Integer programCount() {
        return this.programCount;
    }

    public final MultiplexState state() {
        return MultiplexState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelinesRunningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.programCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexSummary)) {
            return false;
        }
        MultiplexSummary other = (MultiplexSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.multiplexSettings(), other.multiplexSettings()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pipelinesRunningCount(), other.pipelinesRunningCount()) && Objects.equals(this.programCount(), other.programCount()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"MultiplexSummary").add("Arn", (Object)this.arn()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("Id", (Object)this.id()).add("MultiplexSettings", (Object)this.multiplexSettings()).add("Name", (Object)this.name()).add("PipelinesRunningCount", (Object)this.pipelinesRunningCount()).add("ProgramCount", (Object)this.programCount()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MultiplexSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexSettings()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PipelinesRunningCount": {
                return Optional.ofNullable(clazz.cast(this.pipelinesRunningCount()));
            }
            case "ProgramCount": {
                return Optional.ofNullable(clazz.cast(this.programCount()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("availabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("id", ID_FIELD);
        map.put("multiplexSettings", MULTIPLEX_SETTINGS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("pipelinesRunningCount", PIPELINES_RUNNING_COUNT_FIELD);
        map.put("programCount", PROGRAM_COUNT_FIELD);
        map.put("state", STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiplexSummary, T> g) {
        return obj -> g.apply((MultiplexSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private MultiplexSettingsSummary multiplexSettings;
        private String name;
        private Integer pipelinesRunningCount;
        private Integer programCount;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexSummary model) {
            this.arn(model.arn);
            this.availabilityZones(model.availabilityZones);
            this.id(model.id);
            this.multiplexSettings(model.multiplexSettings);
            this.name(model.name);
            this.pipelinesRunningCount(model.pipelinesRunningCount);
            this.programCount(model.programCount);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ___listOf__stringCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ___listOf__stringCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MultiplexSettingsSummary.Builder getMultiplexSettings() {
            return this.multiplexSettings != null ? this.multiplexSettings.toBuilder() : null;
        }

        public final void setMultiplexSettings(MultiplexSettingsSummary.BuilderImpl multiplexSettings) {
            this.multiplexSettings = multiplexSettings != null ? multiplexSettings.build() : null;
        }

        @Override
        public final Builder multiplexSettings(MultiplexSettingsSummary multiplexSettings) {
            this.multiplexSettings = multiplexSettings;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPipelinesRunningCount() {
            return this.pipelinesRunningCount;
        }

        public final void setPipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
        }

        @Override
        public final Builder pipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
            return this;
        }

        public final Integer getProgramCount() {
            return this.programCount;
        }

        public final void setProgramCount(Integer programCount) {
            this.programCount = programCount;
        }

        @Override
        public final Builder programCount(Integer programCount) {
            this.programCount = programCount;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(MultiplexState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public MultiplexSummary build() {
            return new MultiplexSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiplexSummary> {
        public Builder arn(String var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder id(String var1);

        public Builder multiplexSettings(MultiplexSettingsSummary var1);

        default public Builder multiplexSettings(Consumer<MultiplexSettingsSummary.Builder> multiplexSettings) {
            return this.multiplexSettings((MultiplexSettingsSummary)((MultiplexSettingsSummary.Builder)MultiplexSettingsSummary.builder().applyMutation(multiplexSettings)).build());
        }

        public Builder name(String var1);

        public Builder pipelinesRunningCount(Integer var1);

        public Builder programCount(Integer var1);

        public Builder state(String var1);

        public Builder state(MultiplexState var1);

        public Builder tags(Map<String, String> var1);
    }
}

