/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListSdiSourcesRequest;
import software.amazon.awssdk.services.medialive.model.ListSdiSourcesResponse;
import software.amazon.awssdk.services.medialive.model.SdiSourceSummary;

public class ListSdiSourcesIterable
implements SdkIterable<ListSdiSourcesResponse> {
    private final MediaLiveClient client;
    private final ListSdiSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSdiSourcesIterable(MediaLiveClient client, ListSdiSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSdiSourcesResponseFetcher();
    }

    public Iterator<ListSdiSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SdiSourceSummary> sdiSources() {
        Function<ListSdiSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sdiSources() != null) {
                return response.sdiSources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSdiSourcesResponseFetcher
    implements SyncPageFetcher<ListSdiSourcesResponse> {
        private ListSdiSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListSdiSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSdiSourcesResponse nextPage(ListSdiSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListSdiSourcesIterable.this.client.listSdiSources(ListSdiSourcesIterable.this.firstRequest);
            }
            return ListSdiSourcesIterable.this.client.listSdiSources((ListSdiSourcesRequest)((Object)ListSdiSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

