/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.SdiSourceMode;
import software.amazon.awssdk.services.medialive.model.SdiSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSdiSourceRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateSdiSourceRequest> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(UpdateSdiSourceRequest.getter(UpdateSdiSourceRequest::modeAsString)).setter(UpdateSdiSourceRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateSdiSourceRequest.getter(UpdateSdiSourceRequest::name)).setter(UpdateSdiSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SDI_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SdiSourceId").getter(UpdateSdiSourceRequest.getter(UpdateSdiSourceRequest::sdiSourceId)).setter(UpdateSdiSourceRequest.setter(Builder::sdiSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sdiSourceId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(UpdateSdiSourceRequest.getter(UpdateSdiSourceRequest::typeAsString)).setter(UpdateSdiSourceRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, NAME_FIELD, SDI_SOURCE_ID_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSdiSourceRequest.memberNameToFieldInitializer();
    private final String mode;
    private final String name;
    private final String sdiSourceId;
    private final String type;

    private UpdateSdiSourceRequest(BuilderImpl builder) {
        super(builder);
        this.mode = builder.mode;
        this.name = builder.name;
        this.sdiSourceId = builder.sdiSourceId;
        this.type = builder.type;
    }

    public final SdiSourceMode mode() {
        return SdiSourceMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final String name() {
        return this.name;
    }

    public final String sdiSourceId() {
        return this.sdiSourceId;
    }

    public final SdiSourceType type() {
        return SdiSourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sdiSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSdiSourceRequest)) {
            return false;
        }
        UpdateSdiSourceRequest other = (UpdateSdiSourceRequest)((Object)obj);
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sdiSourceId(), other.sdiSourceId()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSdiSourceRequest").add("Mode", (Object)this.modeAsString()).add("Name", (Object)this.name()).add("SdiSourceId", (Object)this.sdiSourceId()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SdiSourceId": {
                return Optional.ofNullable(clazz.cast(this.sdiSourceId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("mode", MODE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sdiSourceId", SDI_SOURCE_ID_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSdiSourceRequest, T> g) {
        return obj -> g.apply((UpdateSdiSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String mode;
        private String name;
        private String sdiSourceId;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSdiSourceRequest model) {
            super(model);
            this.mode(model.mode);
            this.name(model.name);
            this.sdiSourceId(model.sdiSourceId);
            this.type(model.type);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(SdiSourceMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSdiSourceId() {
            return this.sdiSourceId;
        }

        public final void setSdiSourceId(String sdiSourceId) {
            this.sdiSourceId = sdiSourceId;
        }

        @Override
        public final Builder sdiSourceId(String sdiSourceId) {
            this.sdiSourceId = sdiSourceId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SdiSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSdiSourceRequest build() {
            return new UpdateSdiSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSdiSourceRequest> {
        public Builder mode(String var1);

        public Builder mode(SdiSourceMode var1);

        public Builder name(String var1);

        public Builder sdiSourceId(String var1);

        public Builder type(String var1);

        public Builder type(SdiSourceType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

