/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.OfferingDurationUnits;
import software.amazon.awssdk.services.medialive.model.OfferingType;
import software.amazon.awssdk.services.medialive.model.RenewalSettings;
import software.amazon.awssdk.services.medialive.model.ReservationResourceSpecification;
import software.amazon.awssdk.services.medialive.model.ReservationState;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Reservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Reservation> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Reservation.getter(Reservation::arn)).setter(Reservation.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(Reservation.getter(Reservation::count)).setter(Reservation.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(Reservation.getter(Reservation::currencyCode)).setter(Reservation.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(Reservation.getter(Reservation::duration)).setter(Reservation.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<String> DURATION_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurationUnits").getter(Reservation.getter(Reservation::durationUnitsAsString)).setter(Reservation.setter(Builder::durationUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationUnits").build()}).build();
    private static final SdkField<String> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("End").getter(Reservation.getter(Reservation::end)).setter(Reservation.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedPrice").getter(Reservation.getter(Reservation::fixedPrice)).setter(Reservation.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedPrice").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Reservation.getter(Reservation::name)).setter(Reservation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OFFERING_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingDescription").getter(Reservation.getter(Reservation::offeringDescription)).setter(Reservation.setter(Builder::offeringDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringDescription").build()}).build();
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingId").getter(Reservation.getter(Reservation::offeringId)).setter(Reservation.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(Reservation.getter(Reservation::offeringTypeAsString)).setter(Reservation.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Reservation.getter(Reservation::region)).setter(Reservation.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<RenewalSettings> RENEWAL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RenewalSettings").getter(Reservation.getter(Reservation::renewalSettings)).setter(Reservation.setter(Builder::renewalSettings)).constructor(RenewalSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalSettings").build()}).build();
    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationId").getter(Reservation.getter(Reservation::reservationId)).setter(Reservation.setter(Builder::reservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationId").build()}).build();
    private static final SdkField<ReservationResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceSpecification").getter(Reservation.getter(Reservation::resourceSpecification)).setter(Reservation.setter(Builder::resourceSpecification)).constructor(ReservationResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final SdkField<String> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Start").getter(Reservation.getter(Reservation::start)).setter(Reservation.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Reservation.getter(Reservation::stateAsString)).setter(Reservation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Reservation.getter(Reservation::tags)).setter(Reservation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UsagePrice").getter(Reservation.getter(Reservation::usagePrice)).setter(Reservation.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usagePrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COUNT_FIELD, CURRENCY_CODE_FIELD, DURATION_FIELD, DURATION_UNITS_FIELD, END_FIELD, FIXED_PRICE_FIELD, NAME_FIELD, OFFERING_DESCRIPTION_FIELD, OFFERING_ID_FIELD, OFFERING_TYPE_FIELD, REGION_FIELD, RENEWAL_SETTINGS_FIELD, RESERVATION_ID_FIELD, RESOURCE_SPECIFICATION_FIELD, START_FIELD, STATE_FIELD, TAGS_FIELD, USAGE_PRICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Reservation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Integer count;
    private final String currencyCode;
    private final Integer duration;
    private final String durationUnits;
    private final String end;
    private final Double fixedPrice;
    private final String name;
    private final String offeringDescription;
    private final String offeringId;
    private final String offeringType;
    private final String region;
    private final RenewalSettings renewalSettings;
    private final String reservationId;
    private final ReservationResourceSpecification resourceSpecification;
    private final String start;
    private final String state;
    private final Map<String, String> tags;
    private final Double usagePrice;

    private Reservation(BuilderImpl builder) {
        this.arn = builder.arn;
        this.count = builder.count;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.durationUnits = builder.durationUnits;
        this.end = builder.end;
        this.fixedPrice = builder.fixedPrice;
        this.name = builder.name;
        this.offeringDescription = builder.offeringDescription;
        this.offeringId = builder.offeringId;
        this.offeringType = builder.offeringType;
        this.region = builder.region;
        this.renewalSettings = builder.renewalSettings;
        this.reservationId = builder.reservationId;
        this.resourceSpecification = builder.resourceSpecification;
        this.start = builder.start;
        this.state = builder.state;
        this.tags = builder.tags;
        this.usagePrice = builder.usagePrice;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer count() {
        return this.count;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final OfferingDurationUnits durationUnits() {
        return OfferingDurationUnits.fromValue(this.durationUnits);
    }

    public final String durationUnitsAsString() {
        return this.durationUnits;
    }

    public final String end() {
        return this.end;
    }

    public final Double fixedPrice() {
        return this.fixedPrice;
    }

    public final String name() {
        return this.name;
    }

    public final String offeringDescription() {
        return this.offeringDescription;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    public final OfferingType offeringType() {
        return OfferingType.fromValue(this.offeringType);
    }

    public final String offeringTypeAsString() {
        return this.offeringType;
    }

    public final String region() {
        return this.region;
    }

    public final RenewalSettings renewalSettings() {
        return this.renewalSettings;
    }

    public final String reservationId() {
        return this.reservationId;
    }

    public final ReservationResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public final String start() {
        return this.start;
    }

    public final ReservationState state() {
        return ReservationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Double usagePrice() {
        return this.usagePrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.durationUnitsAsString(), other.durationUnitsAsString()) && Objects.equals(this.end(), other.end()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.offeringDescription(), other.offeringDescription()) && Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.offeringTypeAsString(), other.offeringTypeAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.renewalSettings(), other.renewalSettings()) && Objects.equals(this.reservationId(), other.reservationId()) && Objects.equals(this.resourceSpecification(), other.resourceSpecification()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.usagePrice(), other.usagePrice());
    }

    public final String toString() {
        return ToString.builder((String)"Reservation").add("Arn", (Object)this.arn()).add("Count", (Object)this.count()).add("CurrencyCode", (Object)this.currencyCode()).add("Duration", (Object)this.duration()).add("DurationUnits", (Object)this.durationUnitsAsString()).add("End", (Object)this.end()).add("FixedPrice", (Object)this.fixedPrice()).add("Name", (Object)this.name()).add("OfferingDescription", (Object)this.offeringDescription()).add("OfferingId", (Object)this.offeringId()).add("OfferingType", (Object)this.offeringTypeAsString()).add("Region", (Object)this.region()).add("RenewalSettings", (Object)this.renewalSettings()).add("ReservationId", (Object)this.reservationId()).add("ResourceSpecification", (Object)this.resourceSpecification()).add("Start", (Object)this.start()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("UsagePrice", (Object)this.usagePrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "DurationUnits": {
                return Optional.ofNullable(clazz.cast(this.durationUnitsAsString()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OfferingDescription": {
                return Optional.ofNullable(clazz.cast(this.offeringDescription()));
            }
            case "OfferingId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringTypeAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "RenewalSettings": {
                return Optional.ofNullable(clazz.cast(this.renewalSettings()));
            }
            case "ReservationId": {
                return Optional.ofNullable(clazz.cast(this.reservationId()));
            }
            case "ResourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("count", COUNT_FIELD);
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("duration", DURATION_FIELD);
        map.put("durationUnits", DURATION_UNITS_FIELD);
        map.put("end", END_FIELD);
        map.put("fixedPrice", FIXED_PRICE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("offeringDescription", OFFERING_DESCRIPTION_FIELD);
        map.put("offeringId", OFFERING_ID_FIELD);
        map.put("offeringType", OFFERING_TYPE_FIELD);
        map.put("region", REGION_FIELD);
        map.put("renewalSettings", RENEWAL_SETTINGS_FIELD);
        map.put("reservationId", RESERVATION_ID_FIELD);
        map.put("resourceSpecification", RESOURCE_SPECIFICATION_FIELD);
        map.put("start", START_FIELD);
        map.put("state", STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("usagePrice", USAGE_PRICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Reservation, T> g) {
        return obj -> g.apply((Reservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Integer count;
        private String currencyCode;
        private Integer duration;
        private String durationUnits;
        private String end;
        private Double fixedPrice;
        private String name;
        private String offeringDescription;
        private String offeringId;
        private String offeringType;
        private String region;
        private RenewalSettings renewalSettings;
        private String reservationId;
        private ReservationResourceSpecification resourceSpecification;
        private String start;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Double usagePrice;

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            this.arn(model.arn);
            this.count(model.count);
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.durationUnits(model.durationUnits);
            this.end(model.end);
            this.fixedPrice(model.fixedPrice);
            this.name(model.name);
            this.offeringDescription(model.offeringDescription);
            this.offeringId(model.offeringId);
            this.offeringType(model.offeringType);
            this.region(model.region);
            this.renewalSettings(model.renewalSettings);
            this.reservationId(model.reservationId);
            this.resourceSpecification(model.resourceSpecification);
            this.start(model.start);
            this.state(model.state);
            this.tags(model.tags);
            this.usagePrice(model.usagePrice);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getDurationUnits() {
            return this.durationUnits;
        }

        public final void setDurationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
        }

        @Override
        public final Builder durationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
            return this;
        }

        @Override
        public final Builder durationUnits(OfferingDurationUnits durationUnits) {
            this.durationUnits(durationUnits == null ? null : durationUnits.toString());
            return this;
        }

        public final String getEnd() {
            return this.end;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOfferingDescription() {
            return this.offeringDescription;
        }

        public final void setOfferingDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
        }

        @Override
        public final Builder offeringDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
            return this;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingType offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final RenewalSettings.Builder getRenewalSettings() {
            return this.renewalSettings != null ? this.renewalSettings.toBuilder() : null;
        }

        public final void setRenewalSettings(RenewalSettings.BuilderImpl renewalSettings) {
            this.renewalSettings = renewalSettings != null ? renewalSettings.build() : null;
        }

        @Override
        public final Builder renewalSettings(RenewalSettings renewalSettings) {
            this.renewalSettings = renewalSettings;
            return this;
        }

        public final String getReservationId() {
            return this.reservationId;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final ReservationResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ReservationResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ReservationResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getStart() {
            return this.start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public Reservation build() {
            return new Reservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Reservation> {
        public Builder arn(String var1);

        public Builder count(Integer var1);

        public Builder currencyCode(String var1);

        public Builder duration(Integer var1);

        public Builder durationUnits(String var1);

        public Builder durationUnits(OfferingDurationUnits var1);

        public Builder end(String var1);

        public Builder fixedPrice(Double var1);

        public Builder name(String var1);

        public Builder offeringDescription(String var1);

        public Builder offeringId(String var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingType var1);

        public Builder region(String var1);

        public Builder renewalSettings(RenewalSettings var1);

        default public Builder renewalSettings(Consumer<RenewalSettings.Builder> renewalSettings) {
            return this.renewalSettings((RenewalSettings)((RenewalSettings.Builder)RenewalSettings.builder().applyMutation(renewalSettings)).build());
        }

        public Builder reservationId(String var1);

        public Builder resourceSpecification(ReservationResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ReservationResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ReservationResourceSpecification)((ReservationResourceSpecification.Builder)ReservationResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }

        public Builder start(String var1);

        public Builder state(String var1);

        public Builder state(ReservationState var1);

        public Builder tags(Map<String, String> var1);

        public Builder usagePrice(Double var1);
    }
}

