/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaResourceNeighbor;
import software.amazon.awssdk.services.medialive.model.___listOfMediaResourceNeighborCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaResource> {
    private static final SdkField<List<MediaResourceNeighbor>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(MediaResource.getter(MediaResource::destinations)).setter(MediaResource.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaResourceNeighbor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MediaResource.getter(MediaResource::name)).setter(MediaResource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<MediaResourceNeighbor>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(MediaResource.getter(MediaResource::sources)).setter(MediaResource.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaResourceNeighbor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD, NAME_FIELD, SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MediaResourceNeighbor> destinations;
    private final String name;
    private final List<MediaResourceNeighbor> sources;

    private MediaResource(BuilderImpl builder) {
        this.destinations = builder.destinations;
        this.name = builder.name;
        this.sources = builder.sources;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<MediaResourceNeighbor> destinations() {
        return this.destinations;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<MediaResourceNeighbor> sources() {
        return this.sources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaResource)) {
            return false;
        }
        MediaResource other = (MediaResource)obj;
        return this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.name(), other.name()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public final String toString() {
        return ToString.builder((String)"MediaResource").add("Destinations", this.hasDestinations() ? this.destinations() : null).add("Name", (Object)this.name()).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sources", SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaResource, T> g) {
        return obj -> g.apply((MediaResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MediaResourceNeighbor> destinations = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<MediaResourceNeighbor> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MediaResource model) {
            this.destinations(model.destinations);
            this.name(model.name);
            this.sources(model.sources);
        }

        public final List<MediaResourceNeighbor.Builder> getDestinations() {
            List<MediaResourceNeighbor.Builder> result = ___listOfMediaResourceNeighborCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<MediaResourceNeighbor.BuilderImpl> destinations) {
            this.destinations = ___listOfMediaResourceNeighborCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<MediaResourceNeighbor> destinations) {
            this.destinations = ___listOfMediaResourceNeighborCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(MediaResourceNeighbor ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<MediaResourceNeighbor.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (MediaResourceNeighbor)((MediaResourceNeighbor.Builder)MediaResourceNeighbor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<MediaResourceNeighbor.Builder> getSources() {
            List<MediaResourceNeighbor.Builder> result = ___listOfMediaResourceNeighborCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<MediaResourceNeighbor.BuilderImpl> sources) {
            this.sources = ___listOfMediaResourceNeighborCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<MediaResourceNeighbor> sources) {
            this.sources = ___listOfMediaResourceNeighborCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(MediaResourceNeighbor ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<MediaResourceNeighbor.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (MediaResourceNeighbor)((MediaResourceNeighbor.Builder)MediaResourceNeighbor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MediaResource build() {
            return new MediaResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaResource> {
        public Builder destinations(Collection<MediaResourceNeighbor> var1);

        public Builder destinations(MediaResourceNeighbor ... var1);

        public Builder destinations(Consumer<MediaResourceNeighbor.Builder> ... var1);

        public Builder name(String var1);

        public Builder sources(Collection<MediaResourceNeighbor> var1);

        public Builder sources(MediaResourceNeighbor ... var1);

        public Builder sources(Consumer<MediaResourceNeighbor.Builder> ... var1);
    }
}

