/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.SrtCallerDecryptionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SrtCallerSourceRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SrtCallerSourceRequest> {
    private static final SdkField<SrtCallerDecryptionRequest> DECRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Decryption").getter(SrtCallerSourceRequest.getter(SrtCallerSourceRequest::decryption)).setter(SrtCallerSourceRequest.setter(Builder::decryption)).constructor(SrtCallerDecryptionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()}).build();
    private static final SdkField<Integer> MINIMUM_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumLatency").getter(SrtCallerSourceRequest.getter(SrtCallerSourceRequest::minimumLatency)).setter(SrtCallerSourceRequest.setter(Builder::minimumLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLatency").build()}).build();
    private static final SdkField<String> SRT_LISTENER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SrtListenerAddress").getter(SrtCallerSourceRequest.getter(SrtCallerSourceRequest::srtListenerAddress)).setter(SrtCallerSourceRequest.setter(Builder::srtListenerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtListenerAddress").build()}).build();
    private static final SdkField<String> SRT_LISTENER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SrtListenerPort").getter(SrtCallerSourceRequest.getter(SrtCallerSourceRequest::srtListenerPort)).setter(SrtCallerSourceRequest.setter(Builder::srtListenerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtListenerPort").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(SrtCallerSourceRequest.getter(SrtCallerSourceRequest::streamId)).setter(SrtCallerSourceRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_FIELD, MINIMUM_LATENCY_FIELD, SRT_LISTENER_ADDRESS_FIELD, SRT_LISTENER_PORT_FIELD, STREAM_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SrtCallerSourceRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SrtCallerDecryptionRequest decryption;
    private final Integer minimumLatency;
    private final String srtListenerAddress;
    private final String srtListenerPort;
    private final String streamId;

    private SrtCallerSourceRequest(BuilderImpl builder) {
        this.decryption = builder.decryption;
        this.minimumLatency = builder.minimumLatency;
        this.srtListenerAddress = builder.srtListenerAddress;
        this.srtListenerPort = builder.srtListenerPort;
        this.streamId = builder.streamId;
    }

    public final SrtCallerDecryptionRequest decryption() {
        return this.decryption;
    }

    public final Integer minimumLatency() {
        return this.minimumLatency;
    }

    public final String srtListenerAddress() {
        return this.srtListenerAddress;
    }

    public final String srtListenerPort() {
        return this.srtListenerPort;
    }

    public final String streamId() {
        return this.streamId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.srtListenerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.srtListenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtCallerSourceRequest)) {
            return false;
        }
        SrtCallerSourceRequest other = (SrtCallerSourceRequest)obj;
        return Objects.equals(this.decryption(), other.decryption()) && Objects.equals(this.minimumLatency(), other.minimumLatency()) && Objects.equals(this.srtListenerAddress(), other.srtListenerAddress()) && Objects.equals(this.srtListenerPort(), other.srtListenerPort()) && Objects.equals(this.streamId(), other.streamId());
    }

    public final String toString() {
        return ToString.builder((String)"SrtCallerSourceRequest").add("Decryption", (Object)this.decryption()).add("MinimumLatency", (Object)this.minimumLatency()).add("SrtListenerAddress", (Object)this.srtListenerAddress()).add("SrtListenerPort", (Object)this.srtListenerPort()).add("StreamId", (Object)this.streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Decryption": {
                return Optional.ofNullable(clazz.cast(this.decryption()));
            }
            case "MinimumLatency": {
                return Optional.ofNullable(clazz.cast(this.minimumLatency()));
            }
            case "SrtListenerAddress": {
                return Optional.ofNullable(clazz.cast(this.srtListenerAddress()));
            }
            case "SrtListenerPort": {
                return Optional.ofNullable(clazz.cast(this.srtListenerPort()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("decryption", DECRYPTION_FIELD);
        map.put("minimumLatency", MINIMUM_LATENCY_FIELD);
        map.put("srtListenerAddress", SRT_LISTENER_ADDRESS_FIELD);
        map.put("srtListenerPort", SRT_LISTENER_PORT_FIELD);
        map.put("streamId", STREAM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtCallerSourceRequest, T> g) {
        return obj -> g.apply((SrtCallerSourceRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SrtCallerDecryptionRequest decryption;
        private Integer minimumLatency;
        private String srtListenerAddress;
        private String srtListenerPort;
        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtCallerSourceRequest model) {
            this.decryption(model.decryption);
            this.minimumLatency(model.minimumLatency);
            this.srtListenerAddress(model.srtListenerAddress);
            this.srtListenerPort(model.srtListenerPort);
            this.streamId(model.streamId);
        }

        public final SrtCallerDecryptionRequest.Builder getDecryption() {
            return this.decryption != null ? this.decryption.toBuilder() : null;
        }

        public final void setDecryption(SrtCallerDecryptionRequest.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        @Override
        public final Builder decryption(SrtCallerDecryptionRequest decryption) {
            this.decryption = decryption;
            return this;
        }

        public final Integer getMinimumLatency() {
            return this.minimumLatency;
        }

        public final void setMinimumLatency(Integer minimumLatency) {
            this.minimumLatency = minimumLatency;
        }

        @Override
        public final Builder minimumLatency(Integer minimumLatency) {
            this.minimumLatency = minimumLatency;
            return this;
        }

        public final String getSrtListenerAddress() {
            return this.srtListenerAddress;
        }

        public final void setSrtListenerAddress(String srtListenerAddress) {
            this.srtListenerAddress = srtListenerAddress;
        }

        @Override
        public final Builder srtListenerAddress(String srtListenerAddress) {
            this.srtListenerAddress = srtListenerAddress;
            return this;
        }

        public final String getSrtListenerPort() {
            return this.srtListenerPort;
        }

        public final void setSrtListenerPort(String srtListenerPort) {
            this.srtListenerPort = srtListenerPort;
        }

        @Override
        public final Builder srtListenerPort(String srtListenerPort) {
            this.srtListenerPort = srtListenerPort;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public SrtCallerSourceRequest build() {
            return new SrtCallerSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SrtCallerSourceRequest> {
        public Builder decryption(SrtCallerDecryptionRequest var1);

        default public Builder decryption(Consumer<SrtCallerDecryptionRequest.Builder> decryption) {
            return this.decryption((SrtCallerDecryptionRequest)((SrtCallerDecryptionRequest.Builder)SrtCallerDecryptionRequest.builder().applyMutation(decryption)).build());
        }

        public Builder minimumLatency(Integer var1);

        public Builder srtListenerAddress(String var1);

        public Builder srtListenerPort(String var1);

        public Builder streamId(String var1);
    }
}

