/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse;
import software.amazon.awssdk.services.medialive.model.MultiplexSummary;

public class ListMultiplexesIterable
implements SdkIterable<ListMultiplexesResponse> {
    private final MediaLiveClient client;
    private final ListMultiplexesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMultiplexesIterable(MediaLiveClient client, ListMultiplexesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMultiplexesResponseFetcher();
    }

    public Iterator<ListMultiplexesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MultiplexSummary> multiplexes() {
        Function<ListMultiplexesResponse, Iterator> getIterator = response -> {
            if (response != null && response.multiplexes() != null) {
                return response.multiplexes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMultiplexesResponseFetcher
    implements SyncPageFetcher<ListMultiplexesResponse> {
        private ListMultiplexesResponseFetcher() {
        }

        public boolean hasNextPage(ListMultiplexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMultiplexesResponse nextPage(ListMultiplexesResponse previousPage) {
            if (previousPage == null) {
                return ListMultiplexesIterable.this.client.listMultiplexes(ListMultiplexesIterable.this.firstRequest);
            }
            return ListMultiplexesIterable.this.client.listMultiplexes((ListMultiplexesRequest)((Object)ListMultiplexesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

