/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.M2tsSettings;
import software.amazon.awssdk.services.medialive.model.RawSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArchiveContainerSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArchiveContainerSettings> {
    private static final SdkField<M2tsSettings> M2_TS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("M2tsSettings").getter(ArchiveContainerSettings.getter(ArchiveContainerSettings::m2tsSettings)).setter(ArchiveContainerSettings.setter(Builder::m2tsSettings)).constructor(M2tsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2tsSettings").build()}).build();
    private static final SdkField<RawSettings> RAW_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RawSettings").getter(ArchiveContainerSettings.getter(ArchiveContainerSettings::rawSettings)).setter(ArchiveContainerSettings.setter(Builder::rawSettings)).constructor(RawSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(M2_TS_SETTINGS_FIELD, RAW_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ArchiveContainerSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final M2tsSettings m2tsSettings;
    private final RawSettings rawSettings;

    private ArchiveContainerSettings(BuilderImpl builder) {
        this.m2tsSettings = builder.m2tsSettings;
        this.rawSettings = builder.rawSettings;
    }

    public final M2tsSettings m2tsSettings() {
        return this.m2tsSettings;
    }

    public final RawSettings rawSettings() {
        return this.rawSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.m2tsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveContainerSettings)) {
            return false;
        }
        ArchiveContainerSettings other = (ArchiveContainerSettings)obj;
        return Objects.equals(this.m2tsSettings(), other.m2tsSettings()) && Objects.equals(this.rawSettings(), other.rawSettings());
    }

    public final String toString() {
        return ToString.builder((String)"ArchiveContainerSettings").add("M2tsSettings", (Object)this.m2tsSettings()).add("RawSettings", (Object)this.rawSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "M2tsSettings": {
                return Optional.ofNullable(clazz.cast(this.m2tsSettings()));
            }
            case "RawSettings": {
                return Optional.ofNullable(clazz.cast(this.rawSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("m2tsSettings", M2_TS_SETTINGS_FIELD);
        map.put("rawSettings", RAW_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArchiveContainerSettings, T> g) {
        return obj -> g.apply((ArchiveContainerSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private M2tsSettings m2tsSettings;
        private RawSettings rawSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveContainerSettings model) {
            this.m2tsSettings(model.m2tsSettings);
            this.rawSettings(model.rawSettings);
        }

        public final M2tsSettings.Builder getM2tsSettings() {
            return this.m2tsSettings != null ? this.m2tsSettings.toBuilder() : null;
        }

        public final void setM2tsSettings(M2tsSettings.BuilderImpl m2tsSettings) {
            this.m2tsSettings = m2tsSettings != null ? m2tsSettings.build() : null;
        }

        @Override
        public final Builder m2tsSettings(M2tsSettings m2tsSettings) {
            this.m2tsSettings = m2tsSettings;
            return this;
        }

        public final RawSettings.Builder getRawSettings() {
            return this.rawSettings != null ? this.rawSettings.toBuilder() : null;
        }

        public final void setRawSettings(RawSettings.BuilderImpl rawSettings) {
            this.rawSettings = rawSettings != null ? rawSettings.build() : null;
        }

        @Override
        public final Builder rawSettings(RawSettings rawSettings) {
            this.rawSettings = rawSettings;
            return this;
        }

        public ArchiveContainerSettings build() {
            return new ArchiveContainerSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArchiveContainerSettings> {
        public Builder m2tsSettings(M2tsSettings var1);

        default public Builder m2tsSettings(Consumer<M2tsSettings.Builder> m2tsSettings) {
            return this.m2tsSettings((M2tsSettings)((M2tsSettings.Builder)M2tsSettings.builder().applyMutation(m2tsSettings)).build());
        }

        public Builder rawSettings(RawSettings var1);

        default public Builder rawSettings(Consumer<RawSettings.Builder> rawSettings) {
            return this.rawSettings((RawSettings)((RawSettings.Builder)RawSettings.builder().applyMutation(rawSettings)).build());
        }
    }
}

