/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateEventType;
import software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateTarget;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.___listOfEventBridgeRuleTemplateTargetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventBridgeRuleTemplateRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateEventBridgeRuleTemplateRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateEventBridgeRuleTemplateRequest.getter(UpdateEventBridgeRuleTemplateRequest::description)).setter(UpdateEventBridgeRuleTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<EventBridgeRuleTemplateTarget>> EVENT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventTargets").getter(UpdateEventBridgeRuleTemplateRequest.getter(UpdateEventBridgeRuleTemplateRequest::eventTargets)).setter(UpdateEventBridgeRuleTemplateRequest.setter(Builder::eventTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventBridgeRuleTemplateTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(UpdateEventBridgeRuleTemplateRequest.getter(UpdateEventBridgeRuleTemplateRequest::eventTypeAsString)).setter(UpdateEventBridgeRuleTemplateRequest.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupIdentifier").getter(UpdateEventBridgeRuleTemplateRequest.getter(UpdateEventBridgeRuleTemplateRequest::groupIdentifier)).setter(UpdateEventBridgeRuleTemplateRequest.setter(Builder::groupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateEventBridgeRuleTemplateRequest.getter(UpdateEventBridgeRuleTemplateRequest::identifier)).setter(UpdateEventBridgeRuleTemplateRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateEventBridgeRuleTemplateRequest.getter(UpdateEventBridgeRuleTemplateRequest::name)).setter(UpdateEventBridgeRuleTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, EVENT_TARGETS_FIELD, EVENT_TYPE_FIELD, GROUP_IDENTIFIER_FIELD, IDENTIFIER_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEventBridgeRuleTemplateRequest.memberNameToFieldInitializer();
    private final String description;
    private final List<EventBridgeRuleTemplateTarget> eventTargets;
    private final String eventType;
    private final String groupIdentifier;
    private final String identifier;
    private final String name;

    private UpdateEventBridgeRuleTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.eventTargets = builder.eventTargets;
        this.eventType = builder.eventType;
        this.groupIdentifier = builder.groupIdentifier;
        this.identifier = builder.identifier;
        this.name = builder.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEventTargets() {
        return this.eventTargets != null && !(this.eventTargets instanceof SdkAutoConstructList);
    }

    public final List<EventBridgeRuleTemplateTarget> eventTargets() {
        return this.eventTargets;
    }

    public final EventBridgeRuleTemplateEventType eventType() {
        return EventBridgeRuleTemplateEventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final String groupIdentifier() {
        return this.groupIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTargets() ? this.eventTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventBridgeRuleTemplateRequest)) {
            return false;
        }
        UpdateEventBridgeRuleTemplateRequest other = (UpdateEventBridgeRuleTemplateRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasEventTargets() == other.hasEventTargets() && Objects.equals(this.eventTargets(), other.eventTargets()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.groupIdentifier(), other.groupIdentifier()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEventBridgeRuleTemplateRequest").add("Description", (Object)this.description()).add("EventTargets", this.hasEventTargets() ? this.eventTargets() : null).add("EventType", (Object)this.eventTypeAsString()).add("GroupIdentifier", (Object)this.groupIdentifier()).add("Identifier", (Object)this.identifier()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EventTargets": {
                return Optional.ofNullable(clazz.cast(this.eventTargets()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "GroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.groupIdentifier()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("eventTargets", EVENT_TARGETS_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("groupIdentifier", GROUP_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventBridgeRuleTemplateRequest, T> g) {
        return obj -> g.apply((UpdateEventBridgeRuleTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String description;
        private List<EventBridgeRuleTemplateTarget> eventTargets = DefaultSdkAutoConstructList.getInstance();
        private String eventType;
        private String groupIdentifier;
        private String identifier;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventBridgeRuleTemplateRequest model) {
            super(model);
            this.description(model.description);
            this.eventTargets(model.eventTargets);
            this.eventType(model.eventType);
            this.groupIdentifier(model.groupIdentifier);
            this.identifier(model.identifier);
            this.name(model.name);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EventBridgeRuleTemplateTarget.Builder> getEventTargets() {
            List<EventBridgeRuleTemplateTarget.Builder> result = ___listOfEventBridgeRuleTemplateTargetCopier.copyToBuilder(this.eventTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTargets(Collection<EventBridgeRuleTemplateTarget.BuilderImpl> eventTargets) {
            this.eventTargets = ___listOfEventBridgeRuleTemplateTargetCopier.copyFromBuilder(eventTargets);
        }

        @Override
        public final Builder eventTargets(Collection<EventBridgeRuleTemplateTarget> eventTargets) {
            this.eventTargets = ___listOfEventBridgeRuleTemplateTargetCopier.copy(eventTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTargets(EventBridgeRuleTemplateTarget ... eventTargets) {
            this.eventTargets(Arrays.asList(eventTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTargets(Consumer<EventBridgeRuleTemplateTarget.Builder> ... eventTargets) {
            this.eventTargets(Stream.of(eventTargets).map(c -> (EventBridgeRuleTemplateTarget)((EventBridgeRuleTemplateTarget.Builder)EventBridgeRuleTemplateTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventBridgeRuleTemplateEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getGroupIdentifier() {
            return this.groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventBridgeRuleTemplateRequest build() {
            return new UpdateEventBridgeRuleTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventBridgeRuleTemplateRequest> {
        public Builder description(String var1);

        public Builder eventTargets(Collection<EventBridgeRuleTemplateTarget> var1);

        public Builder eventTargets(EventBridgeRuleTemplateTarget ... var1);

        public Builder eventTargets(Consumer<EventBridgeRuleTemplateTarget.Builder> ... var1);

        public Builder eventType(String var1);

        public Builder eventType(EventBridgeRuleTemplateEventType var1);

        public Builder groupIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

