/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SdiSourceMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SdiSourceMapping> {
    private static final SdkField<Integer> CARD_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CardNumber").getter(SdiSourceMapping.getter(SdiSourceMapping::cardNumber)).setter(SdiSourceMapping.setter(Builder::cardNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardNumber").build()}).build();
    private static final SdkField<Integer> CHANNEL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChannelNumber").getter(SdiSourceMapping.getter(SdiSourceMapping::channelNumber)).setter(SdiSourceMapping.setter(Builder::channelNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelNumber").build()}).build();
    private static final SdkField<String> SDI_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SdiSource").getter(SdiSourceMapping.getter(SdiSourceMapping::sdiSource)).setter(SdiSourceMapping.setter(Builder::sdiSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdiSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARD_NUMBER_FIELD, CHANNEL_NUMBER_FIELD, SDI_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SdiSourceMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer cardNumber;
    private final Integer channelNumber;
    private final String sdiSource;

    private SdiSourceMapping(BuilderImpl builder) {
        this.cardNumber = builder.cardNumber;
        this.channelNumber = builder.channelNumber;
        this.sdiSource = builder.sdiSource;
    }

    public final Integer cardNumber() {
        return this.cardNumber;
    }

    public final Integer channelNumber() {
        return this.channelNumber;
    }

    public final String sdiSource() {
        return this.sdiSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cardNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.sdiSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SdiSourceMapping)) {
            return false;
        }
        SdiSourceMapping other = (SdiSourceMapping)obj;
        return Objects.equals(this.cardNumber(), other.cardNumber()) && Objects.equals(this.channelNumber(), other.channelNumber()) && Objects.equals(this.sdiSource(), other.sdiSource());
    }

    public final String toString() {
        return ToString.builder((String)"SdiSourceMapping").add("CardNumber", (Object)this.cardNumber()).add("ChannelNumber", (Object)this.channelNumber()).add("SdiSource", (Object)this.sdiSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CardNumber": {
                return Optional.ofNullable(clazz.cast(this.cardNumber()));
            }
            case "ChannelNumber": {
                return Optional.ofNullable(clazz.cast(this.channelNumber()));
            }
            case "SdiSource": {
                return Optional.ofNullable(clazz.cast(this.sdiSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardNumber", CARD_NUMBER_FIELD);
        map.put("channelNumber", CHANNEL_NUMBER_FIELD);
        map.put("sdiSource", SDI_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SdiSourceMapping, T> g) {
        return obj -> g.apply((SdiSourceMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer cardNumber;
        private Integer channelNumber;
        private String sdiSource;

        private BuilderImpl() {
        }

        private BuilderImpl(SdiSourceMapping model) {
            this.cardNumber(model.cardNumber);
            this.channelNumber(model.channelNumber);
            this.sdiSource(model.sdiSource);
        }

        public final Integer getCardNumber() {
            return this.cardNumber;
        }

        public final void setCardNumber(Integer cardNumber) {
            this.cardNumber = cardNumber;
        }

        @Override
        public final Builder cardNumber(Integer cardNumber) {
            this.cardNumber = cardNumber;
            return this;
        }

        public final Integer getChannelNumber() {
            return this.channelNumber;
        }

        public final void setChannelNumber(Integer channelNumber) {
            this.channelNumber = channelNumber;
        }

        @Override
        public final Builder channelNumber(Integer channelNumber) {
            this.channelNumber = channelNumber;
            return this;
        }

        public final String getSdiSource() {
            return this.sdiSource;
        }

        public final void setSdiSource(String sdiSource) {
            this.sdiSource = sdiSource;
        }

        @Override
        public final Builder sdiSource(String sdiSource) {
            this.sdiSource = sdiSource;
            return this;
        }

        public SdiSourceMapping build() {
            return new SdiSourceMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SdiSourceMapping> {
        public Builder cardNumber(Integer var1);

        public Builder channelNumber(Integer var1);

        public Builder sdiSource(String var1);
    }
}

