/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.InputDestinationRequest;
import software.amazon.awssdk.services.medialive.model.InputDeviceSettings;
import software.amazon.awssdk.services.medialive.model.InputNetworkLocation;
import software.amazon.awssdk.services.medialive.model.InputSdiSourcesCopier;
import software.amazon.awssdk.services.medialive.model.InputSourceRequest;
import software.amazon.awssdk.services.medialive.model.InputType;
import software.amazon.awssdk.services.medialive.model.InputVpcRequest;
import software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.MulticastSettingsCreateRequest;
import software.amazon.awssdk.services.medialive.model.Smpte2110ReceiverGroupSettings;
import software.amazon.awssdk.services.medialive.model.SrtSettingsRequest;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputDestinationRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputDeviceSettingsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputSourceRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfMediaConnectFlowRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInputRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, CreateInputRequest> {
    private static final SdkField<List<InputDestinationRequest>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(CreateInputRequest.getter(CreateInputRequest::destinations)).setter(CreateInputRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDestinationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputDeviceSettings>> INPUT_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDevices").getter(CreateInputRequest.getter(CreateInputRequest::inputDevices)).setter(CreateInputRequest.setter(Builder::inputDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDeviceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INPUT_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputSecurityGroups").getter(CreateInputRequest.getter(CreateInputRequest::inputSecurityGroups)).setter(CreateInputRequest.setter(Builder::inputSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MediaConnectFlowRequest>> MEDIA_CONNECT_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaConnectFlows").getter(CreateInputRequest.getter(CreateInputRequest::mediaConnectFlows)).setter(CreateInputRequest.setter(Builder::mediaConnectFlows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaConnectFlowRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateInputRequest.getter(CreateInputRequest::name)).setter(CreateInputRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateInputRequest.getter(CreateInputRequest::requestId)).setter(CreateInputRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateInputRequest.getter(CreateInputRequest::roleArn)).setter(CreateInputRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<InputSourceRequest>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(CreateInputRequest.getter(CreateInputRequest::sources)).setter(CreateInputRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateInputRequest.getter(CreateInputRequest::tags)).setter(CreateInputRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateInputRequest.getter(CreateInputRequest::typeAsString)).setter(CreateInputRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<InputVpcRequest> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(CreateInputRequest.getter(CreateInputRequest::vpc)).setter(CreateInputRequest.setter(Builder::vpc)).constructor(InputVpcRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()}).build();
    private static final SdkField<SrtSettingsRequest> SRT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SrtSettings").getter(CreateInputRequest.getter(CreateInputRequest::srtSettings)).setter(CreateInputRequest.setter(Builder::srtSettings)).constructor(SrtSettingsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtSettings").build()}).build();
    private static final SdkField<String> INPUT_NETWORK_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputNetworkLocation").getter(CreateInputRequest.getter(CreateInputRequest::inputNetworkLocationAsString)).setter(CreateInputRequest.setter(Builder::inputNetworkLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputNetworkLocation").build()}).build();
    private static final SdkField<MulticastSettingsCreateRequest> MULTICAST_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MulticastSettings").getter(CreateInputRequest.getter(CreateInputRequest::multicastSettings)).setter(CreateInputRequest.setter(Builder::multicastSettings)).constructor(MulticastSettingsCreateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multicastSettings").build()}).build();
    private static final SdkField<Smpte2110ReceiverGroupSettings> SMPTE2110_RECEIVER_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Smpte2110ReceiverGroupSettings").getter(CreateInputRequest.getter(CreateInputRequest::smpte2110ReceiverGroupSettings)).setter(CreateInputRequest.setter(Builder::smpte2110ReceiverGroupSettings)).constructor(Smpte2110ReceiverGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smpte2110ReceiverGroupSettings").build()}).build();
    private static final SdkField<List<String>> SDI_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SdiSources").getter(CreateInputRequest.getter(CreateInputRequest::sdiSources)).setter(CreateInputRequest.setter(Builder::sdiSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdiSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD, INPUT_DEVICES_FIELD, INPUT_SECURITY_GROUPS_FIELD, MEDIA_CONNECT_FLOWS_FIELD, NAME_FIELD, REQUEST_ID_FIELD, ROLE_ARN_FIELD, SOURCES_FIELD, TAGS_FIELD, TYPE_FIELD, VPC_FIELD, SRT_SETTINGS_FIELD, INPUT_NETWORK_LOCATION_FIELD, MULTICAST_SETTINGS_FIELD, SMPTE2110_RECEIVER_GROUP_SETTINGS_FIELD, SDI_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInputRequest.memberNameToFieldInitializer();
    private final List<InputDestinationRequest> destinations;
    private final List<InputDeviceSettings> inputDevices;
    private final List<String> inputSecurityGroups;
    private final List<MediaConnectFlowRequest> mediaConnectFlows;
    private final String name;
    private final String requestId;
    private final String roleArn;
    private final List<InputSourceRequest> sources;
    private final Map<String, String> tags;
    private final String type;
    private final InputVpcRequest vpc;
    private final SrtSettingsRequest srtSettings;
    private final String inputNetworkLocation;
    private final MulticastSettingsCreateRequest multicastSettings;
    private final Smpte2110ReceiverGroupSettings smpte2110ReceiverGroupSettings;
    private final List<String> sdiSources;

    private CreateInputRequest(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.inputDevices = builder.inputDevices;
        this.inputSecurityGroups = builder.inputSecurityGroups;
        this.mediaConnectFlows = builder.mediaConnectFlows;
        this.name = builder.name;
        this.requestId = builder.requestId;
        this.roleArn = builder.roleArn;
        this.sources = builder.sources;
        this.tags = builder.tags;
        this.type = builder.type;
        this.vpc = builder.vpc;
        this.srtSettings = builder.srtSettings;
        this.inputNetworkLocation = builder.inputNetworkLocation;
        this.multicastSettings = builder.multicastSettings;
        this.smpte2110ReceiverGroupSettings = builder.smpte2110ReceiverGroupSettings;
        this.sdiSources = builder.sdiSources;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<InputDestinationRequest> destinations() {
        return this.destinations;
    }

    public final boolean hasInputDevices() {
        return this.inputDevices != null && !(this.inputDevices instanceof SdkAutoConstructList);
    }

    public final List<InputDeviceSettings> inputDevices() {
        return this.inputDevices;
    }

    public final boolean hasInputSecurityGroups() {
        return this.inputSecurityGroups != null && !(this.inputSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> inputSecurityGroups() {
        return this.inputSecurityGroups;
    }

    public final boolean hasMediaConnectFlows() {
        return this.mediaConnectFlows != null && !(this.mediaConnectFlows instanceof SdkAutoConstructList);
    }

    public final List<MediaConnectFlowRequest> mediaConnectFlows() {
        return this.mediaConnectFlows;
    }

    public final String name() {
        return this.name;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<InputSourceRequest> sources() {
        return this.sources;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final InputType type() {
        return InputType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final InputVpcRequest vpc() {
        return this.vpc;
    }

    public final SrtSettingsRequest srtSettings() {
        return this.srtSettings;
    }

    public final InputNetworkLocation inputNetworkLocation() {
        return InputNetworkLocation.fromValue(this.inputNetworkLocation);
    }

    public final String inputNetworkLocationAsString() {
        return this.inputNetworkLocation;
    }

    public final MulticastSettingsCreateRequest multicastSettings() {
        return this.multicastSettings;
    }

    public final Smpte2110ReceiverGroupSettings smpte2110ReceiverGroupSettings() {
        return this.smpte2110ReceiverGroupSettings;
    }

    public final boolean hasSdiSources() {
        return this.sdiSources != null && !(this.sdiSources instanceof SdkAutoConstructList);
    }

    public final List<String> sdiSources() {
        return this.sdiSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDevices() ? this.inputDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputSecurityGroups() ? this.inputSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaConnectFlows() ? this.mediaConnectFlows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.srtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputNetworkLocationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.smpte2110ReceiverGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSdiSources() ? this.sdiSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInputRequest)) {
            return false;
        }
        CreateInputRequest other = (CreateInputRequest)((Object)obj);
        return this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && this.hasInputDevices() == other.hasInputDevices() && Objects.equals(this.inputDevices(), other.inputDevices()) && this.hasInputSecurityGroups() == other.hasInputSecurityGroups() && Objects.equals(this.inputSecurityGroups(), other.inputSecurityGroups()) && this.hasMediaConnectFlows() == other.hasMediaConnectFlows() && Objects.equals(this.mediaConnectFlows(), other.mediaConnectFlows()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.srtSettings(), other.srtSettings()) && Objects.equals(this.inputNetworkLocationAsString(), other.inputNetworkLocationAsString()) && Objects.equals(this.multicastSettings(), other.multicastSettings()) && Objects.equals(this.smpte2110ReceiverGroupSettings(), other.smpte2110ReceiverGroupSettings()) && this.hasSdiSources() == other.hasSdiSources() && Objects.equals(this.sdiSources(), other.sdiSources());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInputRequest").add("Destinations", this.hasDestinations() ? this.destinations() : null).add("InputDevices", this.hasInputDevices() ? this.inputDevices() : null).add("InputSecurityGroups", this.hasInputSecurityGroups() ? this.inputSecurityGroups() : null).add("MediaConnectFlows", this.hasMediaConnectFlows() ? this.mediaConnectFlows() : null).add("Name", (Object)this.name()).add("RequestId", (Object)this.requestId()).add("RoleArn", (Object)this.roleArn()).add("Sources", this.hasSources() ? this.sources() : null).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).add("Vpc", (Object)this.vpc()).add("SrtSettings", (Object)this.srtSettings()).add("InputNetworkLocation", (Object)this.inputNetworkLocationAsString()).add("MulticastSettings", (Object)this.multicastSettings()).add("Smpte2110ReceiverGroupSettings", (Object)this.smpte2110ReceiverGroupSettings()).add("SdiSources", this.hasSdiSources() ? this.sdiSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "InputDevices": {
                return Optional.ofNullable(clazz.cast(this.inputDevices()));
            }
            case "InputSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.inputSecurityGroups()));
            }
            case "MediaConnectFlows": {
                return Optional.ofNullable(clazz.cast(this.mediaConnectFlows()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "SrtSettings": {
                return Optional.ofNullable(clazz.cast(this.srtSettings()));
            }
            case "InputNetworkLocation": {
                return Optional.ofNullable(clazz.cast(this.inputNetworkLocationAsString()));
            }
            case "MulticastSettings": {
                return Optional.ofNullable(clazz.cast(this.multicastSettings()));
            }
            case "Smpte2110ReceiverGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.smpte2110ReceiverGroupSettings()));
            }
            case "SdiSources": {
                return Optional.ofNullable(clazz.cast(this.sdiSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("inputDevices", INPUT_DEVICES_FIELD);
        map.put("inputSecurityGroups", INPUT_SECURITY_GROUPS_FIELD);
        map.put("mediaConnectFlows", MEDIA_CONNECT_FLOWS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("vpc", VPC_FIELD);
        map.put("srtSettings", SRT_SETTINGS_FIELD);
        map.put("inputNetworkLocation", INPUT_NETWORK_LOCATION_FIELD);
        map.put("multicastSettings", MULTICAST_SETTINGS_FIELD);
        map.put("smpte2110ReceiverGroupSettings", SMPTE2110_RECEIVER_GROUP_SETTINGS_FIELD);
        map.put("sdiSources", SDI_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInputRequest, T> g) {
        return obj -> g.apply((CreateInputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<InputDestinationRequest> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<InputDeviceSettings> inputDevices = DefaultSdkAutoConstructList.getInstance();
        private List<String> inputSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<MediaConnectFlowRequest> mediaConnectFlows = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String requestId;
        private String roleArn;
        private List<InputSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;
        private InputVpcRequest vpc;
        private SrtSettingsRequest srtSettings;
        private String inputNetworkLocation;
        private MulticastSettingsCreateRequest multicastSettings;
        private Smpte2110ReceiverGroupSettings smpte2110ReceiverGroupSettings;
        private List<String> sdiSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInputRequest model) {
            super(model);
            this.destinations(model.destinations);
            this.inputDevices(model.inputDevices);
            this.inputSecurityGroups(model.inputSecurityGroups);
            this.mediaConnectFlows(model.mediaConnectFlows);
            this.name(model.name);
            this.requestId(model.requestId);
            this.roleArn(model.roleArn);
            this.sources(model.sources);
            this.tags(model.tags);
            this.type(model.type);
            this.vpc(model.vpc);
            this.srtSettings(model.srtSettings);
            this.inputNetworkLocation(model.inputNetworkLocation);
            this.multicastSettings(model.multicastSettings);
            this.smpte2110ReceiverGroupSettings(model.smpte2110ReceiverGroupSettings);
            this.sdiSources(model.sdiSources);
        }

        public final List<InputDestinationRequest.Builder> getDestinations() {
            List<InputDestinationRequest.Builder> result = ___listOfInputDestinationRequestCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<InputDestinationRequest.BuilderImpl> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<InputDestinationRequest> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestinationRequest ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestinationRequest.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (InputDestinationRequest)((InputDestinationRequest.Builder)InputDestinationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InputDeviceSettings.Builder> getInputDevices() {
            List<InputDeviceSettings.Builder> result = ___listOfInputDeviceSettingsCopier.copyToBuilder(this.inputDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDevices(Collection<InputDeviceSettings.BuilderImpl> inputDevices) {
            this.inputDevices = ___listOfInputDeviceSettingsCopier.copyFromBuilder(inputDevices);
        }

        @Override
        public final Builder inputDevices(Collection<InputDeviceSettings> inputDevices) {
            this.inputDevices = ___listOfInputDeviceSettingsCopier.copy(inputDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(InputDeviceSettings ... inputDevices) {
            this.inputDevices(Arrays.asList(inputDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(Consumer<InputDeviceSettings.Builder> ... inputDevices) {
            this.inputDevices(Stream.of(inputDevices).map(c -> (InputDeviceSettings)((InputDeviceSettings.Builder)InputDeviceSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getInputSecurityGroups() {
            if (this.inputSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputSecurityGroups;
        }

        public final void setInputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
        }

        @Override
        public final Builder inputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroups(String ... inputSecurityGroups) {
            this.inputSecurityGroups(Arrays.asList(inputSecurityGroups));
            return this;
        }

        public final List<MediaConnectFlowRequest.Builder> getMediaConnectFlows() {
            List<MediaConnectFlowRequest.Builder> result = ___listOfMediaConnectFlowRequestCopier.copyToBuilder(this.mediaConnectFlows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaConnectFlows(Collection<MediaConnectFlowRequest.BuilderImpl> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowRequestCopier.copyFromBuilder(mediaConnectFlows);
        }

        @Override
        public final Builder mediaConnectFlows(Collection<MediaConnectFlowRequest> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowRequestCopier.copy(mediaConnectFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(MediaConnectFlowRequest ... mediaConnectFlows) {
            this.mediaConnectFlows(Arrays.asList(mediaConnectFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(Consumer<MediaConnectFlowRequest.Builder> ... mediaConnectFlows) {
            this.mediaConnectFlows(Stream.of(mediaConnectFlows).map(c -> (MediaConnectFlowRequest)((MediaConnectFlowRequest.Builder)MediaConnectFlowRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<InputSourceRequest.Builder> getSources() {
            List<InputSourceRequest.Builder> result = ___listOfInputSourceRequestCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<InputSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<InputSourceRequest> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSourceRequest ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSourceRequest.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (InputSourceRequest)((InputSourceRequest.Builder)InputSourceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final InputVpcRequest.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(InputVpcRequest.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(InputVpcRequest vpc) {
            this.vpc = vpc;
            return this;
        }

        public final SrtSettingsRequest.Builder getSrtSettings() {
            return this.srtSettings != null ? this.srtSettings.toBuilder() : null;
        }

        public final void setSrtSettings(SrtSettingsRequest.BuilderImpl srtSettings) {
            this.srtSettings = srtSettings != null ? srtSettings.build() : null;
        }

        @Override
        public final Builder srtSettings(SrtSettingsRequest srtSettings) {
            this.srtSettings = srtSettings;
            return this;
        }

        public final String getInputNetworkLocation() {
            return this.inputNetworkLocation;
        }

        public final void setInputNetworkLocation(String inputNetworkLocation) {
            this.inputNetworkLocation = inputNetworkLocation;
        }

        @Override
        public final Builder inputNetworkLocation(String inputNetworkLocation) {
            this.inputNetworkLocation = inputNetworkLocation;
            return this;
        }

        @Override
        public final Builder inputNetworkLocation(InputNetworkLocation inputNetworkLocation) {
            this.inputNetworkLocation(inputNetworkLocation == null ? null : inputNetworkLocation.toString());
            return this;
        }

        public final MulticastSettingsCreateRequest.Builder getMulticastSettings() {
            return this.multicastSettings != null ? this.multicastSettings.toBuilder() : null;
        }

        public final void setMulticastSettings(MulticastSettingsCreateRequest.BuilderImpl multicastSettings) {
            this.multicastSettings = multicastSettings != null ? multicastSettings.build() : null;
        }

        @Override
        public final Builder multicastSettings(MulticastSettingsCreateRequest multicastSettings) {
            this.multicastSettings = multicastSettings;
            return this;
        }

        public final Smpte2110ReceiverGroupSettings.Builder getSmpte2110ReceiverGroupSettings() {
            return this.smpte2110ReceiverGroupSettings != null ? this.smpte2110ReceiverGroupSettings.toBuilder() : null;
        }

        public final void setSmpte2110ReceiverGroupSettings(Smpte2110ReceiverGroupSettings.BuilderImpl smpte2110ReceiverGroupSettings) {
            this.smpte2110ReceiverGroupSettings = smpte2110ReceiverGroupSettings != null ? smpte2110ReceiverGroupSettings.build() : null;
        }

        @Override
        public final Builder smpte2110ReceiverGroupSettings(Smpte2110ReceiverGroupSettings smpte2110ReceiverGroupSettings) {
            this.smpte2110ReceiverGroupSettings = smpte2110ReceiverGroupSettings;
            return this;
        }

        public final Collection<String> getSdiSources() {
            if (this.sdiSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sdiSources;
        }

        public final void setSdiSources(Collection<String> sdiSources) {
            this.sdiSources = InputSdiSourcesCopier.copy(sdiSources);
        }

        @Override
        public final Builder sdiSources(Collection<String> sdiSources) {
            this.sdiSources = InputSdiSourcesCopier.copy(sdiSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sdiSources(String ... sdiSources) {
            this.sdiSources(Arrays.asList(sdiSources));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInputRequest build() {
            return new CreateInputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInputRequest> {
        public Builder destinations(Collection<InputDestinationRequest> var1);

        public Builder destinations(InputDestinationRequest ... var1);

        public Builder destinations(Consumer<InputDestinationRequest.Builder> ... var1);

        public Builder inputDevices(Collection<InputDeviceSettings> var1);

        public Builder inputDevices(InputDeviceSettings ... var1);

        public Builder inputDevices(Consumer<InputDeviceSettings.Builder> ... var1);

        public Builder inputSecurityGroups(Collection<String> var1);

        public Builder inputSecurityGroups(String ... var1);

        public Builder mediaConnectFlows(Collection<MediaConnectFlowRequest> var1);

        public Builder mediaConnectFlows(MediaConnectFlowRequest ... var1);

        public Builder mediaConnectFlows(Consumer<MediaConnectFlowRequest.Builder> ... var1);

        public Builder name(String var1);

        public Builder requestId(String var1);

        public Builder roleArn(String var1);

        public Builder sources(Collection<InputSourceRequest> var1);

        public Builder sources(InputSourceRequest ... var1);

        public Builder sources(Consumer<InputSourceRequest.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(InputType var1);

        public Builder vpc(InputVpcRequest var1);

        default public Builder vpc(Consumer<InputVpcRequest.Builder> vpc) {
            return this.vpc((InputVpcRequest)((InputVpcRequest.Builder)InputVpcRequest.builder().applyMutation(vpc)).build());
        }

        public Builder srtSettings(SrtSettingsRequest var1);

        default public Builder srtSettings(Consumer<SrtSettingsRequest.Builder> srtSettings) {
            return this.srtSettings((SrtSettingsRequest)((SrtSettingsRequest.Builder)SrtSettingsRequest.builder().applyMutation(srtSettings)).build());
        }

        public Builder inputNetworkLocation(String var1);

        public Builder inputNetworkLocation(InputNetworkLocation var1);

        public Builder multicastSettings(MulticastSettingsCreateRequest var1);

        default public Builder multicastSettings(Consumer<MulticastSettingsCreateRequest.Builder> multicastSettings) {
            return this.multicastSettings((MulticastSettingsCreateRequest)((MulticastSettingsCreateRequest.Builder)MulticastSettingsCreateRequest.builder().applyMutation(multicastSettings)).build());
        }

        public Builder smpte2110ReceiverGroupSettings(Smpte2110ReceiverGroupSettings var1);

        default public Builder smpte2110ReceiverGroupSettings(Consumer<Smpte2110ReceiverGroupSettings.Builder> smpte2110ReceiverGroupSettings) {
            return this.smpte2110ReceiverGroupSettings((Smpte2110ReceiverGroupSettings)((Smpte2110ReceiverGroupSettings.Builder)Smpte2110ReceiverGroupSettings.builder().applyMutation(smpte2110ReceiverGroupSettings)).build());
        }

        public Builder sdiSources(Collection<String> var1);

        public Builder sdiSources(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

