/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.DvbSubOcrLanguage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DvbSubSourceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DvbSubSourceSettings> {
    private static final SdkField<String> OCR_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OcrLanguage").getter(DvbSubSourceSettings.getter(DvbSubSourceSettings::ocrLanguageAsString)).setter(DvbSubSourceSettings.setter(Builder::ocrLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocrLanguage").build()}).build();
    private static final SdkField<Integer> PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Pid").getter(DvbSubSourceSettings.getter(DvbSubSourceSettings::pid)).setter(DvbSubSourceSettings.setter(Builder::pid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pid").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OCR_LANGUAGE_FIELD, PID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DvbSubSourceSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ocrLanguage;
    private final Integer pid;

    private DvbSubSourceSettings(BuilderImpl builder) {
        this.ocrLanguage = builder.ocrLanguage;
        this.pid = builder.pid;
    }

    public final DvbSubOcrLanguage ocrLanguage() {
        return DvbSubOcrLanguage.fromValue(this.ocrLanguage);
    }

    public final String ocrLanguageAsString() {
        return this.ocrLanguage;
    }

    public final Integer pid() {
        return this.pid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ocrLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbSubSourceSettings)) {
            return false;
        }
        DvbSubSourceSettings other = (DvbSubSourceSettings)obj;
        return Objects.equals(this.ocrLanguageAsString(), other.ocrLanguageAsString()) && Objects.equals(this.pid(), other.pid());
    }

    public final String toString() {
        return ToString.builder((String)"DvbSubSourceSettings").add("OcrLanguage", (Object)this.ocrLanguageAsString()).add("Pid", (Object)this.pid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OcrLanguage": {
                return Optional.ofNullable(clazz.cast(this.ocrLanguageAsString()));
            }
            case "Pid": {
                return Optional.ofNullable(clazz.cast(this.pid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocrLanguage", OCR_LANGUAGE_FIELD);
        map.put("pid", PID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DvbSubSourceSettings, T> g) {
        return obj -> g.apply((DvbSubSourceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ocrLanguage;
        private Integer pid;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbSubSourceSettings model) {
            this.ocrLanguage(model.ocrLanguage);
            this.pid(model.pid);
        }

        public final String getOcrLanguage() {
            return this.ocrLanguage;
        }

        public final void setOcrLanguage(String ocrLanguage) {
            this.ocrLanguage = ocrLanguage;
        }

        @Override
        public final Builder ocrLanguage(String ocrLanguage) {
            this.ocrLanguage = ocrLanguage;
            return this;
        }

        @Override
        public final Builder ocrLanguage(DvbSubOcrLanguage ocrLanguage) {
            this.ocrLanguage(ocrLanguage == null ? null : ocrLanguage.toString());
            return this;
        }

        public final Integer getPid() {
            return this.pid;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public DvbSubSourceSettings build() {
            return new DvbSubSourceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DvbSubSourceSettings> {
        public Builder ocrLanguage(String var1);

        public Builder ocrLanguage(DvbSubOcrLanguage var1);

        public Builder pid(Integer var1);
    }
}

