/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.DescribeNetworkSummary;
import software.amazon.awssdk.services.medialive.model.ListNetworksRequest;
import software.amazon.awssdk.services.medialive.model.ListNetworksResponse;

public class ListNetworksIterable
implements SdkIterable<ListNetworksResponse> {
    private final MediaLiveClient client;
    private final ListNetworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNetworksIterable(MediaLiveClient client, ListNetworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNetworksResponseFetcher();
    }

    public Iterator<ListNetworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DescribeNetworkSummary> networks() {
        Function<ListNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.networks() != null) {
                return response.networks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNetworksResponseFetcher
    implements SyncPageFetcher<ListNetworksResponse> {
        private ListNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNetworksResponse nextPage(ListNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListNetworksIterable.this.client.listNetworks(ListNetworksIterable.this.firstRequest);
            }
            return ListNetworksIterable.this.client.listNetworks((ListNetworksRequest)((Object)ListNetworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

