/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace;
import software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpaceSettings;
import software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpaceUsage;
import software.amazon.awssdk.services.medialive.model.VideoSelectorSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoSelector> {
    private static final SdkField<String> COLOR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorSpace").getter(VideoSelector.getter(VideoSelector::colorSpaceAsString)).setter(VideoSelector.setter(Builder::colorSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpace").build()}).build();
    private static final SdkField<VideoSelectorColorSpaceSettings> COLOR_SPACE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorSpaceSettings").getter(VideoSelector.getter(VideoSelector::colorSpaceSettings)).setter(VideoSelector.setter(Builder::colorSpaceSettings)).constructor(VideoSelectorColorSpaceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceSettings").build()}).build();
    private static final SdkField<String> COLOR_SPACE_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorSpaceUsage").getter(VideoSelector.getter(VideoSelector::colorSpaceUsageAsString)).setter(VideoSelector.setter(Builder::colorSpaceUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceUsage").build()}).build();
    private static final SdkField<VideoSelectorSettings> SELECTOR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectorSettings").getter(VideoSelector.getter(VideoSelector::selectorSettings)).setter(VideoSelector.setter(Builder::selectorSettings)).constructor(VideoSelectorSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLOR_SPACE_FIELD, COLOR_SPACE_SETTINGS_FIELD, COLOR_SPACE_USAGE_FIELD, SELECTOR_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoSelector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String colorSpace;
    private final VideoSelectorColorSpaceSettings colorSpaceSettings;
    private final String colorSpaceUsage;
    private final VideoSelectorSettings selectorSettings;

    private VideoSelector(BuilderImpl builder) {
        this.colorSpace = builder.colorSpace;
        this.colorSpaceSettings = builder.colorSpaceSettings;
        this.colorSpaceUsage = builder.colorSpaceUsage;
        this.selectorSettings = builder.selectorSettings;
    }

    public final VideoSelectorColorSpace colorSpace() {
        return VideoSelectorColorSpace.fromValue(this.colorSpace);
    }

    public final String colorSpaceAsString() {
        return this.colorSpace;
    }

    public final VideoSelectorColorSpaceSettings colorSpaceSettings() {
        return this.colorSpaceSettings;
    }

    public final VideoSelectorColorSpaceUsage colorSpaceUsage() {
        return VideoSelectorColorSpaceUsage.fromValue(this.colorSpaceUsage);
    }

    public final String colorSpaceUsageAsString() {
        return this.colorSpaceUsage;
    }

    public final VideoSelectorSettings selectorSettings() {
        return this.selectorSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectorSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelector)) {
            return false;
        }
        VideoSelector other = (VideoSelector)obj;
        return Objects.equals(this.colorSpaceAsString(), other.colorSpaceAsString()) && Objects.equals(this.colorSpaceSettings(), other.colorSpaceSettings()) && Objects.equals(this.colorSpaceUsageAsString(), other.colorSpaceUsageAsString()) && Objects.equals(this.selectorSettings(), other.selectorSettings());
    }

    public final String toString() {
        return ToString.builder((String)"VideoSelector").add("ColorSpace", (Object)this.colorSpaceAsString()).add("ColorSpaceSettings", (Object)this.colorSpaceSettings()).add("ColorSpaceUsage", (Object)this.colorSpaceUsageAsString()).add("SelectorSettings", (Object)this.selectorSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColorSpace": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceAsString()));
            }
            case "ColorSpaceSettings": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceSettings()));
            }
            case "ColorSpaceUsage": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceUsageAsString()));
            }
            case "SelectorSettings": {
                return Optional.ofNullable(clazz.cast(this.selectorSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("colorSpace", COLOR_SPACE_FIELD);
        map.put("colorSpaceSettings", COLOR_SPACE_SETTINGS_FIELD);
        map.put("colorSpaceUsage", COLOR_SPACE_USAGE_FIELD);
        map.put("selectorSettings", SELECTOR_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoSelector, T> g) {
        return obj -> g.apply((VideoSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String colorSpace;
        private VideoSelectorColorSpaceSettings colorSpaceSettings;
        private String colorSpaceUsage;
        private VideoSelectorSettings selectorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelector model) {
            this.colorSpace(model.colorSpace);
            this.colorSpaceSettings(model.colorSpaceSettings);
            this.colorSpaceUsage(model.colorSpaceUsage);
            this.selectorSettings(model.selectorSettings);
        }

        public final String getColorSpace() {
            return this.colorSpace;
        }

        public final void setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
        }

        @Override
        public final Builder colorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        @Override
        public final Builder colorSpace(VideoSelectorColorSpace colorSpace) {
            this.colorSpace(colorSpace == null ? null : colorSpace.toString());
            return this;
        }

        public final VideoSelectorColorSpaceSettings.Builder getColorSpaceSettings() {
            return this.colorSpaceSettings != null ? this.colorSpaceSettings.toBuilder() : null;
        }

        public final void setColorSpaceSettings(VideoSelectorColorSpaceSettings.BuilderImpl colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings != null ? colorSpaceSettings.build() : null;
        }

        @Override
        public final Builder colorSpaceSettings(VideoSelectorColorSpaceSettings colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings;
            return this;
        }

        public final String getColorSpaceUsage() {
            return this.colorSpaceUsage;
        }

        public final void setColorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
        }

        @Override
        public final Builder colorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
            return this;
        }

        @Override
        public final Builder colorSpaceUsage(VideoSelectorColorSpaceUsage colorSpaceUsage) {
            this.colorSpaceUsage(colorSpaceUsage == null ? null : colorSpaceUsage.toString());
            return this;
        }

        public final VideoSelectorSettings.Builder getSelectorSettings() {
            return this.selectorSettings != null ? this.selectorSettings.toBuilder() : null;
        }

        public final void setSelectorSettings(VideoSelectorSettings.BuilderImpl selectorSettings) {
            this.selectorSettings = selectorSettings != null ? selectorSettings.build() : null;
        }

        @Override
        public final Builder selectorSettings(VideoSelectorSettings selectorSettings) {
            this.selectorSettings = selectorSettings;
            return this;
        }

        public VideoSelector build() {
            return new VideoSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoSelector> {
        public Builder colorSpace(String var1);

        public Builder colorSpace(VideoSelectorColorSpace var1);

        public Builder colorSpaceSettings(VideoSelectorColorSpaceSettings var1);

        default public Builder colorSpaceSettings(Consumer<VideoSelectorColorSpaceSettings.Builder> colorSpaceSettings) {
            return this.colorSpaceSettings((VideoSelectorColorSpaceSettings)((VideoSelectorColorSpaceSettings.Builder)VideoSelectorColorSpaceSettings.builder().applyMutation(colorSpaceSettings)).build());
        }

        public Builder colorSpaceUsage(String var1);

        public Builder colorSpaceUsage(VideoSelectorColorSpaceUsage var1);

        public Builder selectorSettings(VideoSelectorSettings var1);

        default public Builder selectorSettings(Consumer<VideoSelectorSettings.Builder> selectorSettings) {
            return this.selectorSettings((VideoSelectorSettings)((VideoSelectorSettings.Builder)VideoSelectorSettings.builder().applyMutation(selectorSettings)).build());
        }
    }
}

