/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.Eac3AttenuationControl;
import software.amazon.awssdk.services.medialive.model.Eac3BitstreamMode;
import software.amazon.awssdk.services.medialive.model.Eac3CodingMode;
import software.amazon.awssdk.services.medialive.model.Eac3DcFilter;
import software.amazon.awssdk.services.medialive.model.Eac3DrcLine;
import software.amazon.awssdk.services.medialive.model.Eac3DrcRf;
import software.amazon.awssdk.services.medialive.model.Eac3LfeControl;
import software.amazon.awssdk.services.medialive.model.Eac3LfeFilter;
import software.amazon.awssdk.services.medialive.model.Eac3MetadataControl;
import software.amazon.awssdk.services.medialive.model.Eac3PassthroughControl;
import software.amazon.awssdk.services.medialive.model.Eac3PhaseControl;
import software.amazon.awssdk.services.medialive.model.Eac3StereoDownmix;
import software.amazon.awssdk.services.medialive.model.Eac3SurroundExMode;
import software.amazon.awssdk.services.medialive.model.Eac3SurroundMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Eac3Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Eac3Settings> {
    private static final SdkField<String> ATTENUATION_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttenuationControl").getter(Eac3Settings.getter(Eac3Settings::attenuationControlAsString)).setter(Eac3Settings.setter(Builder::attenuationControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attenuationControl").build()}).build();
    private static final SdkField<Double> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Bitrate").getter(Eac3Settings.getter(Eac3Settings::bitrate)).setter(Eac3Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> BITSTREAM_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BitstreamMode").getter(Eac3Settings.getter(Eac3Settings::bitstreamModeAsString)).setter(Eac3Settings.setter(Builder::bitstreamMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitstreamMode").build()}).build();
    private static final SdkField<String> CODING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodingMode").getter(Eac3Settings.getter(Eac3Settings::codingModeAsString)).setter(Eac3Settings.setter(Builder::codingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()}).build();
    private static final SdkField<String> DC_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DcFilter").getter(Eac3Settings.getter(Eac3Settings::dcFilterAsString)).setter(Eac3Settings.setter(Builder::dcFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dcFilter").build()}).build();
    private static final SdkField<Integer> DIALNORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Dialnorm").getter(Eac3Settings.getter(Eac3Settings::dialnorm)).setter(Eac3Settings.setter(Builder::dialnorm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialnorm").build()}).build();
    private static final SdkField<String> DRC_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DrcLine").getter(Eac3Settings.getter(Eac3Settings::drcLineAsString)).setter(Eac3Settings.setter(Builder::drcLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("drcLine").build()}).build();
    private static final SdkField<String> DRC_RF_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DrcRf").getter(Eac3Settings.getter(Eac3Settings::drcRfAsString)).setter(Eac3Settings.setter(Builder::drcRf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("drcRf").build()}).build();
    private static final SdkField<String> LFE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LfeControl").getter(Eac3Settings.getter(Eac3Settings::lfeControlAsString)).setter(Eac3Settings.setter(Builder::lfeControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lfeControl").build()}).build();
    private static final SdkField<String> LFE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LfeFilter").getter(Eac3Settings.getter(Eac3Settings::lfeFilterAsString)).setter(Eac3Settings.setter(Builder::lfeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lfeFilter").build()}).build();
    private static final SdkField<Double> LO_RO_CENTER_MIX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LoRoCenterMixLevel").getter(Eac3Settings.getter(Eac3Settings::loRoCenterMixLevel)).setter(Eac3Settings.setter(Builder::loRoCenterMixLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loRoCenterMixLevel").build()}).build();
    private static final SdkField<Double> LO_RO_SURROUND_MIX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LoRoSurroundMixLevel").getter(Eac3Settings.getter(Eac3Settings::loRoSurroundMixLevel)).setter(Eac3Settings.setter(Builder::loRoSurroundMixLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loRoSurroundMixLevel").build()}).build();
    private static final SdkField<Double> LT_RT_CENTER_MIX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LtRtCenterMixLevel").getter(Eac3Settings.getter(Eac3Settings::ltRtCenterMixLevel)).setter(Eac3Settings.setter(Builder::ltRtCenterMixLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ltRtCenterMixLevel").build()}).build();
    private static final SdkField<Double> LT_RT_SURROUND_MIX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LtRtSurroundMixLevel").getter(Eac3Settings.getter(Eac3Settings::ltRtSurroundMixLevel)).setter(Eac3Settings.setter(Builder::ltRtSurroundMixLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ltRtSurroundMixLevel").build()}).build();
    private static final SdkField<String> METADATA_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataControl").getter(Eac3Settings.getter(Eac3Settings::metadataControlAsString)).setter(Eac3Settings.setter(Builder::metadataControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataControl").build()}).build();
    private static final SdkField<String> PASSTHROUGH_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PassthroughControl").getter(Eac3Settings.getter(Eac3Settings::passthroughControlAsString)).setter(Eac3Settings.setter(Builder::passthroughControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passthroughControl").build()}).build();
    private static final SdkField<String> PHASE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhaseControl").getter(Eac3Settings.getter(Eac3Settings::phaseControlAsString)).setter(Eac3Settings.setter(Builder::phaseControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phaseControl").build()}).build();
    private static final SdkField<String> STEREO_DOWNMIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StereoDownmix").getter(Eac3Settings.getter(Eac3Settings::stereoDownmixAsString)).setter(Eac3Settings.setter(Builder::stereoDownmix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stereoDownmix").build()}).build();
    private static final SdkField<String> SURROUND_EX_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SurroundExMode").getter(Eac3Settings.getter(Eac3Settings::surroundExModeAsString)).setter(Eac3Settings.setter(Builder::surroundExMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("surroundExMode").build()}).build();
    private static final SdkField<String> SURROUND_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SurroundMode").getter(Eac3Settings.getter(Eac3Settings::surroundModeAsString)).setter(Eac3Settings.setter(Builder::surroundMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("surroundMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTENUATION_CONTROL_FIELD, BITRATE_FIELD, BITSTREAM_MODE_FIELD, CODING_MODE_FIELD, DC_FILTER_FIELD, DIALNORM_FIELD, DRC_LINE_FIELD, DRC_RF_FIELD, LFE_CONTROL_FIELD, LFE_FILTER_FIELD, LO_RO_CENTER_MIX_LEVEL_FIELD, LO_RO_SURROUND_MIX_LEVEL_FIELD, LT_RT_CENTER_MIX_LEVEL_FIELD, LT_RT_SURROUND_MIX_LEVEL_FIELD, METADATA_CONTROL_FIELD, PASSTHROUGH_CONTROL_FIELD, PHASE_CONTROL_FIELD, STEREO_DOWNMIX_FIELD, SURROUND_EX_MODE_FIELD, SURROUND_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("attenuationControl", ATTENUATION_CONTROL_FIELD);
            this.put("bitrate", BITRATE_FIELD);
            this.put("bitstreamMode", BITSTREAM_MODE_FIELD);
            this.put("codingMode", CODING_MODE_FIELD);
            this.put("dcFilter", DC_FILTER_FIELD);
            this.put("dialnorm", DIALNORM_FIELD);
            this.put("drcLine", DRC_LINE_FIELD);
            this.put("drcRf", DRC_RF_FIELD);
            this.put("lfeControl", LFE_CONTROL_FIELD);
            this.put("lfeFilter", LFE_FILTER_FIELD);
            this.put("loRoCenterMixLevel", LO_RO_CENTER_MIX_LEVEL_FIELD);
            this.put("loRoSurroundMixLevel", LO_RO_SURROUND_MIX_LEVEL_FIELD);
            this.put("ltRtCenterMixLevel", LT_RT_CENTER_MIX_LEVEL_FIELD);
            this.put("ltRtSurroundMixLevel", LT_RT_SURROUND_MIX_LEVEL_FIELD);
            this.put("metadataControl", METADATA_CONTROL_FIELD);
            this.put("passthroughControl", PASSTHROUGH_CONTROL_FIELD);
            this.put("phaseControl", PHASE_CONTROL_FIELD);
            this.put("stereoDownmix", STEREO_DOWNMIX_FIELD);
            this.put("surroundExMode", SURROUND_EX_MODE_FIELD);
            this.put("surroundMode", SURROUND_MODE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String attenuationControl;
    private final Double bitrate;
    private final String bitstreamMode;
    private final String codingMode;
    private final String dcFilter;
    private final Integer dialnorm;
    private final String drcLine;
    private final String drcRf;
    private final String lfeControl;
    private final String lfeFilter;
    private final Double loRoCenterMixLevel;
    private final Double loRoSurroundMixLevel;
    private final Double ltRtCenterMixLevel;
    private final Double ltRtSurroundMixLevel;
    private final String metadataControl;
    private final String passthroughControl;
    private final String phaseControl;
    private final String stereoDownmix;
    private final String surroundExMode;
    private final String surroundMode;

    private Eac3Settings(BuilderImpl builder) {
        this.attenuationControl = builder.attenuationControl;
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dcFilter = builder.dcFilter;
        this.dialnorm = builder.dialnorm;
        this.drcLine = builder.drcLine;
        this.drcRf = builder.drcRf;
        this.lfeControl = builder.lfeControl;
        this.lfeFilter = builder.lfeFilter;
        this.loRoCenterMixLevel = builder.loRoCenterMixLevel;
        this.loRoSurroundMixLevel = builder.loRoSurroundMixLevel;
        this.ltRtCenterMixLevel = builder.ltRtCenterMixLevel;
        this.ltRtSurroundMixLevel = builder.ltRtSurroundMixLevel;
        this.metadataControl = builder.metadataControl;
        this.passthroughControl = builder.passthroughControl;
        this.phaseControl = builder.phaseControl;
        this.stereoDownmix = builder.stereoDownmix;
        this.surroundExMode = builder.surroundExMode;
        this.surroundMode = builder.surroundMode;
    }

    public final Eac3AttenuationControl attenuationControl() {
        return Eac3AttenuationControl.fromValue(this.attenuationControl);
    }

    public final String attenuationControlAsString() {
        return this.attenuationControl;
    }

    public final Double bitrate() {
        return this.bitrate;
    }

    public final Eac3BitstreamMode bitstreamMode() {
        return Eac3BitstreamMode.fromValue(this.bitstreamMode);
    }

    public final String bitstreamModeAsString() {
        return this.bitstreamMode;
    }

    public final Eac3CodingMode codingMode() {
        return Eac3CodingMode.fromValue(this.codingMode);
    }

    public final String codingModeAsString() {
        return this.codingMode;
    }

    public final Eac3DcFilter dcFilter() {
        return Eac3DcFilter.fromValue(this.dcFilter);
    }

    public final String dcFilterAsString() {
        return this.dcFilter;
    }

    public final Integer dialnorm() {
        return this.dialnorm;
    }

    public final Eac3DrcLine drcLine() {
        return Eac3DrcLine.fromValue(this.drcLine);
    }

    public final String drcLineAsString() {
        return this.drcLine;
    }

    public final Eac3DrcRf drcRf() {
        return Eac3DrcRf.fromValue(this.drcRf);
    }

    public final String drcRfAsString() {
        return this.drcRf;
    }

    public final Eac3LfeControl lfeControl() {
        return Eac3LfeControl.fromValue(this.lfeControl);
    }

    public final String lfeControlAsString() {
        return this.lfeControl;
    }

    public final Eac3LfeFilter lfeFilter() {
        return Eac3LfeFilter.fromValue(this.lfeFilter);
    }

    public final String lfeFilterAsString() {
        return this.lfeFilter;
    }

    public final Double loRoCenterMixLevel() {
        return this.loRoCenterMixLevel;
    }

    public final Double loRoSurroundMixLevel() {
        return this.loRoSurroundMixLevel;
    }

    public final Double ltRtCenterMixLevel() {
        return this.ltRtCenterMixLevel;
    }

    public final Double ltRtSurroundMixLevel() {
        return this.ltRtSurroundMixLevel;
    }

    public final Eac3MetadataControl metadataControl() {
        return Eac3MetadataControl.fromValue(this.metadataControl);
    }

    public final String metadataControlAsString() {
        return this.metadataControl;
    }

    public final Eac3PassthroughControl passthroughControl() {
        return Eac3PassthroughControl.fromValue(this.passthroughControl);
    }

    public final String passthroughControlAsString() {
        return this.passthroughControl;
    }

    public final Eac3PhaseControl phaseControl() {
        return Eac3PhaseControl.fromValue(this.phaseControl);
    }

    public final String phaseControlAsString() {
        return this.phaseControl;
    }

    public final Eac3StereoDownmix stereoDownmix() {
        return Eac3StereoDownmix.fromValue(this.stereoDownmix);
    }

    public final String stereoDownmixAsString() {
        return this.stereoDownmix;
    }

    public final Eac3SurroundExMode surroundExMode() {
        return Eac3SurroundExMode.fromValue(this.surroundExMode);
    }

    public final String surroundExModeAsString() {
        return this.surroundExMode;
    }

    public final Eac3SurroundMode surroundMode() {
        return Eac3SurroundMode.fromValue(this.surroundMode);
    }

    public final String surroundModeAsString() {
        return this.surroundMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attenuationControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitstreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dcFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialnorm());
        hashCode = 31 * hashCode + Objects.hashCode(this.drcLineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.drcRfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lfeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lfeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRoCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRoSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.ltRtCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.ltRtSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.passthroughControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.phaseControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stereoDownmixAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.surroundExModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.surroundModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eac3Settings)) {
            return false;
        }
        Eac3Settings other = (Eac3Settings)obj;
        return Objects.equals(this.attenuationControlAsString(), other.attenuationControlAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bitstreamModeAsString(), other.bitstreamModeAsString()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.dcFilterAsString(), other.dcFilterAsString()) && Objects.equals(this.dialnorm(), other.dialnorm()) && Objects.equals(this.drcLineAsString(), other.drcLineAsString()) && Objects.equals(this.drcRfAsString(), other.drcRfAsString()) && Objects.equals(this.lfeControlAsString(), other.lfeControlAsString()) && Objects.equals(this.lfeFilterAsString(), other.lfeFilterAsString()) && Objects.equals(this.loRoCenterMixLevel(), other.loRoCenterMixLevel()) && Objects.equals(this.loRoSurroundMixLevel(), other.loRoSurroundMixLevel()) && Objects.equals(this.ltRtCenterMixLevel(), other.ltRtCenterMixLevel()) && Objects.equals(this.ltRtSurroundMixLevel(), other.ltRtSurroundMixLevel()) && Objects.equals(this.metadataControlAsString(), other.metadataControlAsString()) && Objects.equals(this.passthroughControlAsString(), other.passthroughControlAsString()) && Objects.equals(this.phaseControlAsString(), other.phaseControlAsString()) && Objects.equals(this.stereoDownmixAsString(), other.stereoDownmixAsString()) && Objects.equals(this.surroundExModeAsString(), other.surroundExModeAsString()) && Objects.equals(this.surroundModeAsString(), other.surroundModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Eac3Settings").add("AttenuationControl", (Object)this.attenuationControlAsString()).add("Bitrate", (Object)this.bitrate()).add("BitstreamMode", (Object)this.bitstreamModeAsString()).add("CodingMode", (Object)this.codingModeAsString()).add("DcFilter", (Object)this.dcFilterAsString()).add("Dialnorm", (Object)this.dialnorm()).add("DrcLine", (Object)this.drcLineAsString()).add("DrcRf", (Object)this.drcRfAsString()).add("LfeControl", (Object)this.lfeControlAsString()).add("LfeFilter", (Object)this.lfeFilterAsString()).add("LoRoCenterMixLevel", (Object)this.loRoCenterMixLevel()).add("LoRoSurroundMixLevel", (Object)this.loRoSurroundMixLevel()).add("LtRtCenterMixLevel", (Object)this.ltRtCenterMixLevel()).add("LtRtSurroundMixLevel", (Object)this.ltRtSurroundMixLevel()).add("MetadataControl", (Object)this.metadataControlAsString()).add("PassthroughControl", (Object)this.passthroughControlAsString()).add("PhaseControl", (Object)this.phaseControlAsString()).add("StereoDownmix", (Object)this.stereoDownmixAsString()).add("SurroundExMode", (Object)this.surroundExModeAsString()).add("SurroundMode", (Object)this.surroundModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttenuationControl": {
                return Optional.ofNullable(clazz.cast(this.attenuationControlAsString()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "BitstreamMode": {
                return Optional.ofNullable(clazz.cast(this.bitstreamModeAsString()));
            }
            case "CodingMode": {
                return Optional.ofNullable(clazz.cast(this.codingModeAsString()));
            }
            case "DcFilter": {
                return Optional.ofNullable(clazz.cast(this.dcFilterAsString()));
            }
            case "Dialnorm": {
                return Optional.ofNullable(clazz.cast(this.dialnorm()));
            }
            case "DrcLine": {
                return Optional.ofNullable(clazz.cast(this.drcLineAsString()));
            }
            case "DrcRf": {
                return Optional.ofNullable(clazz.cast(this.drcRfAsString()));
            }
            case "LfeControl": {
                return Optional.ofNullable(clazz.cast(this.lfeControlAsString()));
            }
            case "LfeFilter": {
                return Optional.ofNullable(clazz.cast(this.lfeFilterAsString()));
            }
            case "LoRoCenterMixLevel": {
                return Optional.ofNullable(clazz.cast(this.loRoCenterMixLevel()));
            }
            case "LoRoSurroundMixLevel": {
                return Optional.ofNullable(clazz.cast(this.loRoSurroundMixLevel()));
            }
            case "LtRtCenterMixLevel": {
                return Optional.ofNullable(clazz.cast(this.ltRtCenterMixLevel()));
            }
            case "LtRtSurroundMixLevel": {
                return Optional.ofNullable(clazz.cast(this.ltRtSurroundMixLevel()));
            }
            case "MetadataControl": {
                return Optional.ofNullable(clazz.cast(this.metadataControlAsString()));
            }
            case "PassthroughControl": {
                return Optional.ofNullable(clazz.cast(this.passthroughControlAsString()));
            }
            case "PhaseControl": {
                return Optional.ofNullable(clazz.cast(this.phaseControlAsString()));
            }
            case "StereoDownmix": {
                return Optional.ofNullable(clazz.cast(this.stereoDownmixAsString()));
            }
            case "SurroundExMode": {
                return Optional.ofNullable(clazz.cast(this.surroundExModeAsString()));
            }
            case "SurroundMode": {
                return Optional.ofNullable(clazz.cast(this.surroundModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Eac3Settings, T> g) {
        return obj -> g.apply((Eac3Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attenuationControl;
        private Double bitrate;
        private String bitstreamMode;
        private String codingMode;
        private String dcFilter;
        private Integer dialnorm;
        private String drcLine;
        private String drcRf;
        private String lfeControl;
        private String lfeFilter;
        private Double loRoCenterMixLevel;
        private Double loRoSurroundMixLevel;
        private Double ltRtCenterMixLevel;
        private Double ltRtSurroundMixLevel;
        private String metadataControl;
        private String passthroughControl;
        private String phaseControl;
        private String stereoDownmix;
        private String surroundExMode;
        private String surroundMode;

        private BuilderImpl() {
        }

        private BuilderImpl(Eac3Settings model) {
            this.attenuationControl(model.attenuationControl);
            this.bitrate(model.bitrate);
            this.bitstreamMode(model.bitstreamMode);
            this.codingMode(model.codingMode);
            this.dcFilter(model.dcFilter);
            this.dialnorm(model.dialnorm);
            this.drcLine(model.drcLine);
            this.drcRf(model.drcRf);
            this.lfeControl(model.lfeControl);
            this.lfeFilter(model.lfeFilter);
            this.loRoCenterMixLevel(model.loRoCenterMixLevel);
            this.loRoSurroundMixLevel(model.loRoSurroundMixLevel);
            this.ltRtCenterMixLevel(model.ltRtCenterMixLevel);
            this.ltRtSurroundMixLevel(model.ltRtSurroundMixLevel);
            this.metadataControl(model.metadataControl);
            this.passthroughControl(model.passthroughControl);
            this.phaseControl(model.phaseControl);
            this.stereoDownmix(model.stereoDownmix);
            this.surroundExMode(model.surroundExMode);
            this.surroundMode(model.surroundMode);
        }

        public final String getAttenuationControl() {
            return this.attenuationControl;
        }

        public final void setAttenuationControl(String attenuationControl) {
            this.attenuationControl = attenuationControl;
        }

        @Override
        public final Builder attenuationControl(String attenuationControl) {
            this.attenuationControl = attenuationControl;
            return this;
        }

        @Override
        public final Builder attenuationControl(Eac3AttenuationControl attenuationControl) {
            this.attenuationControl(attenuationControl == null ? null : attenuationControl.toString());
            return this;
        }

        public final Double getBitrate() {
            return this.bitrate;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getBitstreamMode() {
            return this.bitstreamMode;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        @Override
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        public final Builder bitstreamMode(Eac3BitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode == null ? null : bitstreamMode.toString());
            return this;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Eac3CodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final String getDcFilter() {
            return this.dcFilter;
        }

        public final void setDcFilter(String dcFilter) {
            this.dcFilter = dcFilter;
        }

        @Override
        public final Builder dcFilter(String dcFilter) {
            this.dcFilter = dcFilter;
            return this;
        }

        @Override
        public final Builder dcFilter(Eac3DcFilter dcFilter) {
            this.dcFilter(dcFilter == null ? null : dcFilter.toString());
            return this;
        }

        public final Integer getDialnorm() {
            return this.dialnorm;
        }

        public final void setDialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
        }

        @Override
        public final Builder dialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
            return this;
        }

        public final String getDrcLine() {
            return this.drcLine;
        }

        public final void setDrcLine(String drcLine) {
            this.drcLine = drcLine;
        }

        @Override
        public final Builder drcLine(String drcLine) {
            this.drcLine = drcLine;
            return this;
        }

        @Override
        public final Builder drcLine(Eac3DrcLine drcLine) {
            this.drcLine(drcLine == null ? null : drcLine.toString());
            return this;
        }

        public final String getDrcRf() {
            return this.drcRf;
        }

        public final void setDrcRf(String drcRf) {
            this.drcRf = drcRf;
        }

        @Override
        public final Builder drcRf(String drcRf) {
            this.drcRf = drcRf;
            return this;
        }

        @Override
        public final Builder drcRf(Eac3DrcRf drcRf) {
            this.drcRf(drcRf == null ? null : drcRf.toString());
            return this;
        }

        public final String getLfeControl() {
            return this.lfeControl;
        }

        public final void setLfeControl(String lfeControl) {
            this.lfeControl = lfeControl;
        }

        @Override
        public final Builder lfeControl(String lfeControl) {
            this.lfeControl = lfeControl;
            return this;
        }

        @Override
        public final Builder lfeControl(Eac3LfeControl lfeControl) {
            this.lfeControl(lfeControl == null ? null : lfeControl.toString());
            return this;
        }

        public final String getLfeFilter() {
            return this.lfeFilter;
        }

        public final void setLfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
        }

        @Override
        public final Builder lfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
            return this;
        }

        @Override
        public final Builder lfeFilter(Eac3LfeFilter lfeFilter) {
            this.lfeFilter(lfeFilter == null ? null : lfeFilter.toString());
            return this;
        }

        public final Double getLoRoCenterMixLevel() {
            return this.loRoCenterMixLevel;
        }

        public final void setLoRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
        }

        @Override
        public final Builder loRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
            return this;
        }

        public final Double getLoRoSurroundMixLevel() {
            return this.loRoSurroundMixLevel;
        }

        public final void setLoRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
        }

        @Override
        public final Builder loRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
            return this;
        }

        public final Double getLtRtCenterMixLevel() {
            return this.ltRtCenterMixLevel;
        }

        public final void setLtRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
        }

        @Override
        public final Builder ltRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
            return this;
        }

        public final Double getLtRtSurroundMixLevel() {
            return this.ltRtSurroundMixLevel;
        }

        public final void setLtRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
        }

        @Override
        public final Builder ltRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
            return this;
        }

        public final String getMetadataControl() {
            return this.metadataControl;
        }

        public final void setMetadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
        }

        @Override
        public final Builder metadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
            return this;
        }

        @Override
        public final Builder metadataControl(Eac3MetadataControl metadataControl) {
            this.metadataControl(metadataControl == null ? null : metadataControl.toString());
            return this;
        }

        public final String getPassthroughControl() {
            return this.passthroughControl;
        }

        public final void setPassthroughControl(String passthroughControl) {
            this.passthroughControl = passthroughControl;
        }

        @Override
        public final Builder passthroughControl(String passthroughControl) {
            this.passthroughControl = passthroughControl;
            return this;
        }

        @Override
        public final Builder passthroughControl(Eac3PassthroughControl passthroughControl) {
            this.passthroughControl(passthroughControl == null ? null : passthroughControl.toString());
            return this;
        }

        public final String getPhaseControl() {
            return this.phaseControl;
        }

        public final void setPhaseControl(String phaseControl) {
            this.phaseControl = phaseControl;
        }

        @Override
        public final Builder phaseControl(String phaseControl) {
            this.phaseControl = phaseControl;
            return this;
        }

        @Override
        public final Builder phaseControl(Eac3PhaseControl phaseControl) {
            this.phaseControl(phaseControl == null ? null : phaseControl.toString());
            return this;
        }

        public final String getStereoDownmix() {
            return this.stereoDownmix;
        }

        public final void setStereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
        }

        @Override
        public final Builder stereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
            return this;
        }

        @Override
        public final Builder stereoDownmix(Eac3StereoDownmix stereoDownmix) {
            this.stereoDownmix(stereoDownmix == null ? null : stereoDownmix.toString());
            return this;
        }

        public final String getSurroundExMode() {
            return this.surroundExMode;
        }

        public final void setSurroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
        }

        @Override
        public final Builder surroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
            return this;
        }

        @Override
        public final Builder surroundExMode(Eac3SurroundExMode surroundExMode) {
            this.surroundExMode(surroundExMode == null ? null : surroundExMode.toString());
            return this;
        }

        public final String getSurroundMode() {
            return this.surroundMode;
        }

        public final void setSurroundMode(String surroundMode) {
            this.surroundMode = surroundMode;
        }

        @Override
        public final Builder surroundMode(String surroundMode) {
            this.surroundMode = surroundMode;
            return this;
        }

        @Override
        public final Builder surroundMode(Eac3SurroundMode surroundMode) {
            this.surroundMode(surroundMode == null ? null : surroundMode.toString());
            return this;
        }

        public Eac3Settings build() {
            return new Eac3Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Eac3Settings> {
        public Builder attenuationControl(String var1);

        public Builder attenuationControl(Eac3AttenuationControl var1);

        public Builder bitrate(Double var1);

        public Builder bitstreamMode(String var1);

        public Builder bitstreamMode(Eac3BitstreamMode var1);

        public Builder codingMode(String var1);

        public Builder codingMode(Eac3CodingMode var1);

        public Builder dcFilter(String var1);

        public Builder dcFilter(Eac3DcFilter var1);

        public Builder dialnorm(Integer var1);

        public Builder drcLine(String var1);

        public Builder drcLine(Eac3DrcLine var1);

        public Builder drcRf(String var1);

        public Builder drcRf(Eac3DrcRf var1);

        public Builder lfeControl(String var1);

        public Builder lfeControl(Eac3LfeControl var1);

        public Builder lfeFilter(String var1);

        public Builder lfeFilter(Eac3LfeFilter var1);

        public Builder loRoCenterMixLevel(Double var1);

        public Builder loRoSurroundMixLevel(Double var1);

        public Builder ltRtCenterMixLevel(Double var1);

        public Builder ltRtSurroundMixLevel(Double var1);

        public Builder metadataControl(String var1);

        public Builder metadataControl(Eac3MetadataControl var1);

        public Builder passthroughControl(String var1);

        public Builder passthroughControl(Eac3PassthroughControl var1);

        public Builder phaseControl(String var1);

        public Builder phaseControl(Eac3PhaseControl var1);

        public Builder stereoDownmix(String var1);

        public Builder stereoDownmix(Eac3StereoDownmix var1);

        public Builder surroundExMode(String var1);

        public Builder surroundExMode(Eac3SurroundExMode var1);

        public Builder surroundMode(String var1);

        public Builder surroundMode(Eac3SurroundMode var1);
    }
}

