/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.Eac3AtmosCodingMode;
import software.amazon.awssdk.services.medialive.model.Eac3AtmosDrcLine;
import software.amazon.awssdk.services.medialive.model.Eac3AtmosDrcRf;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Eac3AtmosSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Eac3AtmosSettings> {
    private static final SdkField<Double> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Bitrate").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::bitrate)).setter(Eac3AtmosSettings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> CODING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodingMode").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::codingModeAsString)).setter(Eac3AtmosSettings.setter(Builder::codingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()}).build();
    private static final SdkField<Integer> DIALNORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Dialnorm").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::dialnorm)).setter(Eac3AtmosSettings.setter(Builder::dialnorm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialnorm").build()}).build();
    private static final SdkField<String> DRC_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DrcLine").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::drcLineAsString)).setter(Eac3AtmosSettings.setter(Builder::drcLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("drcLine").build()}).build();
    private static final SdkField<String> DRC_RF_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DrcRf").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::drcRfAsString)).setter(Eac3AtmosSettings.setter(Builder::drcRf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("drcRf").build()}).build();
    private static final SdkField<Double> HEIGHT_TRIM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("HeightTrim").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::heightTrim)).setter(Eac3AtmosSettings.setter(Builder::heightTrim)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heightTrim").build()}).build();
    private static final SdkField<Double> SURROUND_TRIM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SurroundTrim").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::surroundTrim)).setter(Eac3AtmosSettings.setter(Builder::surroundTrim)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("surroundTrim").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, CODING_MODE_FIELD, DIALNORM_FIELD, DRC_LINE_FIELD, DRC_RF_FIELD, HEIGHT_TRIM_FIELD, SURROUND_TRIM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bitrate", BITRATE_FIELD);
            this.put("codingMode", CODING_MODE_FIELD);
            this.put("dialnorm", DIALNORM_FIELD);
            this.put("drcLine", DRC_LINE_FIELD);
            this.put("drcRf", DRC_RF_FIELD);
            this.put("heightTrim", HEIGHT_TRIM_FIELD);
            this.put("surroundTrim", SURROUND_TRIM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double bitrate;
    private final String codingMode;
    private final Integer dialnorm;
    private final String drcLine;
    private final String drcRf;
    private final Double heightTrim;
    private final Double surroundTrim;

    private Eac3AtmosSettings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.codingMode = builder.codingMode;
        this.dialnorm = builder.dialnorm;
        this.drcLine = builder.drcLine;
        this.drcRf = builder.drcRf;
        this.heightTrim = builder.heightTrim;
        this.surroundTrim = builder.surroundTrim;
    }

    public final Double bitrate() {
        return this.bitrate;
    }

    public final Eac3AtmosCodingMode codingMode() {
        return Eac3AtmosCodingMode.fromValue(this.codingMode);
    }

    public final String codingModeAsString() {
        return this.codingMode;
    }

    public final Integer dialnorm() {
        return this.dialnorm;
    }

    public final Eac3AtmosDrcLine drcLine() {
        return Eac3AtmosDrcLine.fromValue(this.drcLine);
    }

    public final String drcLineAsString() {
        return this.drcLine;
    }

    public final Eac3AtmosDrcRf drcRf() {
        return Eac3AtmosDrcRf.fromValue(this.drcRf);
    }

    public final String drcRfAsString() {
        return this.drcRf;
    }

    public final Double heightTrim() {
        return this.heightTrim;
    }

    public final Double surroundTrim() {
        return this.surroundTrim;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialnorm());
        hashCode = 31 * hashCode + Objects.hashCode(this.drcLineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.drcRfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.heightTrim());
        hashCode = 31 * hashCode + Objects.hashCode(this.surroundTrim());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eac3AtmosSettings)) {
            return false;
        }
        Eac3AtmosSettings other = (Eac3AtmosSettings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.dialnorm(), other.dialnorm()) && Objects.equals(this.drcLineAsString(), other.drcLineAsString()) && Objects.equals(this.drcRfAsString(), other.drcRfAsString()) && Objects.equals(this.heightTrim(), other.heightTrim()) && Objects.equals(this.surroundTrim(), other.surroundTrim());
    }

    public final String toString() {
        return ToString.builder((String)"Eac3AtmosSettings").add("Bitrate", (Object)this.bitrate()).add("CodingMode", (Object)this.codingModeAsString()).add("Dialnorm", (Object)this.dialnorm()).add("DrcLine", (Object)this.drcLineAsString()).add("DrcRf", (Object)this.drcRfAsString()).add("HeightTrim", (Object)this.heightTrim()).add("SurroundTrim", (Object)this.surroundTrim()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "CodingMode": {
                return Optional.ofNullable(clazz.cast(this.codingModeAsString()));
            }
            case "Dialnorm": {
                return Optional.ofNullable(clazz.cast(this.dialnorm()));
            }
            case "DrcLine": {
                return Optional.ofNullable(clazz.cast(this.drcLineAsString()));
            }
            case "DrcRf": {
                return Optional.ofNullable(clazz.cast(this.drcRfAsString()));
            }
            case "HeightTrim": {
                return Optional.ofNullable(clazz.cast(this.heightTrim()));
            }
            case "SurroundTrim": {
                return Optional.ofNullable(clazz.cast(this.surroundTrim()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Eac3AtmosSettings, T> g) {
        return obj -> g.apply((Eac3AtmosSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double bitrate;
        private String codingMode;
        private Integer dialnorm;
        private String drcLine;
        private String drcRf;
        private Double heightTrim;
        private Double surroundTrim;

        private BuilderImpl() {
        }

        private BuilderImpl(Eac3AtmosSettings model) {
            this.bitrate(model.bitrate);
            this.codingMode(model.codingMode);
            this.dialnorm(model.dialnorm);
            this.drcLine(model.drcLine);
            this.drcRf(model.drcRf);
            this.heightTrim(model.heightTrim);
            this.surroundTrim(model.surroundTrim);
        }

        public final Double getBitrate() {
            return this.bitrate;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Eac3AtmosCodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final Integer getDialnorm() {
            return this.dialnorm;
        }

        public final void setDialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
        }

        @Override
        public final Builder dialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
            return this;
        }

        public final String getDrcLine() {
            return this.drcLine;
        }

        public final void setDrcLine(String drcLine) {
            this.drcLine = drcLine;
        }

        @Override
        public final Builder drcLine(String drcLine) {
            this.drcLine = drcLine;
            return this;
        }

        @Override
        public final Builder drcLine(Eac3AtmosDrcLine drcLine) {
            this.drcLine(drcLine == null ? null : drcLine.toString());
            return this;
        }

        public final String getDrcRf() {
            return this.drcRf;
        }

        public final void setDrcRf(String drcRf) {
            this.drcRf = drcRf;
        }

        @Override
        public final Builder drcRf(String drcRf) {
            this.drcRf = drcRf;
            return this;
        }

        @Override
        public final Builder drcRf(Eac3AtmosDrcRf drcRf) {
            this.drcRf(drcRf == null ? null : drcRf.toString());
            return this;
        }

        public final Double getHeightTrim() {
            return this.heightTrim;
        }

        public final void setHeightTrim(Double heightTrim) {
            this.heightTrim = heightTrim;
        }

        @Override
        public final Builder heightTrim(Double heightTrim) {
            this.heightTrim = heightTrim;
            return this;
        }

        public final Double getSurroundTrim() {
            return this.surroundTrim;
        }

        public final void setSurroundTrim(Double surroundTrim) {
            this.surroundTrim = surroundTrim;
        }

        @Override
        public final Builder surroundTrim(Double surroundTrim) {
            this.surroundTrim = surroundTrim;
            return this;
        }

        public Eac3AtmosSettings build() {
            return new Eac3AtmosSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Eac3AtmosSettings> {
        public Builder bitrate(Double var1);

        public Builder codingMode(String var1);

        public Builder codingMode(Eac3AtmosCodingMode var1);

        public Builder dialnorm(Integer var1);

        public Builder drcLine(String var1);

        public Builder drcLine(Eac3AtmosDrcLine var1);

        public Builder drcRf(String var1);

        public Builder drcRf(Eac3AtmosDrcRf var1);

        public Builder heightTrim(Double var1);

        public Builder surroundTrim(Double var1);
    }
}

