/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.OutputSettings;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Output
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Output> {
    private static final SdkField<List<String>> AUDIO_DESCRIPTION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudioDescriptionNames").getter(Output.getter(Output::audioDescriptionNames)).setter(Output.setter(Builder::audioDescriptionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CAPTION_DESCRIPTION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CaptionDescriptionNames").getter(Output.getter(Output::captionDescriptionNames)).setter(Output.setter(Builder::captionDescriptionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionDescriptionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OUTPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputName").getter(Output.getter(Output::outputName)).setter(Output.setter(Builder::outputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputName").build()}).build();
    private static final SdkField<OutputSettings> OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputSettings").getter(Output.getter(Output::outputSettings)).setter(Output.setter(Builder::outputSettings)).constructor(OutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSettings").build()}).build();
    private static final SdkField<String> VIDEO_DESCRIPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VideoDescriptionName").getter(Output.getter(Output::videoDescriptionName)).setter(Output.setter(Builder::videoDescriptionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoDescriptionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DESCRIPTION_NAMES_FIELD, CAPTION_DESCRIPTION_NAMES_FIELD, OUTPUT_NAME_FIELD, OUTPUT_SETTINGS_FIELD, VIDEO_DESCRIPTION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Output.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> audioDescriptionNames;
    private final List<String> captionDescriptionNames;
    private final String outputName;
    private final OutputSettings outputSettings;
    private final String videoDescriptionName;

    private Output(BuilderImpl builder) {
        this.audioDescriptionNames = builder.audioDescriptionNames;
        this.captionDescriptionNames = builder.captionDescriptionNames;
        this.outputName = builder.outputName;
        this.outputSettings = builder.outputSettings;
        this.videoDescriptionName = builder.videoDescriptionName;
    }

    public final boolean hasAudioDescriptionNames() {
        return this.audioDescriptionNames != null && !(this.audioDescriptionNames instanceof SdkAutoConstructList);
    }

    public final List<String> audioDescriptionNames() {
        return this.audioDescriptionNames;
    }

    public final boolean hasCaptionDescriptionNames() {
        return this.captionDescriptionNames != null && !(this.captionDescriptionNames instanceof SdkAutoConstructList);
    }

    public final List<String> captionDescriptionNames() {
        return this.captionDescriptionNames;
    }

    public final String outputName() {
        return this.outputName;
    }

    public final OutputSettings outputSettings() {
        return this.outputSettings;
    }

    public final String videoDescriptionName() {
        return this.videoDescriptionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioDescriptionNames() ? this.audioDescriptionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaptionDescriptionNames() ? this.captionDescriptionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoDescriptionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        return this.hasAudioDescriptionNames() == other.hasAudioDescriptionNames() && Objects.equals(this.audioDescriptionNames(), other.audioDescriptionNames()) && this.hasCaptionDescriptionNames() == other.hasCaptionDescriptionNames() && Objects.equals(this.captionDescriptionNames(), other.captionDescriptionNames()) && Objects.equals(this.outputName(), other.outputName()) && Objects.equals(this.outputSettings(), other.outputSettings()) && Objects.equals(this.videoDescriptionName(), other.videoDescriptionName());
    }

    public final String toString() {
        return ToString.builder((String)"Output").add("AudioDescriptionNames", this.hasAudioDescriptionNames() ? this.audioDescriptionNames() : null).add("CaptionDescriptionNames", this.hasCaptionDescriptionNames() ? this.captionDescriptionNames() : null).add("OutputName", (Object)this.outputName()).add("OutputSettings", (Object)this.outputSettings()).add("VideoDescriptionName", (Object)this.videoDescriptionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDescriptionNames": {
                return Optional.ofNullable(clazz.cast(this.audioDescriptionNames()));
            }
            case "CaptionDescriptionNames": {
                return Optional.ofNullable(clazz.cast(this.captionDescriptionNames()));
            }
            case "OutputName": {
                return Optional.ofNullable(clazz.cast(this.outputName()));
            }
            case "OutputSettings": {
                return Optional.ofNullable(clazz.cast(this.outputSettings()));
            }
            case "VideoDescriptionName": {
                return Optional.ofNullable(clazz.cast(this.videoDescriptionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("audioDescriptionNames", AUDIO_DESCRIPTION_NAMES_FIELD);
        map.put("captionDescriptionNames", CAPTION_DESCRIPTION_NAMES_FIELD);
        map.put("outputName", OUTPUT_NAME_FIELD);
        map.put("outputSettings", OUTPUT_SETTINGS_FIELD);
        map.put("videoDescriptionName", VIDEO_DESCRIPTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> audioDescriptionNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> captionDescriptionNames = DefaultSdkAutoConstructList.getInstance();
        private String outputName;
        private OutputSettings outputSettings;
        private String videoDescriptionName;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.audioDescriptionNames(model.audioDescriptionNames);
            this.captionDescriptionNames(model.captionDescriptionNames);
            this.outputName(model.outputName);
            this.outputSettings(model.outputSettings);
            this.videoDescriptionName(model.videoDescriptionName);
        }

        public final Collection<String> getAudioDescriptionNames() {
            if (this.audioDescriptionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audioDescriptionNames;
        }

        public final void setAudioDescriptionNames(Collection<String> audioDescriptionNames) {
            this.audioDescriptionNames = ___listOf__stringCopier.copy(audioDescriptionNames);
        }

        @Override
        public final Builder audioDescriptionNames(Collection<String> audioDescriptionNames) {
            this.audioDescriptionNames = ___listOf__stringCopier.copy(audioDescriptionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptionNames(String ... audioDescriptionNames) {
            this.audioDescriptionNames(Arrays.asList(audioDescriptionNames));
            return this;
        }

        public final Collection<String> getCaptionDescriptionNames() {
            if (this.captionDescriptionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.captionDescriptionNames;
        }

        public final void setCaptionDescriptionNames(Collection<String> captionDescriptionNames) {
            this.captionDescriptionNames = ___listOf__stringCopier.copy(captionDescriptionNames);
        }

        @Override
        public final Builder captionDescriptionNames(Collection<String> captionDescriptionNames) {
            this.captionDescriptionNames = ___listOf__stringCopier.copy(captionDescriptionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptionNames(String ... captionDescriptionNames) {
            this.captionDescriptionNames(Arrays.asList(captionDescriptionNames));
            return this;
        }

        public final String getOutputName() {
            return this.outputName;
        }

        public final void setOutputName(String outputName) {
            this.outputName = outputName;
        }

        @Override
        public final Builder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public final OutputSettings.Builder getOutputSettings() {
            return this.outputSettings != null ? this.outputSettings.toBuilder() : null;
        }

        public final void setOutputSettings(OutputSettings.BuilderImpl outputSettings) {
            this.outputSettings = outputSettings != null ? outputSettings.build() : null;
        }

        @Override
        public final Builder outputSettings(OutputSettings outputSettings) {
            this.outputSettings = outputSettings;
            return this;
        }

        public final String getVideoDescriptionName() {
            return this.videoDescriptionName;
        }

        public final void setVideoDescriptionName(String videoDescriptionName) {
            this.videoDescriptionName = videoDescriptionName;
        }

        @Override
        public final Builder videoDescriptionName(String videoDescriptionName) {
            this.videoDescriptionName = videoDescriptionName;
            return this;
        }

        public Output build() {
            return new Output(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Output> {
        public Builder audioDescriptionNames(Collection<String> var1);

        public Builder audioDescriptionNames(String ... var1);

        public Builder captionDescriptionNames(Collection<String> var1);

        public Builder captionDescriptionNames(String ... var1);

        public Builder outputName(String var1);

        public Builder outputSettings(OutputSettings var1);

        default public Builder outputSettings(Consumer<OutputSettings.Builder> outputSettings) {
            return this.outputSettings((OutputSettings)((OutputSettings.Builder)OutputSettings.builder().applyMutation(outputSettings)).build());
        }

        public Builder videoDescriptionName(String var1);
    }
}

