/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StaticImageOutputDeactivateScheduleActionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StaticImageOutputDeactivateScheduleActionSettings> {
    private static final SdkField<Integer> FADE_OUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FadeOut").getter(StaticImageOutputDeactivateScheduleActionSettings.getter(StaticImageOutputDeactivateScheduleActionSettings::fadeOut)).setter(StaticImageOutputDeactivateScheduleActionSettings.setter(Builder::fadeOut)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fadeOut").build()}).build();
    private static final SdkField<Integer> LAYER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Layer").getter(StaticImageOutputDeactivateScheduleActionSettings.getter(StaticImageOutputDeactivateScheduleActionSettings::layer)).setter(StaticImageOutputDeactivateScheduleActionSettings.setter(Builder::layer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layer").build()}).build();
    private static final SdkField<List<String>> OUTPUT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputNames").getter(StaticImageOutputDeactivateScheduleActionSettings.getter(StaticImageOutputDeactivateScheduleActionSettings::outputNames)).setter(StaticImageOutputDeactivateScheduleActionSettings.setter(Builder::outputNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FADE_OUT_FIELD, LAYER_FIELD, OUTPUT_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("fadeOut", FADE_OUT_FIELD);
            this.put("layer", LAYER_FIELD);
            this.put("outputNames", OUTPUT_NAMES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer fadeOut;
    private final Integer layer;
    private final List<String> outputNames;

    private StaticImageOutputDeactivateScheduleActionSettings(BuilderImpl builder) {
        this.fadeOut = builder.fadeOut;
        this.layer = builder.layer;
        this.outputNames = builder.outputNames;
    }

    public final Integer fadeOut() {
        return this.fadeOut;
    }

    public final Integer layer() {
        return this.layer;
    }

    public final boolean hasOutputNames() {
        return this.outputNames != null && !(this.outputNames instanceof SdkAutoConstructList);
    }

    public final List<String> outputNames() {
        return this.outputNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fadeOut());
        hashCode = 31 * hashCode + Objects.hashCode(this.layer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputNames() ? this.outputNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticImageOutputDeactivateScheduleActionSettings)) {
            return false;
        }
        StaticImageOutputDeactivateScheduleActionSettings other = (StaticImageOutputDeactivateScheduleActionSettings)obj;
        return Objects.equals(this.fadeOut(), other.fadeOut()) && Objects.equals(this.layer(), other.layer()) && this.hasOutputNames() == other.hasOutputNames() && Objects.equals(this.outputNames(), other.outputNames());
    }

    public final String toString() {
        return ToString.builder((String)"StaticImageOutputDeactivateScheduleActionSettings").add("FadeOut", (Object)this.fadeOut()).add("Layer", (Object)this.layer()).add("OutputNames", this.hasOutputNames() ? this.outputNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FadeOut": {
                return Optional.ofNullable(clazz.cast(this.fadeOut()));
            }
            case "Layer": {
                return Optional.ofNullable(clazz.cast(this.layer()));
            }
            case "OutputNames": {
                return Optional.ofNullable(clazz.cast(this.outputNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StaticImageOutputDeactivateScheduleActionSettings, T> g) {
        return obj -> g.apply((StaticImageOutputDeactivateScheduleActionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fadeOut;
        private Integer layer;
        private List<String> outputNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StaticImageOutputDeactivateScheduleActionSettings model) {
            this.fadeOut(model.fadeOut);
            this.layer(model.layer);
            this.outputNames(model.outputNames);
        }

        public final Integer getFadeOut() {
            return this.fadeOut;
        }

        public final void setFadeOut(Integer fadeOut) {
            this.fadeOut = fadeOut;
        }

        @Override
        public final Builder fadeOut(Integer fadeOut) {
            this.fadeOut = fadeOut;
            return this;
        }

        public final Integer getLayer() {
            return this.layer;
        }

        public final void setLayer(Integer layer) {
            this.layer = layer;
        }

        @Override
        public final Builder layer(Integer layer) {
            this.layer = layer;
            return this;
        }

        public final Collection<String> getOutputNames() {
            if (this.outputNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputNames;
        }

        public final void setOutputNames(Collection<String> outputNames) {
            this.outputNames = ___listOf__stringCopier.copy(outputNames);
        }

        @Override
        public final Builder outputNames(Collection<String> outputNames) {
            this.outputNames = ___listOf__stringCopier.copy(outputNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputNames(String ... outputNames) {
            this.outputNames(Arrays.asList(outputNames));
            return this;
        }

        public StaticImageOutputDeactivateScheduleActionSettings build() {
            return new StaticImageOutputDeactivateScheduleActionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StaticImageOutputDeactivateScheduleActionSettings> {
        public Builder fadeOut(Integer var1);

        public Builder layer(Integer var1);

        public Builder outputNames(Collection<String> var1);

        public Builder outputNames(String ... var1);
    }
}

