/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AudioSilenceFailoverSettings;
import software.amazon.awssdk.services.medialive.model.InputLossFailoverSettings;
import software.amazon.awssdk.services.medialive.model.VideoBlackFailoverSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailoverConditionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailoverConditionSettings> {
    private static final SdkField<AudioSilenceFailoverSettings> AUDIO_SILENCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioSilenceSettings").getter(FailoverConditionSettings.getter(FailoverConditionSettings::audioSilenceSettings)).setter(FailoverConditionSettings.setter(Builder::audioSilenceSettings)).constructor(AudioSilenceFailoverSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSilenceSettings").build()}).build();
    private static final SdkField<InputLossFailoverSettings> INPUT_LOSS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputLossSettings").getter(FailoverConditionSettings.getter(FailoverConditionSettings::inputLossSettings)).setter(FailoverConditionSettings.setter(Builder::inputLossSettings)).constructor(InputLossFailoverSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossSettings").build()}).build();
    private static final SdkField<VideoBlackFailoverSettings> VIDEO_BLACK_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoBlackSettings").getter(FailoverConditionSettings.getter(FailoverConditionSettings::videoBlackSettings)).setter(FailoverConditionSettings.setter(Builder::videoBlackSettings)).constructor(VideoBlackFailoverSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoBlackSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_SILENCE_SETTINGS_FIELD, INPUT_LOSS_SETTINGS_FIELD, VIDEO_BLACK_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("audioSilenceSettings", AUDIO_SILENCE_SETTINGS_FIELD);
            this.put("inputLossSettings", INPUT_LOSS_SETTINGS_FIELD);
            this.put("videoBlackSettings", VIDEO_BLACK_SETTINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AudioSilenceFailoverSettings audioSilenceSettings;
    private final InputLossFailoverSettings inputLossSettings;
    private final VideoBlackFailoverSettings videoBlackSettings;

    private FailoverConditionSettings(BuilderImpl builder) {
        this.audioSilenceSettings = builder.audioSilenceSettings;
        this.inputLossSettings = builder.inputLossSettings;
        this.videoBlackSettings = builder.videoBlackSettings;
    }

    public final AudioSilenceFailoverSettings audioSilenceSettings() {
        return this.audioSilenceSettings;
    }

    public final InputLossFailoverSettings inputLossSettings() {
        return this.inputLossSettings;
    }

    public final VideoBlackFailoverSettings videoBlackSettings() {
        return this.videoBlackSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSilenceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoBlackSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverConditionSettings)) {
            return false;
        }
        FailoverConditionSettings other = (FailoverConditionSettings)obj;
        return Objects.equals(this.audioSilenceSettings(), other.audioSilenceSettings()) && Objects.equals(this.inputLossSettings(), other.inputLossSettings()) && Objects.equals(this.videoBlackSettings(), other.videoBlackSettings());
    }

    public final String toString() {
        return ToString.builder((String)"FailoverConditionSettings").add("AudioSilenceSettings", (Object)this.audioSilenceSettings()).add("InputLossSettings", (Object)this.inputLossSettings()).add("VideoBlackSettings", (Object)this.videoBlackSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioSilenceSettings": {
                return Optional.ofNullable(clazz.cast(this.audioSilenceSettings()));
            }
            case "InputLossSettings": {
                return Optional.ofNullable(clazz.cast(this.inputLossSettings()));
            }
            case "VideoBlackSettings": {
                return Optional.ofNullable(clazz.cast(this.videoBlackSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FailoverConditionSettings, T> g) {
        return obj -> g.apply((FailoverConditionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioSilenceFailoverSettings audioSilenceSettings;
        private InputLossFailoverSettings inputLossSettings;
        private VideoBlackFailoverSettings videoBlackSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverConditionSettings model) {
            this.audioSilenceSettings(model.audioSilenceSettings);
            this.inputLossSettings(model.inputLossSettings);
            this.videoBlackSettings(model.videoBlackSettings);
        }

        public final AudioSilenceFailoverSettings.Builder getAudioSilenceSettings() {
            return this.audioSilenceSettings != null ? this.audioSilenceSettings.toBuilder() : null;
        }

        public final void setAudioSilenceSettings(AudioSilenceFailoverSettings.BuilderImpl audioSilenceSettings) {
            this.audioSilenceSettings = audioSilenceSettings != null ? audioSilenceSettings.build() : null;
        }

        @Override
        public final Builder audioSilenceSettings(AudioSilenceFailoverSettings audioSilenceSettings) {
            this.audioSilenceSettings = audioSilenceSettings;
            return this;
        }

        public final InputLossFailoverSettings.Builder getInputLossSettings() {
            return this.inputLossSettings != null ? this.inputLossSettings.toBuilder() : null;
        }

        public final void setInputLossSettings(InputLossFailoverSettings.BuilderImpl inputLossSettings) {
            this.inputLossSettings = inputLossSettings != null ? inputLossSettings.build() : null;
        }

        @Override
        public final Builder inputLossSettings(InputLossFailoverSettings inputLossSettings) {
            this.inputLossSettings = inputLossSettings;
            return this;
        }

        public final VideoBlackFailoverSettings.Builder getVideoBlackSettings() {
            return this.videoBlackSettings != null ? this.videoBlackSettings.toBuilder() : null;
        }

        public final void setVideoBlackSettings(VideoBlackFailoverSettings.BuilderImpl videoBlackSettings) {
            this.videoBlackSettings = videoBlackSettings != null ? videoBlackSettings.build() : null;
        }

        @Override
        public final Builder videoBlackSettings(VideoBlackFailoverSettings videoBlackSettings) {
            this.videoBlackSettings = videoBlackSettings;
            return this;
        }

        public FailoverConditionSettings build() {
            return new FailoverConditionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailoverConditionSettings> {
        public Builder audioSilenceSettings(AudioSilenceFailoverSettings var1);

        default public Builder audioSilenceSettings(Consumer<AudioSilenceFailoverSettings.Builder> audioSilenceSettings) {
            return this.audioSilenceSettings((AudioSilenceFailoverSettings)((AudioSilenceFailoverSettings.Builder)AudioSilenceFailoverSettings.builder().applyMutation(audioSilenceSettings)).build());
        }

        public Builder inputLossSettings(InputLossFailoverSettings var1);

        default public Builder inputLossSettings(Consumer<InputLossFailoverSettings.Builder> inputLossSettings) {
            return this.inputLossSettings((InputLossFailoverSettings)((InputLossFailoverSettings.Builder)InputLossFailoverSettings.builder().applyMutation(inputLossSettings)).build());
        }

        public Builder videoBlackSettings(VideoBlackFailoverSettings var1);

        default public Builder videoBlackSettings(Consumer<VideoBlackFailoverSettings.Builder> videoBlackSettings) {
            return this.videoBlackSettings((VideoBlackFailoverSettings)((VideoBlackFailoverSettings.Builder)VideoBlackFailoverSettings.builder().applyMutation(videoBlackSettings)).build());
        }
    }
}

