/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InterfaceMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InterfaceMapping> {
    private static final SdkField<String> LOGICAL_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalInterfaceName").getter(InterfaceMapping.getter(InterfaceMapping::logicalInterfaceName)).setter(InterfaceMapping.setter(Builder::logicalInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalInterfaceName").build()}).build();
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkId").getter(InterfaceMapping.getter(InterfaceMapping::networkId)).setter(InterfaceMapping.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_INTERFACE_NAME_FIELD, NETWORK_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logicalInterfaceName;
    private final String networkId;

    private InterfaceMapping(BuilderImpl builder) {
        this.logicalInterfaceName = builder.logicalInterfaceName;
        this.networkId = builder.networkId;
    }

    public final String logicalInterfaceName() {
        return this.logicalInterfaceName;
    }

    public final String networkId() {
        return this.networkId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterfaceMapping)) {
            return false;
        }
        InterfaceMapping other = (InterfaceMapping)obj;
        return Objects.equals(this.logicalInterfaceName(), other.logicalInterfaceName()) && Objects.equals(this.networkId(), other.networkId());
    }

    public final String toString() {
        return ToString.builder((String)"InterfaceMapping").add("LogicalInterfaceName", (Object)this.logicalInterfaceName()).add("NetworkId", (Object)this.networkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogicalInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.logicalInterfaceName()));
            }
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InterfaceMapping, T> g) {
        return obj -> g.apply((InterfaceMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logicalInterfaceName;
        private String networkId;

        private BuilderImpl() {
        }

        private BuilderImpl(InterfaceMapping model) {
            this.logicalInterfaceName(model.logicalInterfaceName);
            this.networkId(model.networkId);
        }

        public final String getLogicalInterfaceName() {
            return this.logicalInterfaceName;
        }

        public final void setLogicalInterfaceName(String logicalInterfaceName) {
            this.logicalInterfaceName = logicalInterfaceName;
        }

        @Override
        public final Builder logicalInterfaceName(String logicalInterfaceName) {
            this.logicalInterfaceName = logicalInterfaceName;
            return this;
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public InterfaceMapping build() {
            return new InterfaceMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InterfaceMapping> {
        public Builder logicalInterfaceName(String var1);

        public Builder networkId(String var1);
    }
}

