/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.Algorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SrtCallerDecryption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SrtCallerDecryption> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Algorithm").getter(SrtCallerDecryption.getter(SrtCallerDecryption::algorithmAsString)).setter(SrtCallerDecryption.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()}).build();
    private static final SdkField<String> PASSPHRASE_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PassphraseSecretArn").getter(SrtCallerDecryption.getter(SrtCallerDecryption::passphraseSecretArn)).setter(SrtCallerDecryption.setter(Builder::passphraseSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passphraseSecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, PASSPHRASE_SECRET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final String passphraseSecretArn;

    private SrtCallerDecryption(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.passphraseSecretArn = builder.passphraseSecretArn;
    }

    public final Algorithm algorithm() {
        return Algorithm.fromValue(this.algorithm);
    }

    public final String algorithmAsString() {
        return this.algorithm;
    }

    public final String passphraseSecretArn() {
        return this.passphraseSecretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.passphraseSecretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtCallerDecryption)) {
            return false;
        }
        SrtCallerDecryption other = (SrtCallerDecryption)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && Objects.equals(this.passphraseSecretArn(), other.passphraseSecretArn());
    }

    public final String toString() {
        return ToString.builder((String)"SrtCallerDecryption").add("Algorithm", (Object)this.algorithmAsString()).add("PassphraseSecretArn", (Object)this.passphraseSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "PassphraseSecretArn": {
                return Optional.ofNullable(clazz.cast(this.passphraseSecretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SrtCallerDecryption, T> g) {
        return obj -> g.apply((SrtCallerDecryption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String passphraseSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtCallerDecryption model) {
            this.algorithm(model.algorithm);
            this.passphraseSecretArn(model.passphraseSecretArn);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(Algorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final String getPassphraseSecretArn() {
            return this.passphraseSecretArn;
        }

        public final void setPassphraseSecretArn(String passphraseSecretArn) {
            this.passphraseSecretArn = passphraseSecretArn;
        }

        @Override
        public final Builder passphraseSecretArn(String passphraseSecretArn) {
            this.passphraseSecretArn = passphraseSecretArn;
            return this;
        }

        public SrtCallerDecryption build() {
            return new SrtCallerDecryption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SrtCallerDecryption> {
        public Builder algorithm(String var1);

        public Builder algorithm(Algorithm var1);

        public Builder passphraseSecretArn(String var1);
    }
}

