/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.BandwidthReductionFilterStrength;
import software.amazon.awssdk.services.medialive.model.BandwidthReductionPostFilterSharpening;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BandwidthReductionFilterSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BandwidthReductionFilterSettings> {
    private static final SdkField<String> POST_FILTER_SHARPENING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostFilterSharpening").getter(BandwidthReductionFilterSettings.getter(BandwidthReductionFilterSettings::postFilterSharpeningAsString)).setter(BandwidthReductionFilterSettings.setter(Builder::postFilterSharpening)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postFilterSharpening").build()}).build();
    private static final SdkField<String> STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Strength").getter(BandwidthReductionFilterSettings.getter(BandwidthReductionFilterSettings::strengthAsString)).setter(BandwidthReductionFilterSettings.setter(Builder::strength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POST_FILTER_SHARPENING_FIELD, STRENGTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String postFilterSharpening;
    private final String strength;

    private BandwidthReductionFilterSettings(BuilderImpl builder) {
        this.postFilterSharpening = builder.postFilterSharpening;
        this.strength = builder.strength;
    }

    public final BandwidthReductionPostFilterSharpening postFilterSharpening() {
        return BandwidthReductionPostFilterSharpening.fromValue(this.postFilterSharpening);
    }

    public final String postFilterSharpeningAsString() {
        return this.postFilterSharpening;
    }

    public final BandwidthReductionFilterStrength strength() {
        return BandwidthReductionFilterStrength.fromValue(this.strength);
    }

    public final String strengthAsString() {
        return this.strength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.postFilterSharpeningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.strengthAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BandwidthReductionFilterSettings)) {
            return false;
        }
        BandwidthReductionFilterSettings other = (BandwidthReductionFilterSettings)obj;
        return Objects.equals(this.postFilterSharpeningAsString(), other.postFilterSharpeningAsString()) && Objects.equals(this.strengthAsString(), other.strengthAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BandwidthReductionFilterSettings").add("PostFilterSharpening", (Object)this.postFilterSharpeningAsString()).add("Strength", (Object)this.strengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PostFilterSharpening": {
                return Optional.ofNullable(clazz.cast(this.postFilterSharpeningAsString()));
            }
            case "Strength": {
                return Optional.ofNullable(clazz.cast(this.strengthAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BandwidthReductionFilterSettings, T> g) {
        return obj -> g.apply((BandwidthReductionFilterSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String postFilterSharpening;
        private String strength;

        private BuilderImpl() {
        }

        private BuilderImpl(BandwidthReductionFilterSettings model) {
            this.postFilterSharpening(model.postFilterSharpening);
            this.strength(model.strength);
        }

        public final String getPostFilterSharpening() {
            return this.postFilterSharpening;
        }

        public final void setPostFilterSharpening(String postFilterSharpening) {
            this.postFilterSharpening = postFilterSharpening;
        }

        @Override
        public final Builder postFilterSharpening(String postFilterSharpening) {
            this.postFilterSharpening = postFilterSharpening;
            return this;
        }

        @Override
        public final Builder postFilterSharpening(BandwidthReductionPostFilterSharpening postFilterSharpening) {
            this.postFilterSharpening(postFilterSharpening == null ? null : postFilterSharpening.toString());
            return this;
        }

        public final String getStrength() {
            return this.strength;
        }

        public final void setStrength(String strength) {
            this.strength = strength;
        }

        @Override
        public final Builder strength(String strength) {
            this.strength = strength;
            return this;
        }

        @Override
        public final Builder strength(BandwidthReductionFilterStrength strength) {
            this.strength(strength == null ? null : strength.toString());
            return this;
        }

        public BandwidthReductionFilterSettings build() {
            return new BandwidthReductionFilterSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BandwidthReductionFilterSettings> {
        public Builder postFilterSharpening(String var1);

        public Builder postFilterSharpening(BandwidthReductionPostFilterSharpening var1);

        public Builder strength(String var1);

        public Builder strength(BandwidthReductionFilterStrength var1);
    }
}

