/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.NodeInterfaceMappingCreateRequest;
import software.amazon.awssdk.services.medialive.model.NodeRole;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfNodeInterfaceMappingCreateRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNodeRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, CreateNodeRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(CreateNodeRequest.getter(CreateNodeRequest::clusterId)).setter(CreateNodeRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateNodeRequest.getter(CreateNodeRequest::name)).setter(CreateNodeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<NodeInterfaceMappingCreateRequest>> NODE_INTERFACE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeInterfaceMappings").getter(CreateNodeRequest.getter(CreateNodeRequest::nodeInterfaceMappings)).setter(CreateNodeRequest.setter(Builder::nodeInterfaceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInterfaceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeInterfaceMappingCreateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateNodeRequest.getter(CreateNodeRequest::requestId)).setter(CreateNodeRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateNodeRequest.getter(CreateNodeRequest::roleAsString)).setter(CreateNodeRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateNodeRequest.getter(CreateNodeRequest::tags)).setter(CreateNodeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, NAME_FIELD, NODE_INTERFACE_MAPPINGS_FIELD, REQUEST_ID_FIELD, ROLE_FIELD, TAGS_FIELD));
    private final String clusterId;
    private final String name;
    private final List<NodeInterfaceMappingCreateRequest> nodeInterfaceMappings;
    private final String requestId;
    private final String role;
    private final Map<String, String> tags;

    private CreateNodeRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.name = builder.name;
        this.nodeInterfaceMappings = builder.nodeInterfaceMappings;
        this.requestId = builder.requestId;
        this.role = builder.role;
        this.tags = builder.tags;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNodeInterfaceMappings() {
        return this.nodeInterfaceMappings != null && !(this.nodeInterfaceMappings instanceof SdkAutoConstructList);
    }

    public final List<NodeInterfaceMappingCreateRequest> nodeInterfaceMappings() {
        return this.nodeInterfaceMappings;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final NodeRole role() {
        return NodeRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeInterfaceMappings() ? this.nodeInterfaceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodeRequest)) {
            return false;
        }
        CreateNodeRequest other = (CreateNodeRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.name(), other.name()) && this.hasNodeInterfaceMappings() == other.hasNodeInterfaceMappings() && Objects.equals(this.nodeInterfaceMappings(), other.nodeInterfaceMappings()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.roleAsString(), other.roleAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNodeRequest").add("ClusterId", (Object)this.clusterId()).add("Name", (Object)this.name()).add("NodeInterfaceMappings", this.hasNodeInterfaceMappings() ? this.nodeInterfaceMappings() : null).add("RequestId", (Object)this.requestId()).add("Role", (Object)this.roleAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NodeInterfaceMappings": {
                return Optional.ofNullable(clazz.cast(this.nodeInterfaceMappings()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNodeRequest, T> g) {
        return obj -> g.apply((CreateNodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private String name;
        private List<NodeInterfaceMappingCreateRequest> nodeInterfaceMappings = DefaultSdkAutoConstructList.getInstance();
        private String requestId;
        private String role;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodeRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.name(model.name);
            this.nodeInterfaceMappings(model.nodeInterfaceMappings);
            this.requestId(model.requestId);
            this.role(model.role);
            this.tags(model.tags);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<NodeInterfaceMappingCreateRequest.Builder> getNodeInterfaceMappings() {
            List<NodeInterfaceMappingCreateRequest.Builder> result = ___listOfNodeInterfaceMappingCreateRequestCopier.copyToBuilder(this.nodeInterfaceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeInterfaceMappings(Collection<NodeInterfaceMappingCreateRequest.BuilderImpl> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCreateRequestCopier.copyFromBuilder(nodeInterfaceMappings);
        }

        @Override
        public final Builder nodeInterfaceMappings(Collection<NodeInterfaceMappingCreateRequest> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCreateRequestCopier.copy(nodeInterfaceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(NodeInterfaceMappingCreateRequest ... nodeInterfaceMappings) {
            this.nodeInterfaceMappings(Arrays.asList(nodeInterfaceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(Consumer<NodeInterfaceMappingCreateRequest.Builder> ... nodeInterfaceMappings) {
            this.nodeInterfaceMappings(Stream.of(nodeInterfaceMappings).map(c -> (NodeInterfaceMappingCreateRequest)((NodeInterfaceMappingCreateRequest.Builder)NodeInterfaceMappingCreateRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(NodeRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNodeRequest build() {
            return new CreateNodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNodeRequest> {
        public Builder clusterId(String var1);

        public Builder name(String var1);

        public Builder nodeInterfaceMappings(Collection<NodeInterfaceMappingCreateRequest> var1);

        public Builder nodeInterfaceMappings(NodeInterfaceMappingCreateRequest ... var1);

        public Builder nodeInterfaceMappings(Consumer<NodeInterfaceMappingCreateRequest.Builder> ... var1);

        public Builder requestId(String var1);

        public Builder role(String var1);

        public Builder role(NodeRole var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

