/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramSummary;

public class ListMultiplexProgramsPublisher
implements SdkPublisher<ListMultiplexProgramsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListMultiplexProgramsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMultiplexProgramsPublisher(MediaLiveAsyncClient client, ListMultiplexProgramsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMultiplexProgramsPublisher(MediaLiveAsyncClient client, ListMultiplexProgramsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMultiplexProgramsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMultiplexProgramsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MultiplexProgramSummary> multiplexPrograms() {
        Function<ListMultiplexProgramsResponse, Iterator> getIterator = response -> {
            if (response != null && response.multiplexPrograms() != null) {
                return response.multiplexPrograms().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMultiplexProgramsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMultiplexProgramsResponseFetcher
    implements AsyncPageFetcher<ListMultiplexProgramsResponse> {
        private ListMultiplexProgramsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultiplexProgramsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMultiplexProgramsResponse> nextPage(ListMultiplexProgramsResponse previousPage) {
            if (previousPage == null) {
                return ListMultiplexProgramsPublisher.this.client.listMultiplexPrograms(ListMultiplexProgramsPublisher.this.firstRequest);
            }
            return ListMultiplexProgramsPublisher.this.client.listMultiplexPrograms((ListMultiplexProgramsRequest)((Object)ListMultiplexProgramsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

