/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AvailSettings;
import software.amazon.awssdk.services.medialive.model.Scte35SegmentationScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailConfiguration> {
    private static final SdkField<AvailSettings> AVAIL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailSettings").getter(AvailConfiguration.getter(AvailConfiguration::availSettings)).setter(AvailConfiguration.setter(Builder::availSettings)).constructor(AvailSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availSettings").build()}).build();
    private static final SdkField<String> SCTE35_SEGMENTATION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35SegmentationScope").getter(AvailConfiguration.getter(AvailConfiguration::scte35SegmentationScopeAsString)).setter(AvailConfiguration.setter(Builder::scte35SegmentationScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35SegmentationScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAIL_SETTINGS_FIELD, SCTE35_SEGMENTATION_SCOPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final AvailSettings availSettings;
    private final String scte35SegmentationScope;

    private AvailConfiguration(BuilderImpl builder) {
        this.availSettings = builder.availSettings;
        this.scte35SegmentationScope = builder.scte35SegmentationScope;
    }

    public final AvailSettings availSettings() {
        return this.availSettings;
    }

    public final Scte35SegmentationScope scte35SegmentationScope() {
        return Scte35SegmentationScope.fromValue(this.scte35SegmentationScope);
    }

    public final String scte35SegmentationScopeAsString() {
        return this.scte35SegmentationScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35SegmentationScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailConfiguration)) {
            return false;
        }
        AvailConfiguration other = (AvailConfiguration)obj;
        return Objects.equals(this.availSettings(), other.availSettings()) && Objects.equals(this.scte35SegmentationScopeAsString(), other.scte35SegmentationScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AvailConfiguration").add("AvailSettings", (Object)this.availSettings()).add("Scte35SegmentationScope", (Object)this.scte35SegmentationScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailSettings": {
                return Optional.ofNullable(clazz.cast(this.availSettings()));
            }
            case "Scte35SegmentationScope": {
                return Optional.ofNullable(clazz.cast(this.scte35SegmentationScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailConfiguration, T> g) {
        return obj -> g.apply((AvailConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AvailSettings availSettings;
        private String scte35SegmentationScope;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailConfiguration model) {
            this.availSettings(model.availSettings);
            this.scte35SegmentationScope(model.scte35SegmentationScope);
        }

        public final AvailSettings.Builder getAvailSettings() {
            return this.availSettings != null ? this.availSettings.toBuilder() : null;
        }

        public final void setAvailSettings(AvailSettings.BuilderImpl availSettings) {
            this.availSettings = availSettings != null ? availSettings.build() : null;
        }

        @Override
        public final Builder availSettings(AvailSettings availSettings) {
            this.availSettings = availSettings;
            return this;
        }

        public final String getScte35SegmentationScope() {
            return this.scte35SegmentationScope;
        }

        public final void setScte35SegmentationScope(String scte35SegmentationScope) {
            this.scte35SegmentationScope = scte35SegmentationScope;
        }

        @Override
        public final Builder scte35SegmentationScope(String scte35SegmentationScope) {
            this.scte35SegmentationScope = scte35SegmentationScope;
            return this;
        }

        @Override
        public final Builder scte35SegmentationScope(Scte35SegmentationScope scte35SegmentationScope) {
            this.scte35SegmentationScope(scte35SegmentationScope == null ? null : scte35SegmentationScope.toString());
            return this;
        }

        public AvailConfiguration build() {
            return new AvailConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailConfiguration> {
        public Builder availSettings(AvailSettings var1);

        default public Builder availSettings(Consumer<AvailSettings.Builder> availSettings) {
            return this.availSettings((AvailSettings)((AvailSettings.Builder)AvailSettings.builder().applyMutation(availSettings)).build());
        }

        public Builder scte35SegmentationScope(String var1);

        public Builder scte35SegmentationScope(Scte35SegmentationScope var1);
    }
}

