/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse;
import software.amazon.awssdk.services.medialive.model.SignalMapSummary;

public class ListSignalMapsPublisher
implements SdkPublisher<ListSignalMapsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListSignalMapsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSignalMapsPublisher(MediaLiveAsyncClient client, ListSignalMapsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSignalMapsPublisher(MediaLiveAsyncClient client, ListSignalMapsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSignalMapsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSignalMapsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SignalMapSummary> signalMaps() {
        Function<ListSignalMapsResponse, Iterator> getIterator = response -> {
            if (response != null && response.signalMaps() != null) {
                return response.signalMaps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSignalMapsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSignalMapsResponseFetcher
    implements AsyncPageFetcher<ListSignalMapsResponse> {
        private ListSignalMapsResponseFetcher() {
        }

        public boolean hasNextPage(ListSignalMapsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSignalMapsResponse> nextPage(ListSignalMapsResponse previousPage) {
            if (previousPage == null) {
                return ListSignalMapsPublisher.this.client.listSignalMaps(ListSignalMapsPublisher.this.firstRequest);
            }
            return ListSignalMapsPublisher.this.client.listSignalMaps((ListSignalMapsRequest)((Object)ListSignalMapsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

