/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateGroupSummary;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse;

public class ListCloudWatchAlarmTemplateGroupsIterable
implements SdkIterable<ListCloudWatchAlarmTemplateGroupsResponse> {
    private final MediaLiveClient client;
    private final ListCloudWatchAlarmTemplateGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCloudWatchAlarmTemplateGroupsIterable(MediaLiveClient client, ListCloudWatchAlarmTemplateGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCloudWatchAlarmTemplateGroupsResponseFetcher();
    }

    public Iterator<ListCloudWatchAlarmTemplateGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CloudWatchAlarmTemplateGroupSummary> cloudWatchAlarmTemplateGroups() {
        Function<ListCloudWatchAlarmTemplateGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudWatchAlarmTemplateGroups() != null) {
                return response.cloudWatchAlarmTemplateGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCloudWatchAlarmTemplateGroupsResponseFetcher
    implements SyncPageFetcher<ListCloudWatchAlarmTemplateGroupsResponse> {
        private ListCloudWatchAlarmTemplateGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudWatchAlarmTemplateGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCloudWatchAlarmTemplateGroupsResponse nextPage(ListCloudWatchAlarmTemplateGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListCloudWatchAlarmTemplateGroupsIterable.this.client.listCloudWatchAlarmTemplateGroups(ListCloudWatchAlarmTemplateGroupsIterable.this.firstRequest);
            }
            return ListCloudWatchAlarmTemplateGroupsIterable.this.client.listCloudWatchAlarmTemplateGroups((ListCloudWatchAlarmTemplateGroupsRequest)((Object)ListCloudWatchAlarmTemplateGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

