/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidationError> {
    private static final SdkField<String> ELEMENT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElementPath").getter(ValidationError.getter(ValidationError::elementPath)).setter(ValidationError.setter(Builder::elementPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementPath").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(ValidationError.getter(ValidationError::errorMessage)).setter(ValidationError.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_PATH_FIELD, ERROR_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String elementPath;
    private final String errorMessage;

    private ValidationError(BuilderImpl builder) {
        this.elementPath = builder.elementPath;
        this.errorMessage = builder.errorMessage;
    }

    public final String elementPath() {
        return this.elementPath;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elementPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationError)) {
            return false;
        }
        ValidationError other = (ValidationError)obj;
        return Objects.equals(this.elementPath(), other.elementPath()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ValidationError").add("ElementPath", (Object)this.elementPath()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElementPath": {
                return Optional.ofNullable(clazz.cast(this.elementPath()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationError, T> g) {
        return obj -> g.apply((ValidationError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String elementPath;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationError model) {
            this.elementPath(model.elementPath);
            this.errorMessage(model.errorMessage);
        }

        public final String getElementPath() {
            return this.elementPath;
        }

        public final void setElementPath(String elementPath) {
            this.elementPath = elementPath;
        }

        @Override
        public final Builder elementPath(String elementPath) {
            this.elementPath = elementPath;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ValidationError build() {
            return new ValidationError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationError> {
        public Builder elementPath(String var1);

        public Builder errorMessage(String var1);
    }
}

