/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.InputSecurityGroup;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;

public class ListInputSecurityGroupsIterable
implements SdkIterable<ListInputSecurityGroupsResponse> {
    private final MediaLiveClient client;
    private final ListInputSecurityGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInputSecurityGroupsIterable(MediaLiveClient client, ListInputSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInputSecurityGroupsResponseFetcher();
    }

    public Iterator<ListInputSecurityGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InputSecurityGroup> inputSecurityGroups() {
        Function<ListInputSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inputSecurityGroups() != null) {
                return response.inputSecurityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInputSecurityGroupsResponseFetcher
    implements SyncPageFetcher<ListInputSecurityGroupsResponse> {
        private ListInputSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListInputSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInputSecurityGroupsResponse nextPage(ListInputSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListInputSecurityGroupsIterable.this.client.listInputSecurityGroups(ListInputSecurityGroupsIterable.this.firstRequest);
            }
            return ListInputSecurityGroupsIterable.this.client.listInputSecurityGroups((ListInputSecurityGroupsRequest)((Object)ListInputSecurityGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

