/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm;
import software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithmControl;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioNormalizationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioNormalizationSettings> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Algorithm").getter(AudioNormalizationSettings.getter(AudioNormalizationSettings::algorithmAsString)).setter(AudioNormalizationSettings.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()}).build();
    private static final SdkField<String> ALGORITHM_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmControl").getter(AudioNormalizationSettings.getter(AudioNormalizationSettings::algorithmControlAsString)).setter(AudioNormalizationSettings.setter(Builder::algorithmControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmControl").build()}).build();
    private static final SdkField<Double> TARGET_LKFS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TargetLkfs").getter(AudioNormalizationSettings.getter(AudioNormalizationSettings::targetLkfs)).setter(AudioNormalizationSettings.setter(Builder::targetLkfs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLkfs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, ALGORITHM_CONTROL_FIELD, TARGET_LKFS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final String algorithmControl;
    private final Double targetLkfs;

    private AudioNormalizationSettings(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.algorithmControl = builder.algorithmControl;
        this.targetLkfs = builder.targetLkfs;
    }

    public final AudioNormalizationAlgorithm algorithm() {
        return AudioNormalizationAlgorithm.fromValue(this.algorithm);
    }

    public final String algorithmAsString() {
        return this.algorithm;
    }

    public final AudioNormalizationAlgorithmControl algorithmControl() {
        return AudioNormalizationAlgorithmControl.fromValue(this.algorithmControl);
    }

    public final String algorithmControlAsString() {
        return this.algorithmControl;
    }

    public final Double targetLkfs() {
        return this.targetLkfs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLkfs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioNormalizationSettings)) {
            return false;
        }
        AudioNormalizationSettings other = (AudioNormalizationSettings)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && Objects.equals(this.algorithmControlAsString(), other.algorithmControlAsString()) && Objects.equals(this.targetLkfs(), other.targetLkfs());
    }

    public final String toString() {
        return ToString.builder((String)"AudioNormalizationSettings").add("Algorithm", (Object)this.algorithmAsString()).add("AlgorithmControl", (Object)this.algorithmControlAsString()).add("TargetLkfs", (Object)this.targetLkfs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "AlgorithmControl": {
                return Optional.ofNullable(clazz.cast(this.algorithmControlAsString()));
            }
            case "TargetLkfs": {
                return Optional.ofNullable(clazz.cast(this.targetLkfs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioNormalizationSettings, T> g) {
        return obj -> g.apply((AudioNormalizationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String algorithmControl;
        private Double targetLkfs;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioNormalizationSettings model) {
            this.algorithm(model.algorithm);
            this.algorithmControl(model.algorithmControl);
            this.targetLkfs(model.targetLkfs);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(AudioNormalizationAlgorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final String getAlgorithmControl() {
            return this.algorithmControl;
        }

        public final void setAlgorithmControl(String algorithmControl) {
            this.algorithmControl = algorithmControl;
        }

        @Override
        public final Builder algorithmControl(String algorithmControl) {
            this.algorithmControl = algorithmControl;
            return this;
        }

        @Override
        public final Builder algorithmControl(AudioNormalizationAlgorithmControl algorithmControl) {
            this.algorithmControl(algorithmControl == null ? null : algorithmControl.toString());
            return this;
        }

        public final Double getTargetLkfs() {
            return this.targetLkfs;
        }

        public final void setTargetLkfs(Double targetLkfs) {
            this.targetLkfs = targetLkfs;
        }

        @Override
        public final Builder targetLkfs(Double targetLkfs) {
            this.targetLkfs = targetLkfs;
            return this;
        }

        public AudioNormalizationSettings build() {
            return new AudioNormalizationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioNormalizationSettings> {
        public Builder algorithm(String var1);

        public Builder algorithm(AudioNormalizationAlgorithm var1);

        public Builder algorithmControl(String var1);

        public Builder algorithmControl(AudioNormalizationAlgorithmControl var1);

        public Builder targetLkfs(Double var1);
    }
}

