/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AfdSignaling;
import software.amazon.awssdk.services.medialive.model.FixedAfd;
import software.amazon.awssdk.services.medialive.model.H265AdaptiveQuantization;
import software.amazon.awssdk.services.medialive.model.H265AlternativeTransferFunction;
import software.amazon.awssdk.services.medialive.model.H265ColorMetadata;
import software.amazon.awssdk.services.medialive.model.H265ColorSpaceSettings;
import software.amazon.awssdk.services.medialive.model.H265FilterSettings;
import software.amazon.awssdk.services.medialive.model.H265FlickerAq;
import software.amazon.awssdk.services.medialive.model.H265GopSizeUnits;
import software.amazon.awssdk.services.medialive.model.H265Level;
import software.amazon.awssdk.services.medialive.model.H265LookAheadRateControl;
import software.amazon.awssdk.services.medialive.model.H265Profile;
import software.amazon.awssdk.services.medialive.model.H265RateControlMode;
import software.amazon.awssdk.services.medialive.model.H265ScanType;
import software.amazon.awssdk.services.medialive.model.H265SceneChangeDetect;
import software.amazon.awssdk.services.medialive.model.H265Tier;
import software.amazon.awssdk.services.medialive.model.H265TimecodeInsertionBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H265Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, H265Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdaptiveQuantization").getter(H265Settings.getter(H265Settings::adaptiveQuantizationAsString)).setter(H265Settings.setter(Builder::adaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build()}).build();
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfdSignaling").getter(H265Settings.getter(H265Settings::afdSignalingAsString)).setter(H265Settings.setter(Builder::afdSignaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()}).build();
    private static final SdkField<String> ALTERNATIVE_TRANSFER_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlternativeTransferFunction").getter(H265Settings.getter(H265Settings::alternativeTransferFunctionAsString)).setter(H265Settings.setter(Builder::alternativeTransferFunction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternativeTransferFunction").build()}).build();
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bitrate").getter(H265Settings.getter(H265Settings::bitrate)).setter(H265Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<Integer> BUF_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BufSize").getter(H265Settings.getter(H265Settings::bufSize)).setter(H265Settings.setter(Builder::bufSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufSize").build()}).build();
    private static final SdkField<String> COLOR_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorMetadata").getter(H265Settings.getter(H265Settings::colorMetadataAsString)).setter(H265Settings.setter(Builder::colorMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorMetadata").build()}).build();
    private static final SdkField<H265ColorSpaceSettings> COLOR_SPACE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorSpaceSettings").getter(H265Settings.getter(H265Settings::colorSpaceSettings)).setter(H265Settings.setter(Builder::colorSpaceSettings)).constructor(H265ColorSpaceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceSettings").build()}).build();
    private static final SdkField<H265FilterSettings> FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterSettings").getter(H265Settings.getter(H265Settings::filterSettings)).setter(H265Settings.setter(Builder::filterSettings)).constructor(H265FilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterSettings").build()}).build();
    private static final SdkField<String> FIXED_AFD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FixedAfd").getter(H265Settings.getter(H265Settings::fixedAfdAsString)).setter(H265Settings.setter(Builder::fixedAfd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()}).build();
    private static final SdkField<String> FLICKER_AQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlickerAq").getter(H265Settings.getter(H265Settings::flickerAqAsString)).setter(H265Settings.setter(Builder::flickerAq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAq").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(H265Settings.getter(H265Settings::framerateDenominator)).setter(H265Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(H265Settings.getter(H265Settings::framerateNumerator)).setter(H265Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GopClosedCadence").getter(H265Settings.getter(H265Settings::gopClosedCadence)).setter(H265Settings.setter(Builder::gopClosedCadence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()}).build();
    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("GopSize").getter(H265Settings.getter(H265Settings::gopSize)).setter(H265Settings.setter(Builder::gopSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()}).build();
    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GopSizeUnits").getter(H265Settings.getter(H265Settings::gopSizeUnitsAsString)).setter(H265Settings.setter(Builder::gopSizeUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Level").getter(H265Settings.getter(H265Settings::levelAsString)).setter(H265Settings.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<String> LOOK_AHEAD_RATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookAheadRateControl").getter(H265Settings.getter(H265Settings::lookAheadRateControlAsString)).setter(H265Settings.setter(Builder::lookAheadRateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookAheadRateControl").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(H265Settings.getter(H265Settings::maxBitrate)).setter(H265Settings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinIInterval").getter(H265Settings.getter(H265Settings::minIInterval)).setter(H265Settings.setter(Builder::minIInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()}).build();
    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParDenominator").getter(H265Settings.getter(H265Settings::parDenominator)).setter(H265Settings.setter(Builder::parDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()}).build();
    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParNumerator").getter(H265Settings.getter(H265Settings::parNumerator)).setter(H265Settings.setter(Builder::parNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()}).build();
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Profile").getter(H265Settings.getter(H265Settings::profileAsString)).setter(H265Settings.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()}).build();
    private static final SdkField<Integer> QVBR_QUALITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("QvbrQualityLevel").getter(H265Settings.getter(H265Settings::qvbrQualityLevel)).setter(H265Settings.setter(Builder::qvbrQualityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevel").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RateControlMode").getter(H265Settings.getter(H265Settings::rateControlModeAsString)).setter(H265Settings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(H265Settings.getter(H265Settings::scanTypeAsString)).setter(H265Settings.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SceneChangeDetect").getter(H265Settings.getter(H265Settings::sceneChangeDetectAsString)).setter(H265Settings.setter(Builder::sceneChangeDetect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()}).build();
    private static final SdkField<Integer> SLICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Slices").getter(H265Settings.getter(H265Settings::slices)).setter(H265Settings.setter(Builder::slices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(H265Settings.getter(H265Settings::tierAsString)).setter(H265Settings.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()}).build();
    private static final SdkField<String> TIMECODE_INSERTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimecodeInsertion").getter(H265Settings.getter(H265Settings::timecodeInsertionAsString)).setter(H265Settings.setter(Builder::timecodeInsertion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeInsertion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD, AFD_SIGNALING_FIELD, ALTERNATIVE_TRANSFER_FUNCTION_FIELD, BITRATE_FIELD, BUF_SIZE_FIELD, COLOR_METADATA_FIELD, COLOR_SPACE_SETTINGS_FIELD, FILTER_SETTINGS_FIELD, FIXED_AFD_FIELD, FLICKER_AQ_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_CLOSED_CADENCE_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, LEVEL_FIELD, LOOK_AHEAD_RATE_CONTROL_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, PROFILE_FIELD, QVBR_QUALITY_LEVEL_FIELD, RATE_CONTROL_MODE_FIELD, SCAN_TYPE_FIELD, SCENE_CHANGE_DETECT_FIELD, SLICES_FIELD, TIER_FIELD, TIMECODE_INSERTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adaptiveQuantization;
    private final String afdSignaling;
    private final String alternativeTransferFunction;
    private final Integer bitrate;
    private final Integer bufSize;
    private final String colorMetadata;
    private final H265ColorSpaceSettings colorSpaceSettings;
    private final H265FilterSettings filterSettings;
    private final String fixedAfd;
    private final String flickerAq;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final Integer gopClosedCadence;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final String level;
    private final String lookAheadRateControl;
    private final Integer maxBitrate;
    private final Integer minIInterval;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final String profile;
    private final Integer qvbrQualityLevel;
    private final String rateControlMode;
    private final String scanType;
    private final String sceneChangeDetect;
    private final Integer slices;
    private final String tier;
    private final String timecodeInsertion;

    private H265Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.afdSignaling = builder.afdSignaling;
        this.alternativeTransferFunction = builder.alternativeTransferFunction;
        this.bitrate = builder.bitrate;
        this.bufSize = builder.bufSize;
        this.colorMetadata = builder.colorMetadata;
        this.colorSpaceSettings = builder.colorSpaceSettings;
        this.filterSettings = builder.filterSettings;
        this.fixedAfd = builder.fixedAfd;
        this.flickerAq = builder.flickerAq;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.level = builder.level;
        this.lookAheadRateControl = builder.lookAheadRateControl;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.profile = builder.profile;
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
        this.rateControlMode = builder.rateControlMode;
        this.scanType = builder.scanType;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.tier = builder.tier;
        this.timecodeInsertion = builder.timecodeInsertion;
    }

    public final H265AdaptiveQuantization adaptiveQuantization() {
        return H265AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public final String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public final AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(this.afdSignaling);
    }

    public final String afdSignalingAsString() {
        return this.afdSignaling;
    }

    public final H265AlternativeTransferFunction alternativeTransferFunction() {
        return H265AlternativeTransferFunction.fromValue(this.alternativeTransferFunction);
    }

    public final String alternativeTransferFunctionAsString() {
        return this.alternativeTransferFunction;
    }

    public final Integer bitrate() {
        return this.bitrate;
    }

    public final Integer bufSize() {
        return this.bufSize;
    }

    public final H265ColorMetadata colorMetadata() {
        return H265ColorMetadata.fromValue(this.colorMetadata);
    }

    public final String colorMetadataAsString() {
        return this.colorMetadata;
    }

    public final H265ColorSpaceSettings colorSpaceSettings() {
        return this.colorSpaceSettings;
    }

    public final H265FilterSettings filterSettings() {
        return this.filterSettings;
    }

    public final FixedAfd fixedAfd() {
        return FixedAfd.fromValue(this.fixedAfd);
    }

    public final String fixedAfdAsString() {
        return this.fixedAfd;
    }

    public final H265FlickerAq flickerAq() {
        return H265FlickerAq.fromValue(this.flickerAq);
    }

    public final String flickerAqAsString() {
        return this.flickerAq;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public final Double gopSize() {
        return this.gopSize;
    }

    public final H265GopSizeUnits gopSizeUnits() {
        return H265GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public final String gopSizeUnitsAsString() {
        return this.gopSizeUnits;
    }

    public final H265Level level() {
        return H265Level.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final H265LookAheadRateControl lookAheadRateControl() {
        return H265LookAheadRateControl.fromValue(this.lookAheadRateControl);
    }

    public final String lookAheadRateControlAsString() {
        return this.lookAheadRateControl;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final Integer minIInterval() {
        return this.minIInterval;
    }

    public final Integer parDenominator() {
        return this.parDenominator;
    }

    public final Integer parNumerator() {
        return this.parNumerator;
    }

    public final H265Profile profile() {
        return H265Profile.fromValue(this.profile);
    }

    public final String profileAsString() {
        return this.profile;
    }

    public final Integer qvbrQualityLevel() {
        return this.qvbrQualityLevel;
    }

    public final H265RateControlMode rateControlMode() {
        return H265RateControlMode.fromValue(this.rateControlMode);
    }

    public final String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public final H265ScanType scanType() {
        return H265ScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public final H265SceneChangeDetect sceneChangeDetect() {
        return H265SceneChangeDetect.fromValue(this.sceneChangeDetect);
    }

    public final String sceneChangeDetectAsString() {
        return this.sceneChangeDetect;
    }

    public final Integer slices() {
        return this.slices;
    }

    public final H265Tier tier() {
        return H265Tier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final H265TimecodeInsertionBehavior timecodeInsertion() {
        return H265TimecodeInsertionBehavior.fromValue(this.timecodeInsertion);
    }

    public final String timecodeInsertionAsString() {
        return this.timecodeInsertion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternativeTransferFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorMetadataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flickerAqAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookAheadRateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.qvbrQualityLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slices());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeInsertionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H265Settings)) {
            return false;
        }
        H265Settings other = (H265Settings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.afdSignalingAsString(), other.afdSignalingAsString()) && Objects.equals(this.alternativeTransferFunctionAsString(), other.alternativeTransferFunctionAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bufSize(), other.bufSize()) && Objects.equals(this.colorMetadataAsString(), other.colorMetadataAsString()) && Objects.equals(this.colorSpaceSettings(), other.colorSpaceSettings()) && Objects.equals(this.filterSettings(), other.filterSettings()) && Objects.equals(this.fixedAfdAsString(), other.fixedAfdAsString()) && Objects.equals(this.flickerAqAsString(), other.flickerAqAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsAsString(), other.gopSizeUnitsAsString()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.lookAheadRateControlAsString(), other.lookAheadRateControlAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.minIInterval(), other.minIInterval()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.profileAsString(), other.profileAsString()) && Objects.equals(this.qvbrQualityLevel(), other.qvbrQualityLevel()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString()) && Objects.equals(this.sceneChangeDetectAsString(), other.sceneChangeDetectAsString()) && Objects.equals(this.slices(), other.slices()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.timecodeInsertionAsString(), other.timecodeInsertionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"H265Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("AfdSignaling", (Object)this.afdSignalingAsString()).add("AlternativeTransferFunction", (Object)this.alternativeTransferFunctionAsString()).add("Bitrate", (Object)this.bitrate()).add("BufSize", (Object)this.bufSize()).add("ColorMetadata", (Object)this.colorMetadataAsString()).add("ColorSpaceSettings", (Object)this.colorSpaceSettings()).add("FilterSettings", (Object)this.filterSettings()).add("FixedAfd", (Object)this.fixedAfdAsString()).add("FlickerAq", (Object)this.flickerAqAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsAsString()).add("Level", (Object)this.levelAsString()).add("LookAheadRateControl", (Object)this.lookAheadRateControlAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("MinIInterval", (Object)this.minIInterval()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("Profile", (Object)this.profileAsString()).add("QvbrQualityLevel", (Object)this.qvbrQualityLevel()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("ScanType", (Object)this.scanTypeAsString()).add("SceneChangeDetect", (Object)this.sceneChangeDetectAsString()).add("Slices", (Object)this.slices()).add("Tier", (Object)this.tierAsString()).add("TimecodeInsertion", (Object)this.timecodeInsertionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "AfdSignaling": {
                return Optional.ofNullable(clazz.cast(this.afdSignalingAsString()));
            }
            case "AlternativeTransferFunction": {
                return Optional.ofNullable(clazz.cast(this.alternativeTransferFunctionAsString()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "BufSize": {
                return Optional.ofNullable(clazz.cast(this.bufSize()));
            }
            case "ColorMetadata": {
                return Optional.ofNullable(clazz.cast(this.colorMetadataAsString()));
            }
            case "ColorSpaceSettings": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceSettings()));
            }
            case "FilterSettings": {
                return Optional.ofNullable(clazz.cast(this.filterSettings()));
            }
            case "FixedAfd": {
                return Optional.ofNullable(clazz.cast(this.fixedAfdAsString()));
            }
            case "FlickerAq": {
                return Optional.ofNullable(clazz.cast(this.flickerAqAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopClosedCadence": {
                return Optional.ofNullable(clazz.cast(this.gopClosedCadence()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.ofNullable(clazz.cast(this.gopSizeUnitsAsString()));
            }
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "LookAheadRateControl": {
                return Optional.ofNullable(clazz.cast(this.lookAheadRateControlAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MinIInterval": {
                return Optional.ofNullable(clazz.cast(this.minIInterval()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profileAsString()));
            }
            case "QvbrQualityLevel": {
                return Optional.ofNullable(clazz.cast(this.qvbrQualityLevel()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
            case "SceneChangeDetect": {
                return Optional.ofNullable(clazz.cast(this.sceneChangeDetectAsString()));
            }
            case "Slices": {
                return Optional.ofNullable(clazz.cast(this.slices()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "TimecodeInsertion": {
                return Optional.ofNullable(clazz.cast(this.timecodeInsertionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H265Settings, T> g) {
        return obj -> g.apply((H265Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private String afdSignaling;
        private String alternativeTransferFunction;
        private Integer bitrate;
        private Integer bufSize;
        private String colorMetadata;
        private H265ColorSpaceSettings colorSpaceSettings;
        private H265FilterSettings filterSettings;
        private String fixedAfd;
        private String flickerAq;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private Integer gopClosedCadence;
        private Double gopSize;
        private String gopSizeUnits;
        private String level;
        private String lookAheadRateControl;
        private Integer maxBitrate;
        private Integer minIInterval;
        private Integer parDenominator;
        private Integer parNumerator;
        private String profile;
        private Integer qvbrQualityLevel;
        private String rateControlMode;
        private String scanType;
        private String sceneChangeDetect;
        private Integer slices;
        private String tier;
        private String timecodeInsertion;

        private BuilderImpl() {
        }

        private BuilderImpl(H265Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.afdSignaling(model.afdSignaling);
            this.alternativeTransferFunction(model.alternativeTransferFunction);
            this.bitrate(model.bitrate);
            this.bufSize(model.bufSize);
            this.colorMetadata(model.colorMetadata);
            this.colorSpaceSettings(model.colorSpaceSettings);
            this.filterSettings(model.filterSettings);
            this.fixedAfd(model.fixedAfd);
            this.flickerAq(model.flickerAq);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopClosedCadence(model.gopClosedCadence);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.level(model.level);
            this.lookAheadRateControl(model.lookAheadRateControl);
            this.maxBitrate(model.maxBitrate);
            this.minIInterval(model.minIInterval);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.profile(model.profile);
            this.qvbrQualityLevel(model.qvbrQualityLevel);
            this.rateControlMode(model.rateControlMode);
            this.scanType(model.scanType);
            this.sceneChangeDetect(model.sceneChangeDetect);
            this.slices(model.slices);
            this.tier(model.tier);
            this.timecodeInsertion(model.timecodeInsertion);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        @Override
        @Transient
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        @Transient
        public final Builder adaptiveQuantization(H265AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final String getAfdSignaling() {
            return this.afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        @Transient
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        @Transient
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final String getAlternativeTransferFunction() {
            return this.alternativeTransferFunction;
        }

        public final void setAlternativeTransferFunction(String alternativeTransferFunction) {
            this.alternativeTransferFunction = alternativeTransferFunction;
        }

        @Override
        @Transient
        public final Builder alternativeTransferFunction(String alternativeTransferFunction) {
            this.alternativeTransferFunction = alternativeTransferFunction;
            return this;
        }

        @Override
        @Transient
        public final Builder alternativeTransferFunction(H265AlternativeTransferFunction alternativeTransferFunction) {
            this.alternativeTransferFunction(alternativeTransferFunction == null ? null : alternativeTransferFunction.toString());
            return this;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        @Transient
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final Integer getBufSize() {
            return this.bufSize;
        }

        public final void setBufSize(Integer bufSize) {
            this.bufSize = bufSize;
        }

        @Override
        @Transient
        public final Builder bufSize(Integer bufSize) {
            this.bufSize = bufSize;
            return this;
        }

        public final String getColorMetadata() {
            return this.colorMetadata;
        }

        public final void setColorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
        }

        @Override
        @Transient
        public final Builder colorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
            return this;
        }

        @Override
        @Transient
        public final Builder colorMetadata(H265ColorMetadata colorMetadata) {
            this.colorMetadata(colorMetadata == null ? null : colorMetadata.toString());
            return this;
        }

        public final H265ColorSpaceSettings.Builder getColorSpaceSettings() {
            return this.colorSpaceSettings != null ? this.colorSpaceSettings.toBuilder() : null;
        }

        public final void setColorSpaceSettings(H265ColorSpaceSettings.BuilderImpl colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings != null ? colorSpaceSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder colorSpaceSettings(H265ColorSpaceSettings colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings;
            return this;
        }

        public final H265FilterSettings.Builder getFilterSettings() {
            return this.filterSettings != null ? this.filterSettings.toBuilder() : null;
        }

        public final void setFilterSettings(H265FilterSettings.BuilderImpl filterSettings) {
            this.filterSettings = filterSettings != null ? filterSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder filterSettings(H265FilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public final String getFixedAfd() {
            return this.fixedAfd;
        }

        public final void setFixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        @Override
        @Transient
        public final Builder fixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        @Override
        @Transient
        public final Builder fixedAfd(FixedAfd fixedAfd) {
            this.fixedAfd(fixedAfd == null ? null : fixedAfd.toString());
            return this;
        }

        public final String getFlickerAq() {
            return this.flickerAq;
        }

        public final void setFlickerAq(String flickerAq) {
            this.flickerAq = flickerAq;
        }

        @Override
        @Transient
        public final Builder flickerAq(String flickerAq) {
            this.flickerAq = flickerAq;
            return this;
        }

        @Override
        @Transient
        public final Builder flickerAq(H265FlickerAq flickerAq) {
            this.flickerAq(flickerAq == null ? null : flickerAq.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        @Transient
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        @Transient
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        @Transient
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        @Transient
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        @Override
        @Transient
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        @Transient
        public final Builder gopSizeUnits(H265GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        @Transient
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        @Transient
        public final Builder level(H265Level level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getLookAheadRateControl() {
            return this.lookAheadRateControl;
        }

        public final void setLookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
        }

        @Override
        @Transient
        public final Builder lookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
            return this;
        }

        @Override
        @Transient
        public final Builder lookAheadRateControl(H265LookAheadRateControl lookAheadRateControl) {
            this.lookAheadRateControl(lookAheadRateControl == null ? null : lookAheadRateControl.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        @Transient
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMinIInterval() {
            return this.minIInterval;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        @Override
        @Transient
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        @Override
        @Transient
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        @Override
        @Transient
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final String getProfile() {
            return this.profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        @Transient
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        @Transient
        public final Builder profile(H265Profile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final Integer getQvbrQualityLevel() {
            return this.qvbrQualityLevel;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        @Override
        @Transient
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        @Override
        @Transient
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        @Transient
        public final Builder rateControlMode(H265RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        @Transient
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        @Transient
        public final Builder scanType(H265ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final String getSceneChangeDetect() {
            return this.sceneChangeDetect;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        @Override
        @Transient
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        @Transient
        public final Builder sceneChangeDetect(H265SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final Integer getSlices() {
            return this.slices;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        @Override
        @Transient
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        @Transient
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        @Transient
        public final Builder tier(H265Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getTimecodeInsertion() {
            return this.timecodeInsertion;
        }

        public final void setTimecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
        }

        @Override
        @Transient
        public final Builder timecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
            return this;
        }

        @Override
        @Transient
        public final Builder timecodeInsertion(H265TimecodeInsertionBehavior timecodeInsertion) {
            this.timecodeInsertion(timecodeInsertion == null ? null : timecodeInsertion.toString());
            return this;
        }

        public H265Settings build() {
            return new H265Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, H265Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(H265AdaptiveQuantization var1);

        public Builder afdSignaling(String var1);

        public Builder afdSignaling(AfdSignaling var1);

        public Builder alternativeTransferFunction(String var1);

        public Builder alternativeTransferFunction(H265AlternativeTransferFunction var1);

        public Builder bitrate(Integer var1);

        public Builder bufSize(Integer var1);

        public Builder colorMetadata(String var1);

        public Builder colorMetadata(H265ColorMetadata var1);

        public Builder colorSpaceSettings(H265ColorSpaceSettings var1);

        default public Builder colorSpaceSettings(Consumer<H265ColorSpaceSettings.Builder> colorSpaceSettings) {
            return this.colorSpaceSettings((H265ColorSpaceSettings)((H265ColorSpaceSettings.Builder)H265ColorSpaceSettings.builder().applyMutation(colorSpaceSettings)).build());
        }

        public Builder filterSettings(H265FilterSettings var1);

        default public Builder filterSettings(Consumer<H265FilterSettings.Builder> filterSettings) {
            return this.filterSettings((H265FilterSettings)((H265FilterSettings.Builder)H265FilterSettings.builder().applyMutation(filterSettings)).build());
        }

        public Builder fixedAfd(String var1);

        public Builder fixedAfd(FixedAfd var1);

        public Builder flickerAq(String var1);

        public Builder flickerAq(H265FlickerAq var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(H265GopSizeUnits var1);

        public Builder level(String var1);

        public Builder level(H265Level var1);

        public Builder lookAheadRateControl(String var1);

        public Builder lookAheadRateControl(H265LookAheadRateControl var1);

        public Builder maxBitrate(Integer var1);

        public Builder minIInterval(Integer var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder profile(String var1);

        public Builder profile(H265Profile var1);

        public Builder qvbrQualityLevel(Integer var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(H265RateControlMode var1);

        public Builder scanType(String var1);

        public Builder scanType(H265ScanType var1);

        public Builder sceneChangeDetect(String var1);

        public Builder sceneChangeDetect(H265SceneChangeDetect var1);

        public Builder slices(Integer var1);

        public Builder tier(String var1);

        public Builder tier(H265Tier var1);

        public Builder timecodeInsertion(String var1);

        public Builder timecodeInsertion(H265TimecodeInsertionBehavior var1);
    }
}

