/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.Fmp4NielsenId3Behavior;
import software.amazon.awssdk.services.medialive.model.Fmp4TimedMetadataBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Fmp4HlsSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Fmp4HlsSettings> {
    private static final SdkField<String> AUDIO_RENDITION_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioRenditionSets").getter(Fmp4HlsSettings.getter(Fmp4HlsSettings::audioRenditionSets)).setter(Fmp4HlsSettings.setter(Builder::audioRenditionSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioRenditionSets").build()}).build();
    private static final SdkField<String> NIELSEN_ID3_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NielsenId3Behavior").getter(Fmp4HlsSettings.getter(Fmp4HlsSettings::nielsenId3BehaviorAsString)).setter(Fmp4HlsSettings.setter(Builder::nielsenId3Behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3Behavior").build()}).build();
    private static final SdkField<String> TIMED_METADATA_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimedMetadataBehavior").getter(Fmp4HlsSettings.getter(Fmp4HlsSettings::timedMetadataBehaviorAsString)).setter(Fmp4HlsSettings.setter(Builder::timedMetadataBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_RENDITION_SETS_FIELD, NIELSEN_ID3_BEHAVIOR_FIELD, TIMED_METADATA_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioRenditionSets;
    private final String nielsenId3Behavior;
    private final String timedMetadataBehavior;

    private Fmp4HlsSettings(BuilderImpl builder) {
        this.audioRenditionSets = builder.audioRenditionSets;
        this.nielsenId3Behavior = builder.nielsenId3Behavior;
        this.timedMetadataBehavior = builder.timedMetadataBehavior;
    }

    public final String audioRenditionSets() {
        return this.audioRenditionSets;
    }

    public final Fmp4NielsenId3Behavior nielsenId3Behavior() {
        return Fmp4NielsenId3Behavior.fromValue(this.nielsenId3Behavior);
    }

    public final String nielsenId3BehaviorAsString() {
        return this.nielsenId3Behavior;
    }

    public final Fmp4TimedMetadataBehavior timedMetadataBehavior() {
        return Fmp4TimedMetadataBehavior.fromValue(this.timedMetadataBehavior);
    }

    public final String timedMetadataBehaviorAsString() {
        return this.timedMetadataBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioRenditionSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.nielsenId3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fmp4HlsSettings)) {
            return false;
        }
        Fmp4HlsSettings other = (Fmp4HlsSettings)obj;
        return Objects.equals(this.audioRenditionSets(), other.audioRenditionSets()) && Objects.equals(this.nielsenId3BehaviorAsString(), other.nielsenId3BehaviorAsString()) && Objects.equals(this.timedMetadataBehaviorAsString(), other.timedMetadataBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Fmp4HlsSettings").add("AudioRenditionSets", (Object)this.audioRenditionSets()).add("NielsenId3Behavior", (Object)this.nielsenId3BehaviorAsString()).add("TimedMetadataBehavior", (Object)this.timedMetadataBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioRenditionSets": {
                return Optional.ofNullable(clazz.cast(this.audioRenditionSets()));
            }
            case "NielsenId3Behavior": {
                return Optional.ofNullable(clazz.cast(this.nielsenId3BehaviorAsString()));
            }
            case "TimedMetadataBehavior": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Fmp4HlsSettings, T> g) {
        return obj -> g.apply((Fmp4HlsSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioRenditionSets;
        private String nielsenId3Behavior;
        private String timedMetadataBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(Fmp4HlsSettings model) {
            this.audioRenditionSets(model.audioRenditionSets);
            this.nielsenId3Behavior(model.nielsenId3Behavior);
            this.timedMetadataBehavior(model.timedMetadataBehavior);
        }

        public final String getAudioRenditionSets() {
            return this.audioRenditionSets;
        }

        @Override
        public final Builder audioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
            return this;
        }

        public final void setAudioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
        }

        public final String getNielsenId3Behavior() {
            return this.nielsenId3Behavior;
        }

        @Override
        public final Builder nielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
            return this;
        }

        @Override
        public final Builder nielsenId3Behavior(Fmp4NielsenId3Behavior nielsenId3Behavior) {
            this.nielsenId3Behavior(nielsenId3Behavior == null ? null : nielsenId3Behavior.toString());
            return this;
        }

        public final void setNielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
        }

        public final String getTimedMetadataBehavior() {
            return this.timedMetadataBehavior;
        }

        @Override
        public final Builder timedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
            return this;
        }

        @Override
        public final Builder timedMetadataBehavior(Fmp4TimedMetadataBehavior timedMetadataBehavior) {
            this.timedMetadataBehavior(timedMetadataBehavior == null ? null : timedMetadataBehavior.toString());
            return this;
        }

        public final void setTimedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
        }

        public Fmp4HlsSettings build() {
            return new Fmp4HlsSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Fmp4HlsSettings> {
        public Builder audioRenditionSets(String var1);

        public Builder nielsenId3Behavior(String var1);

        public Builder nielsenId3Behavior(Fmp4NielsenId3Behavior var1);

        public Builder timedMetadataBehavior(String var1);

        public Builder timedMetadataBehavior(Fmp4TimedMetadataBehavior var1);
    }
}

