/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsInputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsInputSettings> {
    private static final SdkField<Integer> BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bandwidth").getter(HlsInputSettings.getter(HlsInputSettings::bandwidth)).setter(HlsInputSettings.setter(Builder::bandwidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidth").build()}).build();
    private static final SdkField<Integer> BUFFER_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BufferSegments").getter(HlsInputSettings.getter(HlsInputSettings::bufferSegments)).setter(HlsInputSettings.setter(Builder::bufferSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufferSegments").build()}).build();
    private static final SdkField<Integer> RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Retries").getter(HlsInputSettings.getter(HlsInputSettings::retries)).setter(HlsInputSettings.setter(Builder::retries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retries").build()}).build();
    private static final SdkField<Integer> RETRY_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetryInterval").getter(HlsInputSettings.getter(HlsInputSettings::retryInterval)).setter(HlsInputSettings.setter(Builder::retryInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BANDWIDTH_FIELD, BUFFER_SEGMENTS_FIELD, RETRIES_FIELD, RETRY_INTERVAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer bandwidth;
    private final Integer bufferSegments;
    private final Integer retries;
    private final Integer retryInterval;

    private HlsInputSettings(BuilderImpl builder) {
        this.bandwidth = builder.bandwidth;
        this.bufferSegments = builder.bufferSegments;
        this.retries = builder.retries;
        this.retryInterval = builder.retryInterval;
    }

    public final Integer bandwidth() {
        return this.bandwidth;
    }

    public final Integer bufferSegments() {
        return this.bufferSegments;
    }

    public final Integer retries() {
        return this.retries;
    }

    public final Integer retryInterval() {
        return this.retryInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferSegments());
        hashCode = 31 * hashCode + Objects.hashCode(this.retries());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryInterval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsInputSettings)) {
            return false;
        }
        HlsInputSettings other = (HlsInputSettings)obj;
        return Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.bufferSegments(), other.bufferSegments()) && Objects.equals(this.retries(), other.retries()) && Objects.equals(this.retryInterval(), other.retryInterval());
    }

    public final String toString() {
        return ToString.builder((String)"HlsInputSettings").add("Bandwidth", (Object)this.bandwidth()).add("BufferSegments", (Object)this.bufferSegments()).add("Retries", (Object)this.retries()).add("RetryInterval", (Object)this.retryInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "BufferSegments": {
                return Optional.ofNullable(clazz.cast(this.bufferSegments()));
            }
            case "Retries": {
                return Optional.ofNullable(clazz.cast(this.retries()));
            }
            case "RetryInterval": {
                return Optional.ofNullable(clazz.cast(this.retryInterval()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsInputSettings, T> g) {
        return obj -> g.apply((HlsInputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bandwidth;
        private Integer bufferSegments;
        private Integer retries;
        private Integer retryInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsInputSettings model) {
            this.bandwidth(model.bandwidth);
            this.bufferSegments(model.bufferSegments);
            this.retries(model.retries);
            this.retryInterval(model.retryInterval);
        }

        public final Integer getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final Integer getBufferSegments() {
            return this.bufferSegments;
        }

        @Override
        public final Builder bufferSegments(Integer bufferSegments) {
            this.bufferSegments = bufferSegments;
            return this;
        }

        public final void setBufferSegments(Integer bufferSegments) {
            this.bufferSegments = bufferSegments;
        }

        public final Integer getRetries() {
            return this.retries;
        }

        @Override
        public final Builder retries(Integer retries) {
            this.retries = retries;
            return this;
        }

        public final void setRetries(Integer retries) {
            this.retries = retries;
        }

        public final Integer getRetryInterval() {
            return this.retryInterval;
        }

        @Override
        public final Builder retryInterval(Integer retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public final void setRetryInterval(Integer retryInterval) {
            this.retryInterval = retryInterval;
        }

        public HlsInputSettings build() {
            return new HlsInputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsInputSettings> {
        public Builder bandwidth(Integer var1);

        public Builder bufferSegments(Integer var1);

        public Builder retries(Integer var1);

        public Builder retryInterval(Integer var1);
    }
}

