/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.EmbeddedConvert608To708;
import software.amazon.awssdk.services.medialive.model.EmbeddedScte20Detection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmbeddedSourceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmbeddedSourceSettings> {
    private static final SdkField<String> CONVERT608_TO708_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Convert608To708").getter(EmbeddedSourceSettings.getter(EmbeddedSourceSettings::convert608To708AsString)).setter(EmbeddedSourceSettings.setter(Builder::convert608To708)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convert608To708").build()}).build();
    private static final SdkField<String> SCTE20_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte20Detection").getter(EmbeddedSourceSettings.getter(EmbeddedSourceSettings::scte20DetectionAsString)).setter(EmbeddedSourceSettings.setter(Builder::scte20Detection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte20Detection").build()}).build();
    private static final SdkField<Integer> SOURCE608_CHANNEL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Source608ChannelNumber").getter(EmbeddedSourceSettings.getter(EmbeddedSourceSettings::source608ChannelNumber)).setter(EmbeddedSourceSettings.setter(Builder::source608ChannelNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source608ChannelNumber").build()}).build();
    private static final SdkField<Integer> SOURCE608_TRACK_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Source608TrackNumber").getter(EmbeddedSourceSettings.getter(EmbeddedSourceSettings::source608TrackNumber)).setter(EmbeddedSourceSettings.setter(Builder::source608TrackNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source608TrackNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERT608_TO708_FIELD, SCTE20_DETECTION_FIELD, SOURCE608_CHANNEL_NUMBER_FIELD, SOURCE608_TRACK_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String convert608To708;
    private final String scte20Detection;
    private final Integer source608ChannelNumber;
    private final Integer source608TrackNumber;

    private EmbeddedSourceSettings(BuilderImpl builder) {
        this.convert608To708 = builder.convert608To708;
        this.scte20Detection = builder.scte20Detection;
        this.source608ChannelNumber = builder.source608ChannelNumber;
        this.source608TrackNumber = builder.source608TrackNumber;
    }

    public final EmbeddedConvert608To708 convert608To708() {
        return EmbeddedConvert608To708.fromValue(this.convert608To708);
    }

    public final String convert608To708AsString() {
        return this.convert608To708;
    }

    public final EmbeddedScte20Detection scte20Detection() {
        return EmbeddedScte20Detection.fromValue(this.scte20Detection);
    }

    public final String scte20DetectionAsString() {
        return this.scte20Detection;
    }

    public final Integer source608ChannelNumber() {
        return this.source608ChannelNumber;
    }

    public final Integer source608TrackNumber() {
        return this.source608TrackNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.convert608To708AsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte20DetectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source608ChannelNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.source608TrackNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmbeddedSourceSettings)) {
            return false;
        }
        EmbeddedSourceSettings other = (EmbeddedSourceSettings)obj;
        return Objects.equals(this.convert608To708AsString(), other.convert608To708AsString()) && Objects.equals(this.scte20DetectionAsString(), other.scte20DetectionAsString()) && Objects.equals(this.source608ChannelNumber(), other.source608ChannelNumber()) && Objects.equals(this.source608TrackNumber(), other.source608TrackNumber());
    }

    public final String toString() {
        return ToString.builder((String)"EmbeddedSourceSettings").add("Convert608To708", (Object)this.convert608To708AsString()).add("Scte20Detection", (Object)this.scte20DetectionAsString()).add("Source608ChannelNumber", (Object)this.source608ChannelNumber()).add("Source608TrackNumber", (Object)this.source608TrackNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Convert608To708": {
                return Optional.ofNullable(clazz.cast(this.convert608To708AsString()));
            }
            case "Scte20Detection": {
                return Optional.ofNullable(clazz.cast(this.scte20DetectionAsString()));
            }
            case "Source608ChannelNumber": {
                return Optional.ofNullable(clazz.cast(this.source608ChannelNumber()));
            }
            case "Source608TrackNumber": {
                return Optional.ofNullable(clazz.cast(this.source608TrackNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmbeddedSourceSettings, T> g) {
        return obj -> g.apply((EmbeddedSourceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String convert608To708;
        private String scte20Detection;
        private Integer source608ChannelNumber;
        private Integer source608TrackNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(EmbeddedSourceSettings model) {
            this.convert608To708(model.convert608To708);
            this.scte20Detection(model.scte20Detection);
            this.source608ChannelNumber(model.source608ChannelNumber);
            this.source608TrackNumber(model.source608TrackNumber);
        }

        public final String getConvert608To708() {
            return this.convert608To708;
        }

        @Override
        public final Builder convert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
            return this;
        }

        @Override
        public final Builder convert608To708(EmbeddedConvert608To708 convert608To708) {
            this.convert608To708(convert608To708 == null ? null : convert608To708.toString());
            return this;
        }

        public final void setConvert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
        }

        public final String getScte20Detection() {
            return this.scte20Detection;
        }

        @Override
        public final Builder scte20Detection(String scte20Detection) {
            this.scte20Detection = scte20Detection;
            return this;
        }

        @Override
        public final Builder scte20Detection(EmbeddedScte20Detection scte20Detection) {
            this.scte20Detection(scte20Detection == null ? null : scte20Detection.toString());
            return this;
        }

        public final void setScte20Detection(String scte20Detection) {
            this.scte20Detection = scte20Detection;
        }

        public final Integer getSource608ChannelNumber() {
            return this.source608ChannelNumber;
        }

        @Override
        public final Builder source608ChannelNumber(Integer source608ChannelNumber) {
            this.source608ChannelNumber = source608ChannelNumber;
            return this;
        }

        public final void setSource608ChannelNumber(Integer source608ChannelNumber) {
            this.source608ChannelNumber = source608ChannelNumber;
        }

        public final Integer getSource608TrackNumber() {
            return this.source608TrackNumber;
        }

        @Override
        public final Builder source608TrackNumber(Integer source608TrackNumber) {
            this.source608TrackNumber = source608TrackNumber;
            return this;
        }

        public final void setSource608TrackNumber(Integer source608TrackNumber) {
            this.source608TrackNumber = source608TrackNumber;
        }

        public EmbeddedSourceSettings build() {
            return new EmbeddedSourceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmbeddedSourceSettings> {
        public Builder convert608To708(String var1);

        public Builder convert608To708(EmbeddedConvert608To708 var1);

        public Builder scte20Detection(String var1);

        public Builder scte20Detection(EmbeddedScte20Detection var1);

        public Builder source608ChannelNumber(Integer var1);

        public Builder source608TrackNumber(Integer var1);
    }
}

