/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InputClass {
    STANDARD("STANDARD"),
    SINGLE_PIPELINE("SINGLE_PIPELINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InputClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InputClass.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputClass> knownValues() {
        return Stream.of(InputClass.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

