/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Wav Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class WavSettings implements SdkPojo, Serializable, ToCopyableBuilder<WavSettings.Builder, WavSettings> {
    private static final SdkField<Double> BIT_DEPTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("BitDepth").getter(getter(WavSettings::bitDepth)).setter(setter(Builder::bitDepth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitDepth").build()).build();

    private static final SdkField<String> CODING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodingMode").getter(getter(WavSettings::codingModeAsString)).setter(setter(Builder::codingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()).build();

    private static final SdkField<Double> SAMPLE_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SampleRate").getter(getter(WavSettings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIT_DEPTH_FIELD,
            CODING_MODE_FIELD, SAMPLE_RATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double bitDepth;

    private final String codingMode;

    private final Double sampleRate;

    private WavSettings(BuilderImpl builder) {
        this.bitDepth = builder.bitDepth;
        this.codingMode = builder.codingMode;
        this.sampleRate = builder.sampleRate;
    }

    /**
     * Bits per sample.
     * 
     * @return Bits per sample.
     */
    public final Double bitDepth() {
        return bitDepth;
    }

    /**
     * The audio coding mode for the WAV audio. The mode determines the number of channels in the audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link WavCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return The audio coding mode for the WAV audio. The mode determines the number of channels in the audio.
     * @see WavCodingMode
     */
    public final WavCodingMode codingMode() {
        return WavCodingMode.fromValue(codingMode);
    }

    /**
     * The audio coding mode for the WAV audio. The mode determines the number of channels in the audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link WavCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return The audio coding mode for the WAV audio. The mode determines the number of channels in the audio.
     * @see WavCodingMode
     */
    public final String codingModeAsString() {
        return codingMode;
    }

    /**
     * Sample rate in Hz.
     * 
     * @return Sample rate in Hz.
     */
    public final Double sampleRate() {
        return sampleRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WavSettings)) {
            return false;
        }
        WavSettings other = (WavSettings) obj;
        return Objects.equals(bitDepth(), other.bitDepth()) && Objects.equals(codingModeAsString(), other.codingModeAsString())
                && Objects.equals(sampleRate(), other.sampleRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WavSettings").add("BitDepth", bitDepth()).add("CodingMode", codingModeAsString())
                .add("SampleRate", sampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BitDepth":
            return Optional.ofNullable(clazz.cast(bitDepth()));
        case "CodingMode":
            return Optional.ofNullable(clazz.cast(codingModeAsString()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WavSettings, T> g) {
        return obj -> g.apply((WavSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WavSettings> {
        /**
         * Bits per sample.
         * 
         * @param bitDepth
         *        Bits per sample.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitDepth(Double bitDepth);

        /**
         * The audio coding mode for the WAV audio. The mode determines the number of channels in the audio.
         * 
         * @param codingMode
         *        The audio coding mode for the WAV audio. The mode determines the number of channels in the audio.
         * @see WavCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WavCodingMode
         */
        Builder codingMode(String codingMode);

        /**
         * The audio coding mode for the WAV audio. The mode determines the number of channels in the audio.
         * 
         * @param codingMode
         *        The audio coding mode for the WAV audio. The mode determines the number of channels in the audio.
         * @see WavCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WavCodingMode
         */
        Builder codingMode(WavCodingMode codingMode);

        /**
         * Sample rate in Hz.
         * 
         * @param sampleRate
         *        Sample rate in Hz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Double sampleRate);
    }

    static final class BuilderImpl implements Builder {
        private Double bitDepth;

        private String codingMode;

        private Double sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(WavSettings model) {
            bitDepth(model.bitDepth);
            codingMode(model.codingMode);
            sampleRate(model.sampleRate);
        }

        public final Double getBitDepth() {
            return bitDepth;
        }

        @Override
        public final Builder bitDepth(Double bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final void setBitDepth(Double bitDepth) {
            this.bitDepth = bitDepth;
        }

        public final String getCodingMode() {
            return codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(WavCodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final Double getSampleRate() {
            return sampleRate;
        }

        @Override
        public final Builder sampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public WavSettings build() {
            return new WavSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
