/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Video settings for this stream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoDescription.Builder, VideoDescription> {
    private static final SdkField<VideoCodecSettings> CODEC_SETTINGS_FIELD = SdkField
            .<VideoCodecSettings> builder(MarshallingType.SDK_POJO).memberName("CodecSettings")
            .getter(getter(VideoDescription::codecSettings)).setter(setter(Builder::codecSettings))
            .constructor(VideoCodecSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSettings").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(VideoDescription::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(VideoDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RESPOND_TO_AFD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RespondToAfd").getter(getter(VideoDescription::respondToAfdAsString))
            .setter(setter(Builder::respondToAfd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("respondToAfd").build()).build();

    private static final SdkField<String> SCALING_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalingBehavior").getter(getter(VideoDescription::scalingBehaviorAsString))
            .setter(setter(Builder::scalingBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingBehavior").build()).build();

    private static final SdkField<Integer> SHARPNESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Sharpness").getter(getter(VideoDescription::sharpness)).setter(setter(Builder::sharpness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharpness").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Width")
            .getter(getter(VideoDescription::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_SETTINGS_FIELD,
            HEIGHT_FIELD, NAME_FIELD, RESPOND_TO_AFD_FIELD, SCALING_BEHAVIOR_FIELD, SHARPNESS_FIELD, WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final VideoCodecSettings codecSettings;

    private final Integer height;

    private final String name;

    private final String respondToAfd;

    private final String scalingBehavior;

    private final Integer sharpness;

    private final Integer width;

    private VideoDescription(BuilderImpl builder) {
        this.codecSettings = builder.codecSettings;
        this.height = builder.height;
        this.name = builder.name;
        this.respondToAfd = builder.respondToAfd;
        this.scalingBehavior = builder.scalingBehavior;
        this.sharpness = builder.sharpness;
        this.width = builder.width;
    }

    /**
     * Video codec settings.
     * 
     * @return Video codec settings.
     */
    public final VideoCodecSettings codecSettings() {
        return codecSettings;
    }

    /**
     * Output video height, in pixels. Must be an even number. For most codecs, you can leave this field and width blank
     * in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not
     * recommended. For the Frame Capture codec, height and width are required.
     * 
     * @return Output video height, in pixels. Must be an even number. For most codecs, you can leave this field and
     *         width blank in order to use the height and width (resolution) from the source. Note, however, that
     *         leaving blank is not recommended. For the Frame Capture codec, height and width are required.
     */
    public final Integer height() {
        return height;
    }

    /**
     * The name of this VideoDescription. Outputs will use this name to uniquely identify this Description. Description
     * names should be unique within this Live Event.
     * 
     * @return The name of this VideoDescription. Outputs will use this name to uniquely identify this Description.
     *         Description names should be unique within this Live Event.
     */
    public final String name() {
        return name;
    }

    /**
     * Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not know what
     * AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH. RESPOND: MediaLive
     * clips the input video using a formula that uses the AFD values (configured in afdSignaling ), the input display
     * aspect ratio, and the output display aspect ratio. MediaLive also includes the AFD values in the output, unless
     * the codec for this encode is FRAME_CAPTURE. PASSTHROUGH: MediaLive ignores the AFD values and does not clip the
     * video. But MediaLive does include the values in the output. NONE: MediaLive does not clip the input video and
     * does not include the AFD values in the output
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #respondToAfd} will
     * return {@link VideoDescriptionRespondToAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #respondToAfdAsString}.
     * </p>
     * 
     * @return Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not
     *         know what AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH.
     *         RESPOND: MediaLive clips the input video using a formula that uses the AFD values (configured in
     *         afdSignaling ), the input display aspect ratio, and the output display aspect ratio. MediaLive also
     *         includes the AFD values in the output, unless the codec for this encode is FRAME_CAPTURE. PASSTHROUGH:
     *         MediaLive ignores the AFD values and does not clip the video. But MediaLive does include the values in
     *         the output. NONE: MediaLive does not clip the input video and does not include the AFD values in the
     *         output
     * @see VideoDescriptionRespondToAfd
     */
    public final VideoDescriptionRespondToAfd respondToAfd() {
        return VideoDescriptionRespondToAfd.fromValue(respondToAfd);
    }

    /**
     * Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not know what
     * AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH. RESPOND: MediaLive
     * clips the input video using a formula that uses the AFD values (configured in afdSignaling ), the input display
     * aspect ratio, and the output display aspect ratio. MediaLive also includes the AFD values in the output, unless
     * the codec for this encode is FRAME_CAPTURE. PASSTHROUGH: MediaLive ignores the AFD values and does not clip the
     * video. But MediaLive does include the values in the output. NONE: MediaLive does not clip the input video and
     * does not include the AFD values in the output
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #respondToAfd} will
     * return {@link VideoDescriptionRespondToAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #respondToAfdAsString}.
     * </p>
     * 
     * @return Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not
     *         know what AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH.
     *         RESPOND: MediaLive clips the input video using a formula that uses the AFD values (configured in
     *         afdSignaling ), the input display aspect ratio, and the output display aspect ratio. MediaLive also
     *         includes the AFD values in the output, unless the codec for this encode is FRAME_CAPTURE. PASSTHROUGH:
     *         MediaLive ignores the AFD values and does not clip the video. But MediaLive does include the values in
     *         the output. NONE: MediaLive does not clip the input video and does not include the AFD values in the
     *         output
     * @see VideoDescriptionRespondToAfd
     */
    public final String respondToAfdAsString() {
        return respondToAfd;
    }

    /**
     * STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution (height
     * and width). This option will override any position value. DEFAULT may insert black boxes (pillar boxes or letter
     * boxes) around the video to provide the specified output resolution.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingBehavior}
     * will return {@link VideoDescriptionScalingBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #scalingBehaviorAsString}.
     * </p>
     * 
     * @return STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution
     *         (height and width). This option will override any position value. DEFAULT may insert black boxes (pillar
     *         boxes or letter boxes) around the video to provide the specified output resolution.
     * @see VideoDescriptionScalingBehavior
     */
    public final VideoDescriptionScalingBehavior scalingBehavior() {
        return VideoDescriptionScalingBehavior.fromValue(scalingBehavior);
    }

    /**
     * STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution (height
     * and width). This option will override any position value. DEFAULT may insert black boxes (pillar boxes or letter
     * boxes) around the video to provide the specified output resolution.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingBehavior}
     * will return {@link VideoDescriptionScalingBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #scalingBehaviorAsString}.
     * </p>
     * 
     * @return STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution
     *         (height and width). This option will override any position value. DEFAULT may insert black boxes (pillar
     *         boxes or letter boxes) around the video to provide the specified output resolution.
     * @see VideoDescriptionScalingBehavior
     */
    public final String scalingBehaviorAsString() {
        return scalingBehavior;
    }

    /**
     * Changes the strength of the anti-alias filter used for scaling. 0 is the softest setting, 100 is the sharpest. A
     * setting of 50 is recommended for most content.
     * 
     * @return Changes the strength of the anti-alias filter used for scaling. 0 is the softest setting, 100 is the
     *         sharpest. A setting of 50 is recommended for most content.
     */
    public final Integer sharpness() {
        return sharpness;
    }

    /**
     * Output video width, in pixels. Must be an even number. For most codecs, you can leave this field and height blank
     * in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not
     * recommended. For the Frame Capture codec, height and width are required.
     * 
     * @return Output video width, in pixels. Must be an even number. For most codecs, you can leave this field and
     *         height blank in order to use the height and width (resolution) from the source. Note, however, that
     *         leaving blank is not recommended. For the Frame Capture codec, height and width are required.
     */
    public final Integer width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(respondToAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scalingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sharpness());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoDescription)) {
            return false;
        }
        VideoDescription other = (VideoDescription) obj;
        return Objects.equals(codecSettings(), other.codecSettings()) && Objects.equals(height(), other.height())
                && Objects.equals(name(), other.name()) && Objects.equals(respondToAfdAsString(), other.respondToAfdAsString())
                && Objects.equals(scalingBehaviorAsString(), other.scalingBehaviorAsString())
                && Objects.equals(sharpness(), other.sharpness()) && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoDescription").add("CodecSettings", codecSettings()).add("Height", height())
                .add("Name", name()).add("RespondToAfd", respondToAfdAsString())
                .add("ScalingBehavior", scalingBehaviorAsString()).add("Sharpness", sharpness()).add("Width", width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodecSettings":
            return Optional.ofNullable(clazz.cast(codecSettings()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RespondToAfd":
            return Optional.ofNullable(clazz.cast(respondToAfdAsString()));
        case "ScalingBehavior":
            return Optional.ofNullable(clazz.cast(scalingBehaviorAsString()));
        case "Sharpness":
            return Optional.ofNullable(clazz.cast(sharpness()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoDescription, T> g) {
        return obj -> g.apply((VideoDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoDescription> {
        /**
         * Video codec settings.
         * 
         * @param codecSettings
         *        Video codec settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codecSettings(VideoCodecSettings codecSettings);

        /**
         * Video codec settings. This is a convenience that creates an instance of the
         * {@link VideoCodecSettings.Builder} avoiding the need to create one manually via
         * {@link VideoCodecSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoCodecSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #codecSettings(VideoCodecSettings)}.
         * 
         * @param codecSettings
         *        a consumer that will call methods on {@link VideoCodecSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codecSettings(VideoCodecSettings)
         */
        default Builder codecSettings(Consumer<VideoCodecSettings.Builder> codecSettings) {
            return codecSettings(VideoCodecSettings.builder().applyMutation(codecSettings).build());
        }

        /**
         * Output video height, in pixels. Must be an even number. For most codecs, you can leave this field and width
         * blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is
         * not recommended. For the Frame Capture codec, height and width are required.
         * 
         * @param height
         *        Output video height, in pixels. Must be an even number. For most codecs, you can leave this field and
         *        width blank in order to use the height and width (resolution) from the source. Note, however, that
         *        leaving blank is not recommended. For the Frame Capture codec, height and width are required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * The name of this VideoDescription. Outputs will use this name to uniquely identify this Description.
         * Description names should be unique within this Live Event.
         * 
         * @param name
         *        The name of this VideoDescription. Outputs will use this name to uniquely identify this Description.
         *        Description names should be unique within this Live Event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not know
         * what AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH. RESPOND:
         * MediaLive clips the input video using a formula that uses the AFD values (configured in afdSignaling ), the
         * input display aspect ratio, and the output display aspect ratio. MediaLive also includes the AFD values in
         * the output, unless the codec for this encode is FRAME_CAPTURE. PASSTHROUGH: MediaLive ignores the AFD values
         * and does not clip the video. But MediaLive does include the values in the output. NONE: MediaLive does not
         * clip the input video and does not include the AFD values in the output
         * 
         * @param respondToAfd
         *        Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not
         *        know what AFD signaling is, or if your downstream system has not given you guidance, choose
         *        PASSTHROUGH. RESPOND: MediaLive clips the input video using a formula that uses the AFD values
         *        (configured in afdSignaling ), the input display aspect ratio, and the output display aspect ratio.
         *        MediaLive also includes the AFD values in the output, unless the codec for this encode is
         *        FRAME_CAPTURE. PASSTHROUGH: MediaLive ignores the AFD values and does not clip the video. But
         *        MediaLive does include the values in the output. NONE: MediaLive does not clip the input video and
         *        does not include the AFD values in the output
         * @see VideoDescriptionRespondToAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoDescriptionRespondToAfd
         */
        Builder respondToAfd(String respondToAfd);

        /**
         * Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not know
         * what AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH. RESPOND:
         * MediaLive clips the input video using a formula that uses the AFD values (configured in afdSignaling ), the
         * input display aspect ratio, and the output display aspect ratio. MediaLive also includes the AFD values in
         * the output, unless the codec for this encode is FRAME_CAPTURE. PASSTHROUGH: MediaLive ignores the AFD values
         * and does not clip the video. But MediaLive does include the values in the output. NONE: MediaLive does not
         * clip the input video and does not include the AFD values in the output
         * 
         * @param respondToAfd
         *        Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not
         *        know what AFD signaling is, or if your downstream system has not given you guidance, choose
         *        PASSTHROUGH. RESPOND: MediaLive clips the input video using a formula that uses the AFD values
         *        (configured in afdSignaling ), the input display aspect ratio, and the output display aspect ratio.
         *        MediaLive also includes the AFD values in the output, unless the codec for this encode is
         *        FRAME_CAPTURE. PASSTHROUGH: MediaLive ignores the AFD values and does not clip the video. But
         *        MediaLive does include the values in the output. NONE: MediaLive does not clip the input video and
         *        does not include the AFD values in the output
         * @see VideoDescriptionRespondToAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoDescriptionRespondToAfd
         */
        Builder respondToAfd(VideoDescriptionRespondToAfd respondToAfd);

        /**
         * STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution
         * (height and width). This option will override any position value. DEFAULT may insert black boxes (pillar
         * boxes or letter boxes) around the video to provide the specified output resolution.
         * 
         * @param scalingBehavior
         *        STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output
         *        resolution (height and width). This option will override any position value. DEFAULT may insert black
         *        boxes (pillar boxes or letter boxes) around the video to provide the specified output resolution.
         * @see VideoDescriptionScalingBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoDescriptionScalingBehavior
         */
        Builder scalingBehavior(String scalingBehavior);

        /**
         * STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution
         * (height and width). This option will override any position value. DEFAULT may insert black boxes (pillar
         * boxes or letter boxes) around the video to provide the specified output resolution.
         * 
         * @param scalingBehavior
         *        STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output
         *        resolution (height and width). This option will override any position value. DEFAULT may insert black
         *        boxes (pillar boxes or letter boxes) around the video to provide the specified output resolution.
         * @see VideoDescriptionScalingBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoDescriptionScalingBehavior
         */
        Builder scalingBehavior(VideoDescriptionScalingBehavior scalingBehavior);

        /**
         * Changes the strength of the anti-alias filter used for scaling. 0 is the softest setting, 100 is the
         * sharpest. A setting of 50 is recommended for most content.
         * 
         * @param sharpness
         *        Changes the strength of the anti-alias filter used for scaling. 0 is the softest setting, 100 is the
         *        sharpest. A setting of 50 is recommended for most content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharpness(Integer sharpness);

        /**
         * Output video width, in pixels. Must be an even number. For most codecs, you can leave this field and height
         * blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is
         * not recommended. For the Frame Capture codec, height and width are required.
         * 
         * @param width
         *        Output video width, in pixels. Must be an even number. For most codecs, you can leave this field and
         *        height blank in order to use the height and width (resolution) from the source. Note, however, that
         *        leaving blank is not recommended. For the Frame Capture codec, height and width are required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);
    }

    static final class BuilderImpl implements Builder {
        private VideoCodecSettings codecSettings;

        private Integer height;

        private String name;

        private String respondToAfd;

        private String scalingBehavior;

        private Integer sharpness;

        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoDescription model) {
            codecSettings(model.codecSettings);
            height(model.height);
            name(model.name);
            respondToAfd(model.respondToAfd);
            scalingBehavior(model.scalingBehavior);
            sharpness(model.sharpness);
            width(model.width);
        }

        public final VideoCodecSettings.Builder getCodecSettings() {
            return codecSettings != null ? codecSettings.toBuilder() : null;
        }

        @Override
        public final Builder codecSettings(VideoCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final void setCodecSettings(VideoCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        public final Integer getHeight() {
            return height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRespondToAfd() {
            return respondToAfd;
        }

        @Override
        public final Builder respondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
            return this;
        }

        @Override
        public final Builder respondToAfd(VideoDescriptionRespondToAfd respondToAfd) {
            this.respondToAfd(respondToAfd == null ? null : respondToAfd.toString());
            return this;
        }

        public final void setRespondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
        }

        public final String getScalingBehavior() {
            return scalingBehavior;
        }

        @Override
        public final Builder scalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
            return this;
        }

        @Override
        public final Builder scalingBehavior(VideoDescriptionScalingBehavior scalingBehavior) {
            this.scalingBehavior(scalingBehavior == null ? null : scalingBehavior.toString());
            return this;
        }

        public final void setScalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
        }

        public final Integer getSharpness() {
            return sharpness;
        }

        @Override
        public final Builder sharpness(Integer sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final void setSharpness(Integer sharpness) {
            this.sharpness = sharpness;
        }

        public final Integer getWidth() {
            return width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public VideoDescription build() {
            return new VideoDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
