/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Video Codec Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoCodecSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoCodecSettings.Builder, VideoCodecSettings> {
    private static final SdkField<FrameCaptureSettings> FRAME_CAPTURE_SETTINGS_FIELD = SdkField
            .<FrameCaptureSettings> builder(MarshallingType.SDK_POJO).memberName("FrameCaptureSettings")
            .getter(getter(VideoCodecSettings::frameCaptureSettings)).setter(setter(Builder::frameCaptureSettings))
            .constructor(FrameCaptureSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureSettings").build())
            .build();

    private static final SdkField<H264Settings> H264_SETTINGS_FIELD = SdkField.<H264Settings> builder(MarshallingType.SDK_POJO)
            .memberName("H264Settings").getter(getter(VideoCodecSettings::h264Settings)).setter(setter(Builder::h264Settings))
            .constructor(H264Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h264Settings").build()).build();

    private static final SdkField<H265Settings> H265_SETTINGS_FIELD = SdkField.<H265Settings> builder(MarshallingType.SDK_POJO)
            .memberName("H265Settings").getter(getter(VideoCodecSettings::h265Settings)).setter(setter(Builder::h265Settings))
            .constructor(H265Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h265Settings").build()).build();

    private static final SdkField<Mpeg2Settings> MPEG2_SETTINGS_FIELD = SdkField
            .<Mpeg2Settings> builder(MarshallingType.SDK_POJO).memberName("Mpeg2Settings")
            .getter(getter(VideoCodecSettings::mpeg2Settings)).setter(setter(Builder::mpeg2Settings))
            .constructor(Mpeg2Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpeg2Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_CAPTURE_SETTINGS_FIELD,
            H264_SETTINGS_FIELD, H265_SETTINGS_FIELD, MPEG2_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final FrameCaptureSettings frameCaptureSettings;

    private final H264Settings h264Settings;

    private final H265Settings h265Settings;

    private final Mpeg2Settings mpeg2Settings;

    private VideoCodecSettings(BuilderImpl builder) {
        this.frameCaptureSettings = builder.frameCaptureSettings;
        this.h264Settings = builder.h264Settings;
        this.h265Settings = builder.h265Settings;
        this.mpeg2Settings = builder.mpeg2Settings;
    }

    /**
     * Returns the value of the FrameCaptureSettings property for this object.
     * 
     * @return The value of the FrameCaptureSettings property for this object.
     */
    public final FrameCaptureSettings frameCaptureSettings() {
        return frameCaptureSettings;
    }

    /**
     * Returns the value of the H264Settings property for this object.
     * 
     * @return The value of the H264Settings property for this object.
     */
    public final H264Settings h264Settings() {
        return h264Settings;
    }

    /**
     * Returns the value of the H265Settings property for this object.
     * 
     * @return The value of the H265Settings property for this object.
     */
    public final H265Settings h265Settings() {
        return h265Settings;
    }

    /**
     * Returns the value of the Mpeg2Settings property for this object.
     * 
     * @return The value of the Mpeg2Settings property for this object.
     */
    public final Mpeg2Settings mpeg2Settings() {
        return mpeg2Settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frameCaptureSettings());
        hashCode = 31 * hashCode + Objects.hashCode(h264Settings());
        hashCode = 31 * hashCode + Objects.hashCode(h265Settings());
        hashCode = 31 * hashCode + Objects.hashCode(mpeg2Settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoCodecSettings)) {
            return false;
        }
        VideoCodecSettings other = (VideoCodecSettings) obj;
        return Objects.equals(frameCaptureSettings(), other.frameCaptureSettings())
                && Objects.equals(h264Settings(), other.h264Settings()) && Objects.equals(h265Settings(), other.h265Settings())
                && Objects.equals(mpeg2Settings(), other.mpeg2Settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoCodecSettings").add("FrameCaptureSettings", frameCaptureSettings())
                .add("H264Settings", h264Settings()).add("H265Settings", h265Settings()).add("Mpeg2Settings", mpeg2Settings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FrameCaptureSettings":
            return Optional.ofNullable(clazz.cast(frameCaptureSettings()));
        case "H264Settings":
            return Optional.ofNullable(clazz.cast(h264Settings()));
        case "H265Settings":
            return Optional.ofNullable(clazz.cast(h265Settings()));
        case "Mpeg2Settings":
            return Optional.ofNullable(clazz.cast(mpeg2Settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoCodecSettings, T> g) {
        return obj -> g.apply((VideoCodecSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoCodecSettings> {
        /**
         * Sets the value of the FrameCaptureSettings property for this object.
         *
         * @param frameCaptureSettings
         *        The new value for the FrameCaptureSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameCaptureSettings(FrameCaptureSettings frameCaptureSettings);

        /**
         * Sets the value of the FrameCaptureSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link FrameCaptureSettings.Builder} avoiding the need
         * to create one manually via {@link FrameCaptureSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FrameCaptureSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #frameCaptureSettings(FrameCaptureSettings)}.
         * 
         * @param frameCaptureSettings
         *        a consumer that will call methods on {@link FrameCaptureSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameCaptureSettings(FrameCaptureSettings)
         */
        default Builder frameCaptureSettings(Consumer<FrameCaptureSettings.Builder> frameCaptureSettings) {
            return frameCaptureSettings(FrameCaptureSettings.builder().applyMutation(frameCaptureSettings).build());
        }

        /**
         * Sets the value of the H264Settings property for this object.
         *
         * @param h264Settings
         *        The new value for the H264Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder h264Settings(H264Settings h264Settings);

        /**
         * Sets the value of the H264Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link H264Settings.Builder} avoiding the need to
         * create one manually via {@link H264Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link H264Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #h264Settings(H264Settings)}.
         * 
         * @param h264Settings
         *        a consumer that will call methods on {@link H264Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #h264Settings(H264Settings)
         */
        default Builder h264Settings(Consumer<H264Settings.Builder> h264Settings) {
            return h264Settings(H264Settings.builder().applyMutation(h264Settings).build());
        }

        /**
         * Sets the value of the H265Settings property for this object.
         *
         * @param h265Settings
         *        The new value for the H265Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder h265Settings(H265Settings h265Settings);

        /**
         * Sets the value of the H265Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link H265Settings.Builder} avoiding the need to
         * create one manually via {@link H265Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link H265Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #h265Settings(H265Settings)}.
         * 
         * @param h265Settings
         *        a consumer that will call methods on {@link H265Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #h265Settings(H265Settings)
         */
        default Builder h265Settings(Consumer<H265Settings.Builder> h265Settings) {
            return h265Settings(H265Settings.builder().applyMutation(h265Settings).build());
        }

        /**
         * Sets the value of the Mpeg2Settings property for this object.
         *
         * @param mpeg2Settings
         *        The new value for the Mpeg2Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mpeg2Settings(Mpeg2Settings mpeg2Settings);

        /**
         * Sets the value of the Mpeg2Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Mpeg2Settings.Builder} avoiding the need to
         * create one manually via {@link Mpeg2Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Mpeg2Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #mpeg2Settings(Mpeg2Settings)}.
         * 
         * @param mpeg2Settings
         *        a consumer that will call methods on {@link Mpeg2Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mpeg2Settings(Mpeg2Settings)
         */
        default Builder mpeg2Settings(Consumer<Mpeg2Settings.Builder> mpeg2Settings) {
            return mpeg2Settings(Mpeg2Settings.builder().applyMutation(mpeg2Settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FrameCaptureSettings frameCaptureSettings;

        private H264Settings h264Settings;

        private H265Settings h265Settings;

        private Mpeg2Settings mpeg2Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoCodecSettings model) {
            frameCaptureSettings(model.frameCaptureSettings);
            h264Settings(model.h264Settings);
            h265Settings(model.h265Settings);
            mpeg2Settings(model.mpeg2Settings);
        }

        public final FrameCaptureSettings.Builder getFrameCaptureSettings() {
            return frameCaptureSettings != null ? frameCaptureSettings.toBuilder() : null;
        }

        @Override
        public final Builder frameCaptureSettings(FrameCaptureSettings frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings;
            return this;
        }

        public final void setFrameCaptureSettings(FrameCaptureSettings.BuilderImpl frameCaptureSettings) {
            this.frameCaptureSettings = frameCaptureSettings != null ? frameCaptureSettings.build() : null;
        }

        public final H264Settings.Builder getH264Settings() {
            return h264Settings != null ? h264Settings.toBuilder() : null;
        }

        @Override
        public final Builder h264Settings(H264Settings h264Settings) {
            this.h264Settings = h264Settings;
            return this;
        }

        public final void setH264Settings(H264Settings.BuilderImpl h264Settings) {
            this.h264Settings = h264Settings != null ? h264Settings.build() : null;
        }

        public final H265Settings.Builder getH265Settings() {
            return h265Settings != null ? h265Settings.toBuilder() : null;
        }

        @Override
        public final Builder h265Settings(H265Settings h265Settings) {
            this.h265Settings = h265Settings;
            return this;
        }

        public final void setH265Settings(H265Settings.BuilderImpl h265Settings) {
            this.h265Settings = h265Settings != null ? h265Settings.build() : null;
        }

        public final Mpeg2Settings.Builder getMpeg2Settings() {
            return mpeg2Settings != null ? mpeg2Settings.toBuilder() : null;
        }

        @Override
        public final Builder mpeg2Settings(Mpeg2Settings mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings;
            return this;
        }

        public final void setMpeg2Settings(Mpeg2Settings.BuilderImpl mpeg2Settings) {
            this.mpeg2Settings = mpeg2Settings != null ? mpeg2Settings.build() : null;
        }

        @Override
        public VideoCodecSettings build() {
            return new VideoCodecSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
