/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for VideoBlackFailoverSettings
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoBlackFailoverSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoBlackFailoverSettings.Builder, VideoBlackFailoverSettings> {
    private static final SdkField<Double> BLACK_DETECT_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("BlackDetectThreshold").getter(getter(VideoBlackFailoverSettings::blackDetectThreshold))
            .setter(setter(Builder::blackDetectThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackDetectThreshold").build())
            .build();

    private static final SdkField<Integer> VIDEO_BLACK_THRESHOLD_MSEC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VideoBlackThresholdMsec").getter(getter(VideoBlackFailoverSettings::videoBlackThresholdMsec))
            .setter(setter(Builder::videoBlackThresholdMsec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoBlackThresholdMsec").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACK_DETECT_THRESHOLD_FIELD,
            VIDEO_BLACK_THRESHOLD_MSEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double blackDetectThreshold;

    private final Integer videoBlackThresholdMsec;

    private VideoBlackFailoverSettings(BuilderImpl builder) {
        this.blackDetectThreshold = builder.blackDetectThreshold;
        this.videoBlackThresholdMsec = builder.videoBlackThresholdMsec;
    }

    /**
     * A value used in calculating the threshold below which MediaLive considers a pixel to be 'black'. For the input to
     * be considered black, every pixel in a frame must be below this threshold. The threshold is calculated as a
     * percentage (expressed as a decimal) of white. Therefore .1 means 10% white (or 90% black). Note how the formula
     * works for any color depth. For example, if you set this field to 0.1 in 10-bit color depth: (1023*0.1=102.3),
     * which means a pixel value of 102 or less is 'black'. If you set this field to .1 in an 8-bit color depth:
     * (255*0.1=25.5), which means a pixel value of 25 or less is 'black'. The range is 0.0 to 1.0, with any number of
     * decimal places.
     * 
     * @return A value used in calculating the threshold below which MediaLive considers a pixel to be 'black'. For the
     *         input to be considered black, every pixel in a frame must be below this threshold. The threshold is
     *         calculated as a percentage (expressed as a decimal) of white. Therefore .1 means 10% white (or 90%
     *         black). Note how the formula works for any color depth. For example, if you set this field to 0.1 in
     *         10-bit color depth: (1023*0.1=102.3), which means a pixel value of 102 or less is 'black'. If you set
     *         this field to .1 in an 8-bit color depth: (255*0.1=25.5), which means a pixel value of 25 or less is
     *         'black'. The range is 0.0 to 1.0, with any number of decimal places.
     */
    public final Double blackDetectThreshold() {
        return blackDetectThreshold;
    }

    /**
     * The amount of time (in milliseconds) that the active input must be black before automatic input failover occurs.
     * 
     * @return The amount of time (in milliseconds) that the active input must be black before automatic input failover
     *         occurs.
     */
    public final Integer videoBlackThresholdMsec() {
        return videoBlackThresholdMsec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blackDetectThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(videoBlackThresholdMsec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoBlackFailoverSettings)) {
            return false;
        }
        VideoBlackFailoverSettings other = (VideoBlackFailoverSettings) obj;
        return Objects.equals(blackDetectThreshold(), other.blackDetectThreshold())
                && Objects.equals(videoBlackThresholdMsec(), other.videoBlackThresholdMsec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoBlackFailoverSettings").add("BlackDetectThreshold", blackDetectThreshold())
                .add("VideoBlackThresholdMsec", videoBlackThresholdMsec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlackDetectThreshold":
            return Optional.ofNullable(clazz.cast(blackDetectThreshold()));
        case "VideoBlackThresholdMsec":
            return Optional.ofNullable(clazz.cast(videoBlackThresholdMsec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoBlackFailoverSettings, T> g) {
        return obj -> g.apply((VideoBlackFailoverSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoBlackFailoverSettings> {
        /**
         * A value used in calculating the threshold below which MediaLive considers a pixel to be 'black'. For the
         * input to be considered black, every pixel in a frame must be below this threshold. The threshold is
         * calculated as a percentage (expressed as a decimal) of white. Therefore .1 means 10% white (or 90% black).
         * Note how the formula works for any color depth. For example, if you set this field to 0.1 in 10-bit color
         * depth: (1023*0.1=102.3), which means a pixel value of 102 or less is 'black'. If you set this field to .1 in
         * an 8-bit color depth: (255*0.1=25.5), which means a pixel value of 25 or less is 'black'. The range is 0.0 to
         * 1.0, with any number of decimal places.
         * 
         * @param blackDetectThreshold
         *        A value used in calculating the threshold below which MediaLive considers a pixel to be 'black'. For
         *        the input to be considered black, every pixel in a frame must be below this threshold. The threshold
         *        is calculated as a percentage (expressed as a decimal) of white. Therefore .1 means 10% white (or 90%
         *        black). Note how the formula works for any color depth. For example, if you set this field to 0.1 in
         *        10-bit color depth: (1023*0.1=102.3), which means a pixel value of 102 or less is 'black'. If you set
         *        this field to .1 in an 8-bit color depth: (255*0.1=25.5), which means a pixel value of 25 or less is
         *        'black'. The range is 0.0 to 1.0, with any number of decimal places.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blackDetectThreshold(Double blackDetectThreshold);

        /**
         * The amount of time (in milliseconds) that the active input must be black before automatic input failover
         * occurs.
         * 
         * @param videoBlackThresholdMsec
         *        The amount of time (in milliseconds) that the active input must be black before automatic input
         *        failover occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoBlackThresholdMsec(Integer videoBlackThresholdMsec);
    }

    static final class BuilderImpl implements Builder {
        private Double blackDetectThreshold;

        private Integer videoBlackThresholdMsec;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoBlackFailoverSettings model) {
            blackDetectThreshold(model.blackDetectThreshold);
            videoBlackThresholdMsec(model.videoBlackThresholdMsec);
        }

        public final Double getBlackDetectThreshold() {
            return blackDetectThreshold;
        }

        @Override
        public final Builder blackDetectThreshold(Double blackDetectThreshold) {
            this.blackDetectThreshold = blackDetectThreshold;
            return this;
        }

        public final void setBlackDetectThreshold(Double blackDetectThreshold) {
            this.blackDetectThreshold = blackDetectThreshold;
        }

        public final Integer getVideoBlackThresholdMsec() {
            return videoBlackThresholdMsec;
        }

        @Override
        public final Builder videoBlackThresholdMsec(Integer videoBlackThresholdMsec) {
            this.videoBlackThresholdMsec = videoBlackThresholdMsec;
            return this;
        }

        public final void setVideoBlackThresholdMsec(Integer videoBlackThresholdMsec) {
            this.videoBlackThresholdMsec = videoBlackThresholdMsec;
        }

        @Override
        public VideoBlackFailoverSettings build() {
            return new VideoBlackFailoverSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
