/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for UpdateMultiplexProgramResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMultiplexProgramResponse extends MediaLiveResponse implements
        ToCopyableBuilder<UpdateMultiplexProgramResponse.Builder, UpdateMultiplexProgramResponse> {
    private static final SdkField<MultiplexProgram> MULTIPLEX_PROGRAM_FIELD = SdkField
            .<MultiplexProgram> builder(MarshallingType.SDK_POJO).memberName("MultiplexProgram")
            .getter(getter(UpdateMultiplexProgramResponse::multiplexProgram)).setter(setter(Builder::multiplexProgram))
            .constructor(MultiplexProgram::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexProgram").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_PROGRAM_FIELD));

    private final MultiplexProgram multiplexProgram;

    private UpdateMultiplexProgramResponse(BuilderImpl builder) {
        super(builder);
        this.multiplexProgram = builder.multiplexProgram;
    }

    /**
     * The updated multiplex program.
     * 
     * @return The updated multiplex program.
     */
    public final MultiplexProgram multiplexProgram() {
        return multiplexProgram;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiplexProgram());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMultiplexProgramResponse)) {
            return false;
        }
        UpdateMultiplexProgramResponse other = (UpdateMultiplexProgramResponse) obj;
        return Objects.equals(multiplexProgram(), other.multiplexProgram());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMultiplexProgramResponse").add("MultiplexProgram", multiplexProgram()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiplexProgram":
            return Optional.ofNullable(clazz.cast(multiplexProgram()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMultiplexProgramResponse, T> g) {
        return obj -> g.apply((UpdateMultiplexProgramResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMultiplexProgramResponse> {
        /**
         * The updated multiplex program.
         * 
         * @param multiplexProgram
         *        The updated multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexProgram(MultiplexProgram multiplexProgram);

        /**
         * The updated multiplex program. This is a convenience that creates an instance of the
         * {@link MultiplexProgram.Builder} avoiding the need to create one manually via
         * {@link MultiplexProgram#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexProgram.Builder#build()} is called immediately and its
         * result is passed to {@link #multiplexProgram(MultiplexProgram)}.
         * 
         * @param multiplexProgram
         *        a consumer that will call methods on {@link MultiplexProgram.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexProgram(MultiplexProgram)
         */
        default Builder multiplexProgram(Consumer<MultiplexProgram.Builder> multiplexProgram) {
            return multiplexProgram(MultiplexProgram.builder().applyMutation(multiplexProgram).build());
        }
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private MultiplexProgram multiplexProgram;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMultiplexProgramResponse model) {
            super(model);
            multiplexProgram(model.multiplexProgram);
        }

        public final MultiplexProgram.Builder getMultiplexProgram() {
            return multiplexProgram != null ? multiplexProgram.toBuilder() : null;
        }

        @Override
        public final Builder multiplexProgram(MultiplexProgram multiplexProgram) {
            this.multiplexProgram = multiplexProgram;
            return this;
        }

        public final void setMultiplexProgram(MultiplexProgram.BuilderImpl multiplexProgram) {
            this.multiplexProgram = multiplexProgram != null ? multiplexProgram.build() : null;
        }

        @Override
        public UpdateMultiplexProgramResponse build() {
            return new UpdateMultiplexProgramResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
