/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for UnprocessableEntityException
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnprocessableEntityException extends MediaLiveException implements
        ToCopyableBuilder<UnprocessableEntityException.Builder, UnprocessableEntityException> {
    private static final SdkField<List<ValidationError>> VALIDATION_ERRORS_FIELD = SdkField
            .<List<ValidationError>> builder(MarshallingType.LIST)
            .memberName("ValidationErrors")
            .getter(getter(UnprocessableEntityException::validationErrors))
            .setter(setter(Builder::validationErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ValidationError> validationErrors;

    private UnprocessableEntityException(BuilderImpl builder) {
        super(builder);
        this.validationErrors = builder.validationErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns true if the ValidationErrors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasValidationErrors() {
        return validationErrors != null && !(validationErrors instanceof SdkAutoConstructList);
    }

    /**
     * A collection of validation error responses.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidationErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of validation error responses.
     */
    public List<ValidationError> validationErrors() {
        return validationErrors;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnprocessableEntityException, T> g) {
        return obj -> g.apply((UnprocessableEntityException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnprocessableEntityException>, MediaLiveException.Builder {
        /**
         * A collection of validation error responses.
         * 
         * @param validationErrors
         *        A collection of validation error responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(Collection<ValidationError> validationErrors);

        /**
         * A collection of validation error responses.
         * 
         * @param validationErrors
         *        A collection of validation error responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(ValidationError... validationErrors);

        /**
         * A collection of validation error responses. This is a convenience that creates an instance of the
         * {@link List<ValidationError>.Builder} avoiding the need to create one manually via {@link List
         * <ValidationError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationError>.Builder#build()} is called immediately and
         * its result is passed to {@link #validationErrors(List<ValidationError>)}.
         * 
         * @param validationErrors
         *        a consumer that will call methods on {@link List<ValidationError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationErrors(List<ValidationError>)
         */
        Builder validationErrors(Consumer<ValidationError.Builder>... validationErrors);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends MediaLiveException.BuilderImpl implements Builder {
        private List<ValidationError> validationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessableEntityException model) {
            super(model);
            validationErrors(model.validationErrors);
        }

        public final Collection<ValidationError.Builder> getValidationErrors() {
            if (validationErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return validationErrors != null ? validationErrors.stream().map(ValidationError::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ___listOfValidationErrorCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError... validationErrors) {
            validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(Consumer<ValidationError.Builder>... validationErrors) {
            validationErrors(Stream.of(validationErrors).map(c -> ValidationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setValidationErrors(Collection<ValidationError.BuilderImpl> validationErrors) {
            this.validationErrors = ___listOfValidationErrorCopier.copyFromBuilder(validationErrors);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public UnprocessableEntityException build() {
            return new UnprocessableEntityException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
