/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Scte35 Time Signal Apos
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scte35TimeSignalApos implements SdkPojo, Serializable,
        ToCopyableBuilder<Scte35TimeSignalApos.Builder, Scte35TimeSignalApos> {
    private static final SdkField<Integer> AD_AVAIL_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AdAvailOffset").getter(getter(Scte35TimeSignalApos::adAvailOffset))
            .setter(setter(Builder::adAvailOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adAvailOffset").build()).build();

    private static final SdkField<String> NO_REGIONAL_BLACKOUT_FLAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NoRegionalBlackoutFlag").getter(getter(Scte35TimeSignalApos::noRegionalBlackoutFlagAsString))
            .setter(setter(Builder::noRegionalBlackoutFlag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noRegionalBlackoutFlag").build())
            .build();

    private static final SdkField<String> WEB_DELIVERY_ALLOWED_FLAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebDeliveryAllowedFlag").getter(getter(Scte35TimeSignalApos::webDeliveryAllowedFlagAsString))
            .setter(setter(Builder::webDeliveryAllowedFlag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webDeliveryAllowedFlag").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_AVAIL_OFFSET_FIELD,
            NO_REGIONAL_BLACKOUT_FLAG_FIELD, WEB_DELIVERY_ALLOWED_FLAG_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer adAvailOffset;

    private final String noRegionalBlackoutFlag;

    private final String webDeliveryAllowedFlag;

    private Scte35TimeSignalApos(BuilderImpl builder) {
        this.adAvailOffset = builder.adAvailOffset;
        this.noRegionalBlackoutFlag = builder.noRegionalBlackoutFlag;
        this.webDeliveryAllowedFlag = builder.webDeliveryAllowedFlag;
    }

    /**
     * When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time. This only applies to
     * embedded SCTE 104/35 messages and does not apply to OOB messages.
     * 
     * @return When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time. This only applies
     *         to embedded SCTE 104/35 messages and does not apply to OOB messages.
     */
    public final Integer adAvailOffset() {
        return adAvailOffset;
    }

    /**
     * When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0 will no longer trigger blackouts or
     * Ad Avail slates
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #noRegionalBlackoutFlag} will return {@link Scte35AposNoRegionalBlackoutBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #noRegionalBlackoutFlagAsString}.
     * </p>
     * 
     * @return When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0 will no longer trigger
     *         blackouts or Ad Avail slates
     * @see Scte35AposNoRegionalBlackoutBehavior
     */
    public final Scte35AposNoRegionalBlackoutBehavior noRegionalBlackoutFlag() {
        return Scte35AposNoRegionalBlackoutBehavior.fromValue(noRegionalBlackoutFlag);
    }

    /**
     * When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0 will no longer trigger blackouts or
     * Ad Avail slates
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #noRegionalBlackoutFlag} will return {@link Scte35AposNoRegionalBlackoutBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #noRegionalBlackoutFlagAsString}.
     * </p>
     * 
     * @return When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0 will no longer trigger
     *         blackouts or Ad Avail slates
     * @see Scte35AposNoRegionalBlackoutBehavior
     */
    public final String noRegionalBlackoutFlagAsString() {
        return noRegionalBlackoutFlag;
    }

    /**
     * When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0 will no longer trigger blackouts or
     * Ad Avail slates
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webDeliveryAllowedFlag} will return {@link Scte35AposWebDeliveryAllowedBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #webDeliveryAllowedFlagAsString}.
     * </p>
     * 
     * @return When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0 will no longer trigger
     *         blackouts or Ad Avail slates
     * @see Scte35AposWebDeliveryAllowedBehavior
     */
    public final Scte35AposWebDeliveryAllowedBehavior webDeliveryAllowedFlag() {
        return Scte35AposWebDeliveryAllowedBehavior.fromValue(webDeliveryAllowedFlag);
    }

    /**
     * When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0 will no longer trigger blackouts or
     * Ad Avail slates
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webDeliveryAllowedFlag} will return {@link Scte35AposWebDeliveryAllowedBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #webDeliveryAllowedFlagAsString}.
     * </p>
     * 
     * @return When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0 will no longer trigger
     *         blackouts or Ad Avail slates
     * @see Scte35AposWebDeliveryAllowedBehavior
     */
    public final String webDeliveryAllowedFlagAsString() {
        return webDeliveryAllowedFlag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adAvailOffset());
        hashCode = 31 * hashCode + Objects.hashCode(noRegionalBlackoutFlagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(webDeliveryAllowedFlagAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte35TimeSignalApos)) {
            return false;
        }
        Scte35TimeSignalApos other = (Scte35TimeSignalApos) obj;
        return Objects.equals(adAvailOffset(), other.adAvailOffset())
                && Objects.equals(noRegionalBlackoutFlagAsString(), other.noRegionalBlackoutFlagAsString())
                && Objects.equals(webDeliveryAllowedFlagAsString(), other.webDeliveryAllowedFlagAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scte35TimeSignalApos").add("AdAvailOffset", adAvailOffset())
                .add("NoRegionalBlackoutFlag", noRegionalBlackoutFlagAsString())
                .add("WebDeliveryAllowedFlag", webDeliveryAllowedFlagAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdAvailOffset":
            return Optional.ofNullable(clazz.cast(adAvailOffset()));
        case "NoRegionalBlackoutFlag":
            return Optional.ofNullable(clazz.cast(noRegionalBlackoutFlagAsString()));
        case "WebDeliveryAllowedFlag":
            return Optional.ofNullable(clazz.cast(webDeliveryAllowedFlagAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scte35TimeSignalApos, T> g) {
        return obj -> g.apply((Scte35TimeSignalApos) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scte35TimeSignalApos> {
        /**
         * When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time. This only applies to
         * embedded SCTE 104/35 messages and does not apply to OOB messages.
         * 
         * @param adAvailOffset
         *        When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time. This only
         *        applies to embedded SCTE 104/35 messages and does not apply to OOB messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adAvailOffset(Integer adAvailOffset);

        /**
         * When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0 will no longer trigger blackouts
         * or Ad Avail slates
         * 
         * @param noRegionalBlackoutFlag
         *        When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0 will no longer trigger
         *        blackouts or Ad Avail slates
         * @see Scte35AposNoRegionalBlackoutBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35AposNoRegionalBlackoutBehavior
         */
        Builder noRegionalBlackoutFlag(String noRegionalBlackoutFlag);

        /**
         * When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0 will no longer trigger blackouts
         * or Ad Avail slates
         * 
         * @param noRegionalBlackoutFlag
         *        When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0 will no longer trigger
         *        blackouts or Ad Avail slates
         * @see Scte35AposNoRegionalBlackoutBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35AposNoRegionalBlackoutBehavior
         */
        Builder noRegionalBlackoutFlag(Scte35AposNoRegionalBlackoutBehavior noRegionalBlackoutFlag);

        /**
         * When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0 will no longer trigger blackouts
         * or Ad Avail slates
         * 
         * @param webDeliveryAllowedFlag
         *        When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0 will no longer trigger
         *        blackouts or Ad Avail slates
         * @see Scte35AposWebDeliveryAllowedBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35AposWebDeliveryAllowedBehavior
         */
        Builder webDeliveryAllowedFlag(String webDeliveryAllowedFlag);

        /**
         * When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0 will no longer trigger blackouts
         * or Ad Avail slates
         * 
         * @param webDeliveryAllowedFlag
         *        When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0 will no longer trigger
         *        blackouts or Ad Avail slates
         * @see Scte35AposWebDeliveryAllowedBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35AposWebDeliveryAllowedBehavior
         */
        Builder webDeliveryAllowedFlag(Scte35AposWebDeliveryAllowedBehavior webDeliveryAllowedFlag);
    }

    static final class BuilderImpl implements Builder {
        private Integer adAvailOffset;

        private String noRegionalBlackoutFlag;

        private String webDeliveryAllowedFlag;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte35TimeSignalApos model) {
            adAvailOffset(model.adAvailOffset);
            noRegionalBlackoutFlag(model.noRegionalBlackoutFlag);
            webDeliveryAllowedFlag(model.webDeliveryAllowedFlag);
        }

        public final Integer getAdAvailOffset() {
            return adAvailOffset;
        }

        @Override
        public final Builder adAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
            return this;
        }

        public final void setAdAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
        }

        public final String getNoRegionalBlackoutFlag() {
            return noRegionalBlackoutFlag;
        }

        @Override
        public final Builder noRegionalBlackoutFlag(String noRegionalBlackoutFlag) {
            this.noRegionalBlackoutFlag = noRegionalBlackoutFlag;
            return this;
        }

        @Override
        public final Builder noRegionalBlackoutFlag(Scte35AposNoRegionalBlackoutBehavior noRegionalBlackoutFlag) {
            this.noRegionalBlackoutFlag(noRegionalBlackoutFlag == null ? null : noRegionalBlackoutFlag.toString());
            return this;
        }

        public final void setNoRegionalBlackoutFlag(String noRegionalBlackoutFlag) {
            this.noRegionalBlackoutFlag = noRegionalBlackoutFlag;
        }

        public final String getWebDeliveryAllowedFlag() {
            return webDeliveryAllowedFlag;
        }

        @Override
        public final Builder webDeliveryAllowedFlag(String webDeliveryAllowedFlag) {
            this.webDeliveryAllowedFlag = webDeliveryAllowedFlag;
            return this;
        }

        @Override
        public final Builder webDeliveryAllowedFlag(Scte35AposWebDeliveryAllowedBehavior webDeliveryAllowedFlag) {
            this.webDeliveryAllowedFlag(webDeliveryAllowedFlag == null ? null : webDeliveryAllowedFlag.toString());
            return this;
        }

        public final void setWebDeliveryAllowedFlag(String webDeliveryAllowedFlag) {
            this.webDeliveryAllowedFlag = webDeliveryAllowedFlag;
        }

        @Override
        public Scte35TimeSignalApos build() {
            return new Scte35TimeSignalApos(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
