/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for a SCTE-35 return_to_network message.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scte35ReturnToNetworkScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<Scte35ReturnToNetworkScheduleActionSettings.Builder, Scte35ReturnToNetworkScheduleActionSettings> {
    private static final SdkField<Long> SPLICE_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SpliceEventId").getter(getter(Scte35ReturnToNetworkScheduleActionSettings::spliceEventId))
            .setter(setter(Builder::spliceEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spliceEventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPLICE_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long spliceEventId;

    private Scte35ReturnToNetworkScheduleActionSettings(BuilderImpl builder) {
        this.spliceEventId = builder.spliceEventId;
    }

    /**
     * The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
     * 
     * @return The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
     */
    public final Long spliceEventId() {
        return spliceEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spliceEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte35ReturnToNetworkScheduleActionSettings)) {
            return false;
        }
        Scte35ReturnToNetworkScheduleActionSettings other = (Scte35ReturnToNetworkScheduleActionSettings) obj;
        return Objects.equals(spliceEventId(), other.spliceEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scte35ReturnToNetworkScheduleActionSettings").add("SpliceEventId", spliceEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpliceEventId":
            return Optional.ofNullable(clazz.cast(spliceEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scte35ReturnToNetworkScheduleActionSettings, T> g) {
        return obj -> g.apply((Scte35ReturnToNetworkScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scte35ReturnToNetworkScheduleActionSettings> {
        /**
         * The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
         * 
         * @param spliceEventId
         *        The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spliceEventId(Long spliceEventId);
    }

    static final class BuilderImpl implements Builder {
        private Long spliceEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte35ReturnToNetworkScheduleActionSettings model) {
            spliceEventId(model.spliceEventId);
        }

        public final Long getSpliceEventId() {
            return spliceEventId;
        }

        @Override
        public final Builder spliceEventId(Long spliceEventId) {
            this.spliceEventId = spliceEventId;
            return this;
        }

        public final void setSpliceEventId(Long spliceEventId) {
            this.spliceEventId = spliceEventId;
        }

        @Override
        public Scte35ReturnToNetworkScheduleActionSettings build() {
            return new Scte35ReturnToNetworkScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
