/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Contains information on a single schedule action.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleAction implements SdkPojo, Serializable, ToCopyableBuilder<ScheduleAction.Builder, ScheduleAction> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionName").getter(getter(ScheduleAction::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<ScheduleActionSettings> SCHEDULE_ACTION_SETTINGS_FIELD = SdkField
            .<ScheduleActionSettings> builder(MarshallingType.SDK_POJO).memberName("ScheduleActionSettings")
            .getter(getter(ScheduleAction::scheduleActionSettings)).setter(setter(Builder::scheduleActionSettings))
            .constructor(ScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleActionSettings").build())
            .build();

    private static final SdkField<ScheduleActionStartSettings> SCHEDULE_ACTION_START_SETTINGS_FIELD = SdkField
            .<ScheduleActionStartSettings> builder(MarshallingType.SDK_POJO)
            .memberName("ScheduleActionStartSettings")
            .getter(getter(ScheduleAction::scheduleActionStartSettings))
            .setter(setter(Builder::scheduleActionStartSettings))
            .constructor(ScheduleActionStartSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleActionStartSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            SCHEDULE_ACTION_SETTINGS_FIELD, SCHEDULE_ACTION_START_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionName;

    private final ScheduleActionSettings scheduleActionSettings;

    private final ScheduleActionStartSettings scheduleActionStartSettings;

    private ScheduleAction(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.scheduleActionSettings = builder.scheduleActionSettings;
        this.scheduleActionStartSettings = builder.scheduleActionStartSettings;
    }

    /**
     * The name of the action, must be unique within the schedule. This name provides the main reference to an action
     * once it is added to the schedule. A name is unique if it is no longer in the schedule. The schedule is
     * automatically cleaned up to remove actions with a start time of more than 1 hour ago (approximately) so at that
     * point a name can be reused.
     * 
     * @return The name of the action, must be unique within the schedule. This name provides the main reference to an
     *         action once it is added to the schedule. A name is unique if it is no longer in the schedule. The
     *         schedule is automatically cleaned up to remove actions with a start time of more than 1 hour ago
     *         (approximately) so at that point a name can be reused.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * Settings for this schedule action.
     * 
     * @return Settings for this schedule action.
     */
    public final ScheduleActionSettings scheduleActionSettings() {
        return scheduleActionSettings;
    }

    /**
     * The time for the action to start in the channel.
     * 
     * @return The time for the action to start in the channel.
     */
    public final ScheduleActionStartSettings scheduleActionStartSettings() {
        return scheduleActionStartSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleActionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleActionStartSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleAction)) {
            return false;
        }
        ScheduleAction other = (ScheduleAction) obj;
        return Objects.equals(actionName(), other.actionName())
                && Objects.equals(scheduleActionSettings(), other.scheduleActionSettings())
                && Objects.equals(scheduleActionStartSettings(), other.scheduleActionStartSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleAction").add("ActionName", actionName())
                .add("ScheduleActionSettings", scheduleActionSettings())
                .add("ScheduleActionStartSettings", scheduleActionStartSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "ScheduleActionSettings":
            return Optional.ofNullable(clazz.cast(scheduleActionSettings()));
        case "ScheduleActionStartSettings":
            return Optional.ofNullable(clazz.cast(scheduleActionStartSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleAction, T> g) {
        return obj -> g.apply((ScheduleAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleAction> {
        /**
         * The name of the action, must be unique within the schedule. This name provides the main reference to an
         * action once it is added to the schedule. A name is unique if it is no longer in the schedule. The schedule is
         * automatically cleaned up to remove actions with a start time of more than 1 hour ago (approximately) so at
         * that point a name can be reused.
         * 
         * @param actionName
         *        The name of the action, must be unique within the schedule. This name provides the main reference to
         *        an action once it is added to the schedule. A name is unique if it is no longer in the schedule. The
         *        schedule is automatically cleaned up to remove actions with a start time of more than 1 hour ago
         *        (approximately) so at that point a name can be reused.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * Settings for this schedule action.
         * 
         * @param scheduleActionSettings
         *        Settings for this schedule action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleActionSettings(ScheduleActionSettings scheduleActionSettings);

        /**
         * Settings for this schedule action. This is a convenience that creates an instance of the
         * {@link ScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link ScheduleActionSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduleActionSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleActionSettings(ScheduleActionSettings)}.
         * 
         * @param scheduleActionSettings
         *        a consumer that will call methods on {@link ScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleActionSettings(ScheduleActionSettings)
         */
        default Builder scheduleActionSettings(Consumer<ScheduleActionSettings.Builder> scheduleActionSettings) {
            return scheduleActionSettings(ScheduleActionSettings.builder().applyMutation(scheduleActionSettings).build());
        }

        /**
         * The time for the action to start in the channel.
         * 
         * @param scheduleActionStartSettings
         *        The time for the action to start in the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleActionStartSettings(ScheduleActionStartSettings scheduleActionStartSettings);

        /**
         * The time for the action to start in the channel. This is a convenience that creates an instance of the
         * {@link ScheduleActionStartSettings.Builder} avoiding the need to create one manually via
         * {@link ScheduleActionStartSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduleActionStartSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduleActionStartSettings(ScheduleActionStartSettings)}.
         * 
         * @param scheduleActionStartSettings
         *        a consumer that will call methods on {@link ScheduleActionStartSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleActionStartSettings(ScheduleActionStartSettings)
         */
        default Builder scheduleActionStartSettings(Consumer<ScheduleActionStartSettings.Builder> scheduleActionStartSettings) {
            return scheduleActionStartSettings(ScheduleActionStartSettings.builder().applyMutation(scheduleActionStartSettings)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionName;

        private ScheduleActionSettings scheduleActionSettings;

        private ScheduleActionStartSettings scheduleActionStartSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleAction model) {
            actionName(model.actionName);
            scheduleActionSettings(model.scheduleActionSettings);
            scheduleActionStartSettings(model.scheduleActionStartSettings);
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final ScheduleActionSettings.Builder getScheduleActionSettings() {
            return scheduleActionSettings != null ? scheduleActionSettings.toBuilder() : null;
        }

        @Override
        public final Builder scheduleActionSettings(ScheduleActionSettings scheduleActionSettings) {
            this.scheduleActionSettings = scheduleActionSettings;
            return this;
        }

        public final void setScheduleActionSettings(ScheduleActionSettings.BuilderImpl scheduleActionSettings) {
            this.scheduleActionSettings = scheduleActionSettings != null ? scheduleActionSettings.build() : null;
        }

        public final ScheduleActionStartSettings.Builder getScheduleActionStartSettings() {
            return scheduleActionStartSettings != null ? scheduleActionStartSettings.toBuilder() : null;
        }

        @Override
        public final Builder scheduleActionStartSettings(ScheduleActionStartSettings scheduleActionStartSettings) {
            this.scheduleActionStartSettings = scheduleActionStartSettings;
            return this;
        }

        public final void setScheduleActionStartSettings(ScheduleActionStartSettings.BuilderImpl scheduleActionStartSettings) {
            this.scheduleActionStartSettings = scheduleActionStartSettings != null ? scheduleActionStartSettings.build() : null;
        }

        @Override
        public ScheduleAction build() {
            return new ScheduleAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
