/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for the action to set pause state of a channel.
 */
@Generated("software.amazon.awssdk:codegen")
public final class PauseStateScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<PauseStateScheduleActionSettings.Builder, PauseStateScheduleActionSettings> {
    private static final SdkField<List<PipelinePauseStateSettings>> PIPELINES_FIELD = SdkField
            .<List<PipelinePauseStateSettings>> builder(MarshallingType.LIST)
            .memberName("Pipelines")
            .getter(getter(PauseStateScheduleActionSettings::pipelines))
            .setter(setter(Builder::pipelines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelinePauseStateSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelinePauseStateSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PipelinePauseStateSettings> pipelines;

    private PauseStateScheduleActionSettings(BuilderImpl builder) {
        this.pipelines = builder.pipelines;
    }

    /**
     * Returns true if the Pipelines property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPipelines() {
        return pipelines != null && !(pipelines instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Pipelines property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelines()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Pipelines property for this object.
     */
    public final List<PipelinePauseStateSettings> pipelines() {
        return pipelines;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelines() ? pipelines() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PauseStateScheduleActionSettings)) {
            return false;
        }
        PauseStateScheduleActionSettings other = (PauseStateScheduleActionSettings) obj;
        return hasPipelines() == other.hasPipelines() && Objects.equals(pipelines(), other.pipelines());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PauseStateScheduleActionSettings").add("Pipelines", hasPipelines() ? pipelines() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pipelines":
            return Optional.ofNullable(clazz.cast(pipelines()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PauseStateScheduleActionSettings, T> g) {
        return obj -> g.apply((PauseStateScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PauseStateScheduleActionSettings> {
        /**
         * Sets the value of the Pipelines property for this object.
         *
         * @param pipelines
         *        The new value for the Pipelines property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelines(Collection<PipelinePauseStateSettings> pipelines);

        /**
         * Sets the value of the Pipelines property for this object.
         *
         * @param pipelines
         *        The new value for the Pipelines property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelines(PipelinePauseStateSettings... pipelines);

        /**
         * Sets the value of the Pipelines property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<PipelinePauseStateSettings>.Builder}
         * avoiding the need to create one manually via {@link List<PipelinePauseStateSettings>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PipelinePauseStateSettings>.Builder#build()} is called
         * immediately and its result is passed to {@link #pipelines(List<PipelinePauseStateSettings>)}.
         * 
         * @param pipelines
         *        a consumer that will call methods on {@link List<PipelinePauseStateSettings>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelines(List<PipelinePauseStateSettings>)
         */
        Builder pipelines(Consumer<PipelinePauseStateSettings.Builder>... pipelines);
    }

    static final class BuilderImpl implements Builder {
        private List<PipelinePauseStateSettings> pipelines = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PauseStateScheduleActionSettings model) {
            pipelines(model.pipelines);
        }

        public final Collection<PipelinePauseStateSettings.Builder> getPipelines() {
            if (pipelines instanceof SdkAutoConstructList) {
                return null;
            }
            return pipelines != null ? pipelines.stream().map(PipelinePauseStateSettings::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder pipelines(Collection<PipelinePauseStateSettings> pipelines) {
            this.pipelines = ___listOfPipelinePauseStateSettingsCopier.copy(pipelines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(PipelinePauseStateSettings... pipelines) {
            pipelines(Arrays.asList(pipelines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(Consumer<PipelinePauseStateSettings.Builder>... pipelines) {
            pipelines(Stream.of(pipelines).map(c -> PipelinePauseStateSettings.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPipelines(Collection<PipelinePauseStateSettings.BuilderImpl> pipelines) {
            this.pipelines = ___listOfPipelinePauseStateSettingsCopier.copyFromBuilder(pipelines);
        }

        @Override
        public PauseStateScheduleActionSettings build() {
            return new PauseStateScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
