/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for MultiplexProgramSummary
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexProgramSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexProgramSummary.Builder, MultiplexProgramSummary> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(MultiplexProgramSummary::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()).build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramName").getter(getter(MultiplexProgramSummary::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            PROGRAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelId;

    private final String programName;

    private MultiplexProgramSummary(BuilderImpl builder) {
        this.channelId = builder.channelId;
        this.programName = builder.programName;
    }

    /**
     * The MediaLive Channel associated with the program.
     * 
     * @return The MediaLive Channel associated with the program.
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * The name of the multiplex program.
     * 
     * @return The name of the multiplex program.
     */
    public final String programName() {
        return programName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexProgramSummary)) {
            return false;
        }
        MultiplexProgramSummary other = (MultiplexProgramSummary) obj;
        return Objects.equals(channelId(), other.channelId()) && Objects.equals(programName(), other.programName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiplexProgramSummary").add("ChannelId", channelId()).add("ProgramName", programName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexProgramSummary, T> g) {
        return obj -> g.apply((MultiplexProgramSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexProgramSummary> {
        /**
         * The MediaLive Channel associated with the program.
         * 
         * @param channelId
         *        The MediaLive Channel associated with the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * The name of the multiplex program.
         * 
         * @param programName
         *        The name of the multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);
    }

    static final class BuilderImpl implements Builder {
        private String channelId;

        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexProgramSummary model) {
            channelId(model.channelId);
            programName(model.programName);
        }

        public final String getChannelId() {
            return channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public final String getProgramName() {
            return programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public MultiplexProgramSummary build() {
            return new MultiplexProgramSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
