/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Multiplex output destination settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexOutputDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexOutputDestination.Builder, MultiplexOutputDestination> {
    private static final SdkField<MultiplexMediaConnectOutputDestinationSettings> MEDIA_CONNECT_SETTINGS_FIELD = SdkField
            .<MultiplexMediaConnectOutputDestinationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("MediaConnectSettings").getter(getter(MultiplexOutputDestination::mediaConnectSettings))
            .setter(setter(Builder::mediaConnectSettings)).constructor(MultiplexMediaConnectOutputDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_CONNECT_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final MultiplexMediaConnectOutputDestinationSettings mediaConnectSettings;

    private MultiplexOutputDestination(BuilderImpl builder) {
        this.mediaConnectSettings = builder.mediaConnectSettings;
    }

    /**
     * Multiplex MediaConnect output destination settings.
     * 
     * @return Multiplex MediaConnect output destination settings.
     */
    public final MultiplexMediaConnectOutputDestinationSettings mediaConnectSettings() {
        return mediaConnectSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaConnectSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexOutputDestination)) {
            return false;
        }
        MultiplexOutputDestination other = (MultiplexOutputDestination) obj;
        return Objects.equals(mediaConnectSettings(), other.mediaConnectSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiplexOutputDestination").add("MediaConnectSettings", mediaConnectSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaConnectSettings":
            return Optional.ofNullable(clazz.cast(mediaConnectSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexOutputDestination, T> g) {
        return obj -> g.apply((MultiplexOutputDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexOutputDestination> {
        /**
         * Multiplex MediaConnect output destination settings.
         * 
         * @param mediaConnectSettings
         *        Multiplex MediaConnect output destination settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectSettings(MultiplexMediaConnectOutputDestinationSettings mediaConnectSettings);

        /**
         * Multiplex MediaConnect output destination settings. This is a convenience that creates an instance of the
         * {@link MultiplexMediaConnectOutputDestinationSettings.Builder} avoiding the need to create one manually via
         * {@link MultiplexMediaConnectOutputDestinationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexMediaConnectOutputDestinationSettings.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #mediaConnectSettings(MultiplexMediaConnectOutputDestinationSettings)}.
         * 
         * @param mediaConnectSettings
         *        a consumer that will call methods on {@link MultiplexMediaConnectOutputDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConnectSettings(MultiplexMediaConnectOutputDestinationSettings)
         */
        default Builder mediaConnectSettings(Consumer<MultiplexMediaConnectOutputDestinationSettings.Builder> mediaConnectSettings) {
            return mediaConnectSettings(MultiplexMediaConnectOutputDestinationSettings.builder()
                    .applyMutation(mediaConnectSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MultiplexMediaConnectOutputDestinationSettings mediaConnectSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexOutputDestination model) {
            mediaConnectSettings(model.mediaConnectSettings);
        }

        public final MultiplexMediaConnectOutputDestinationSettings.Builder getMediaConnectSettings() {
            return mediaConnectSettings != null ? mediaConnectSettings.toBuilder() : null;
        }

        @Override
        public final Builder mediaConnectSettings(MultiplexMediaConnectOutputDestinationSettings mediaConnectSettings) {
            this.mediaConnectSettings = mediaConnectSettings;
            return this;
        }

        public final void setMediaConnectSettings(MultiplexMediaConnectOutputDestinationSettings.BuilderImpl mediaConnectSettings) {
            this.mediaConnectSettings = mediaConnectSettings != null ? mediaConnectSettings.build() : null;
        }

        @Override
        public MultiplexOutputDestination build() {
            return new MultiplexOutputDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
