/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Hls Output Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsOutputSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsOutputSettings.Builder, HlsOutputSettings> {
    private static final SdkField<String> H265_PACKAGING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("H265PackagingType").getter(getter(HlsOutputSettings::h265PackagingTypeAsString))
            .setter(setter(Builder::h265PackagingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h265PackagingType").build()).build();

    private static final SdkField<HlsSettings> HLS_SETTINGS_FIELD = SdkField.<HlsSettings> builder(MarshallingType.SDK_POJO)
            .memberName("HlsSettings").getter(getter(HlsOutputSettings::hlsSettings)).setter(setter(Builder::hlsSettings))
            .constructor(HlsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsSettings").build()).build();

    private static final SdkField<String> NAME_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameModifier").getter(getter(HlsOutputSettings::nameModifier)).setter(setter(Builder::nameModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameModifier").build()).build();

    private static final SdkField<String> SEGMENT_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentModifier").getter(getter(HlsOutputSettings::segmentModifier))
            .setter(setter(Builder::segmentModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentModifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(H265_PACKAGING_TYPE_FIELD,
            HLS_SETTINGS_FIELD, NAME_MODIFIER_FIELD, SEGMENT_MODIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String h265PackagingType;

    private final HlsSettings hlsSettings;

    private final String nameModifier;

    private final String segmentModifier;

    private HlsOutputSettings(BuilderImpl builder) {
        this.h265PackagingType = builder.h265PackagingType;
        this.hlsSettings = builder.hlsSettings;
        this.nameModifier = builder.nameModifier;
        this.segmentModifier = builder.segmentModifier;
    }

    /**
     * Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments should
     * be packaged as HEV1 or HVC1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #h265PackagingType}
     * will return {@link HlsH265PackagingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #h265PackagingTypeAsString}.
     * </p>
     * 
     * @return Only applicable when this output is referencing an H.265 video description. Specifies whether MP4
     *         segments should be packaged as HEV1 or HVC1.
     * @see HlsH265PackagingType
     */
    public final HlsH265PackagingType h265PackagingType() {
        return HlsH265PackagingType.fromValue(h265PackagingType);
    }

    /**
     * Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments should
     * be packaged as HEV1 or HVC1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #h265PackagingType}
     * will return {@link HlsH265PackagingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #h265PackagingTypeAsString}.
     * </p>
     * 
     * @return Only applicable when this output is referencing an H.265 video description. Specifies whether MP4
     *         segments should be packaged as HEV1 or HVC1.
     * @see HlsH265PackagingType
     */
    public final String h265PackagingTypeAsString() {
        return h265PackagingType;
    }

    /**
     * Settings regarding the underlying stream. These settings are different for audio-only outputs.
     * 
     * @return Settings regarding the underlying stream. These settings are different for audio-only outputs.
     */
    public final HlsSettings hlsSettings() {
        return hlsSettings;
    }

    /**
     * String concatenated to the end of the destination filename. Accepts \"Format
     * Identifiers\":#formatIdentifierParameters.
     * 
     * @return String concatenated to the end of the destination filename. Accepts \"Format
     *         Identifiers\":#formatIdentifierParameters.
     */
    public final String nameModifier() {
        return nameModifier;
    }

    /**
     * String concatenated to end of segment filenames.
     * 
     * @return String concatenated to end of segment filenames.
     */
    public final String segmentModifier() {
        return segmentModifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(h265PackagingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(nameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(segmentModifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsOutputSettings)) {
            return false;
        }
        HlsOutputSettings other = (HlsOutputSettings) obj;
        return Objects.equals(h265PackagingTypeAsString(), other.h265PackagingTypeAsString())
                && Objects.equals(hlsSettings(), other.hlsSettings()) && Objects.equals(nameModifier(), other.nameModifier())
                && Objects.equals(segmentModifier(), other.segmentModifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsOutputSettings").add("H265PackagingType", h265PackagingTypeAsString())
                .add("HlsSettings", hlsSettings()).add("NameModifier", nameModifier()).add("SegmentModifier", segmentModifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "H265PackagingType":
            return Optional.ofNullable(clazz.cast(h265PackagingTypeAsString()));
        case "HlsSettings":
            return Optional.ofNullable(clazz.cast(hlsSettings()));
        case "NameModifier":
            return Optional.ofNullable(clazz.cast(nameModifier()));
        case "SegmentModifier":
            return Optional.ofNullable(clazz.cast(segmentModifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsOutputSettings, T> g) {
        return obj -> g.apply((HlsOutputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsOutputSettings> {
        /**
         * Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments
         * should be packaged as HEV1 or HVC1.
         * 
         * @param h265PackagingType
         *        Only applicable when this output is referencing an H.265 video description. Specifies whether MP4
         *        segments should be packaged as HEV1 or HVC1.
         * @see HlsH265PackagingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsH265PackagingType
         */
        Builder h265PackagingType(String h265PackagingType);

        /**
         * Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments
         * should be packaged as HEV1 or HVC1.
         * 
         * @param h265PackagingType
         *        Only applicable when this output is referencing an H.265 video description. Specifies whether MP4
         *        segments should be packaged as HEV1 or HVC1.
         * @see HlsH265PackagingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsH265PackagingType
         */
        Builder h265PackagingType(HlsH265PackagingType h265PackagingType);

        /**
         * Settings regarding the underlying stream. These settings are different for audio-only outputs.
         * 
         * @param hlsSettings
         *        Settings regarding the underlying stream. These settings are different for audio-only outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsSettings(HlsSettings hlsSettings);

        /**
         * Settings regarding the underlying stream. These settings are different for audio-only outputs. This is a
         * convenience that creates an instance of the {@link HlsSettings.Builder} avoiding the need to create one
         * manually via {@link HlsSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #hlsSettings(HlsSettings)}.
         * 
         * @param hlsSettings
         *        a consumer that will call methods on {@link HlsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsSettings(HlsSettings)
         */
        default Builder hlsSettings(Consumer<HlsSettings.Builder> hlsSettings) {
            return hlsSettings(HlsSettings.builder().applyMutation(hlsSettings).build());
        }

        /**
         * String concatenated to the end of the destination filename. Accepts \"Format
         * Identifiers\":#formatIdentifierParameters.
         * 
         * @param nameModifier
         *        String concatenated to the end of the destination filename. Accepts \"Format
         *        Identifiers\":#formatIdentifierParameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameModifier(String nameModifier);

        /**
         * String concatenated to end of segment filenames.
         * 
         * @param segmentModifier
         *        String concatenated to end of segment filenames.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentModifier(String segmentModifier);
    }

    static final class BuilderImpl implements Builder {
        private String h265PackagingType;

        private HlsSettings hlsSettings;

        private String nameModifier;

        private String segmentModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsOutputSettings model) {
            h265PackagingType(model.h265PackagingType);
            hlsSettings(model.hlsSettings);
            nameModifier(model.nameModifier);
            segmentModifier(model.segmentModifier);
        }

        public final String getH265PackagingType() {
            return h265PackagingType;
        }

        @Override
        public final Builder h265PackagingType(String h265PackagingType) {
            this.h265PackagingType = h265PackagingType;
            return this;
        }

        @Override
        public final Builder h265PackagingType(HlsH265PackagingType h265PackagingType) {
            this.h265PackagingType(h265PackagingType == null ? null : h265PackagingType.toString());
            return this;
        }

        public final void setH265PackagingType(String h265PackagingType) {
            this.h265PackagingType = h265PackagingType;
        }

        public final HlsSettings.Builder getHlsSettings() {
            return hlsSettings != null ? hlsSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsSettings(HlsSettings hlsSettings) {
            this.hlsSettings = hlsSettings;
            return this;
        }

        public final void setHlsSettings(HlsSettings.BuilderImpl hlsSettings) {
            this.hlsSettings = hlsSettings != null ? hlsSettings.build() : null;
        }

        public final String getNameModifier() {
            return nameModifier;
        }

        @Override
        public final Builder nameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
            return this;
        }

        public final void setNameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
        }

        public final String getSegmentModifier() {
            return segmentModifier;
        }

        @Override
        public final Builder segmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
            return this;
        }

        public final void setSegmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
        }

        @Override
        public HlsOutputSettings build() {
            return new HlsOutputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
